/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.transport;

import com.trilead.ssh2.crypto.cipher.BlockCipher;
import com.trilead.ssh2.crypto.cipher.CipherInputStream;
import com.trilead.ssh2.crypto.cipher.CipherOutputStream;
import com.trilead.ssh2.crypto.cipher.NullCipher;
import com.trilead.ssh2.crypto.digest.MessageMac;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.Packets;
import com.trilead.ssh2.transport.ClientServerHello;
import com.trilead.ssh2.transport.TransportManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public class TransportConnection {
    private static final Logger log = Logger.getLogger(TransportConnection.class);
    int send_seq_number = 0;
    int recv_seq_number = 0;
    CipherInputStream cis;
    CipherOutputStream cos;
    boolean useRandomPadding = false;
    MessageMac send_mac;
    byte[] send_mac_buffer;
    int send_padd_blocksize = 8;
    MessageMac recv_mac;
    byte[] recv_mac_buffer;
    byte[] recv_mac_buffer_cmp;
    int recv_padd_blocksize = 8;
    final byte[] send_padding_buffer = new byte[256];
    final byte[] send_packet_header_buffer = new byte[5];
    final byte[] recv_padding_buffer = new byte[256];
    final byte[] recv_packet_header_buffer = new byte[5];
    boolean recv_packet_header_present = false;
    ClientServerHello csh;
    final SecureRandom rnd;

    public TransportConnection(InputStream is, OutputStream os, SecureRandom rnd) {
        this.cis = new CipherInputStream(new NullCipher(), is);
        this.cos = new CipherOutputStream(new NullCipher(), os);
        this.rnd = rnd;
    }

    public void changeRecvCipher(BlockCipher bc, MessageMac mac) {
        this.cis.changeCipher(bc);
        this.recv_mac = mac;
        this.recv_mac_buffer = mac != null ? new byte[mac.size()] : null;
        this.recv_mac_buffer_cmp = mac != null ? new byte[mac.size()] : null;
        this.recv_padd_blocksize = bc.getBlockSize();
        if (this.recv_padd_blocksize < 8) {
            this.recv_padd_blocksize = 8;
        }
    }

    public void changeSendCipher(BlockCipher bc, MessageMac mac) {
        if (!(bc instanceof NullCipher)) {
            this.useRandomPadding = true;
        }
        this.cos.changeCipher(bc);
        this.send_mac = mac;
        this.send_mac_buffer = mac != null ? new byte[mac.size()] : null;
        this.send_padd_blocksize = bc.getBlockSize();
        if (this.send_padd_blocksize < 8) {
            this.send_padd_blocksize = 8;
        }
    }

    public void sendMessage(byte[] message) throws IOException {
        this.sendMessage(message, 0, message.length, 0);
    }

    public void sendMessage(byte[] message, int off, int len) throws IOException {
        this.sendMessage(message, off, len, 0);
    }

    public int getPacketOverheadEstimate() {
        return 9 + (this.send_padd_blocksize - 1) + this.send_mac_buffer.length;
    }

    public void sendMessage(byte[] message, int off, int len, int padd) throws IOException {
        if (padd < 4) {
            padd = 4;
        } else if (padd > 64) {
            padd = 64;
        }
        boolean encryptThenMac = this.send_mac != null && this.send_mac.isEncryptThenMac();
        int packet_len = (encryptThenMac ? 1 : 5) + len + padd;
        int slack = packet_len % this.send_padd_blocksize;
        if (slack != 0) {
            packet_len += this.send_padd_blocksize - slack;
        }
        if (packet_len < 16) {
            packet_len = 16;
        }
        int padd_len = packet_len - ((encryptThenMac ? 1 : 5) + len);
        if (this.useRandomPadding) {
            for (i = 0; i < padd_len; i += 4) {
                int r = this.rnd.nextInt();
                this.send_padding_buffer[i] = (byte)r;
                this.send_padding_buffer[i + 1] = (byte)(r >> 8);
                this.send_padding_buffer[i + 2] = (byte)(r >> 16);
                this.send_padding_buffer[i + 3] = (byte)(r >> 24);
            }
        } else {
            for (i = 0; i < padd_len; ++i) {
                this.send_padding_buffer[i] = 0;
            }
        }
        int payloadLength = encryptThenMac ? packet_len : packet_len - 4;
        this.send_packet_header_buffer[0] = (byte)(packet_len >> 24);
        this.send_packet_header_buffer[1] = (byte)(payloadLength >> 16);
        this.send_packet_header_buffer[2] = (byte)(payloadLength >> 8);
        this.send_packet_header_buffer[3] = (byte)payloadLength;
        this.send_packet_header_buffer[4] = (byte)padd_len;
        if (this.send_mac != null && this.send_mac.isEncryptThenMac()) {
            this.cos.writePlain(this.send_packet_header_buffer, 0, 4);
            this.cos.startRecording();
            this.cos.write(this.send_packet_header_buffer, 4, 1);
        } else {
            this.cos.write(this.send_packet_header_buffer, 0, 5);
        }
        this.cos.write(message, off, len);
        this.cos.write(this.send_padding_buffer, 0, padd_len);
        if (this.send_mac != null) {
            this.send_mac.initMac(this.send_seq_number);
            if (this.send_mac.isEncryptThenMac()) {
                this.send_mac.update(this.send_packet_header_buffer, 0, 4);
                byte[] encryptedMessage = this.cos.getRecordedOutput();
                this.send_mac.update(encryptedMessage, 0, encryptedMessage.length);
            } else {
                this.send_mac.update(this.send_packet_header_buffer, 0, 5);
                this.send_mac.update(message, off, len);
                this.send_mac.update(this.send_padding_buffer, 0, padd_len);
            }
            this.send_mac.getMac(this.send_mac_buffer, 0);
            this.cos.writePlain(this.send_mac_buffer, 0, this.send_mac_buffer.length);
        }
        this.cos.flush();
        if (log.isEnabled()) {
            log.log(90, "Sent " + Packets.getMessageName(message[off] & 0xFF) + " " + len + " bytes payload");
        }
        ++this.send_seq_number;
    }

    public int peekNextMessageLength() throws IOException {
        if (!this.recv_packet_header_present) {
            this.cis.read(this.recv_packet_header_buffer, 0, 5);
            this.recv_packet_header_present = true;
        }
        int packet_length = (this.recv_packet_header_buffer[0] & 0xFF) << 24 | (this.recv_packet_header_buffer[1] & 0xFF) << 16 | (this.recv_packet_header_buffer[2] & 0xFF) << 8 | this.recv_packet_header_buffer[3] & 0xFF;
        int padding_length = this.recv_packet_header_buffer[4] & 0xFF;
        if (packet_length > TransportManager.MAX_PACKET_SIZE || packet_length < 12) {
            throw new IOException("Illegal packet size! (" + packet_length + ")");
        }
        int payload_length = packet_length - padding_length - 1;
        if (payload_length < 0) {
            throw new IOException("Illegal padding_length in packet from remote (" + padding_length + ")");
        }
        return payload_length;
    }

    public int receiveMessage(byte[] buffer, int off, int len) throws IOException {
        int packetLength;
        if (this.recv_mac != null && this.recv_mac.isEncryptThenMac()) {
            this.cis.readPlain(this.recv_packet_header_buffer, 0, 4);
            packetLength = TransportConnection.getPacketLength(this.recv_packet_header_buffer, true);
            this.recv_mac.initMac(this.recv_seq_number);
            this.recv_mac.update(this.recv_packet_header_buffer, 0, 4);
            this.cis.peekPlain(buffer, off, packetLength + this.recv_mac_buffer.length);
            System.arraycopy(buffer, off + packetLength, this.recv_mac_buffer, 0, this.recv_mac_buffer.length);
            this.recv_mac.update(buffer, off, packetLength);
            this.recv_mac.getMac(this.recv_mac_buffer_cmp, 0);
            TransportConnection.checkMacMatches(this.recv_mac_buffer, this.recv_mac_buffer_cmp);
            this.cis.read(this.recv_packet_header_buffer, 4, 1);
        } else {
            this.cis.read(this.recv_packet_header_buffer, 0, 5);
            packetLength = TransportConnection.getPacketLength(this.recv_packet_header_buffer, false);
        }
        int paddingLength = this.recv_packet_header_buffer[4] & 0xFF;
        int payloadLength = TransportConnection.calculatePayloadLength(len, packetLength, paddingLength);
        this.cis.read(buffer, off, payloadLength);
        this.cis.read(this.recv_padding_buffer, 0, paddingLength);
        if (this.recv_mac != null) {
            this.cis.readPlain(this.recv_mac_buffer, 0, this.recv_mac_buffer.length);
            if (!this.recv_mac.isEncryptThenMac()) {
                this.recv_mac.initMac(this.recv_seq_number);
                this.recv_mac.update(this.recv_packet_header_buffer, 0, 5);
                this.recv_mac.update(buffer, off, payloadLength);
                this.recv_mac.update(this.recv_padding_buffer, 0, paddingLength);
                this.recv_mac.getMac(this.recv_mac_buffer_cmp, 0);
                TransportConnection.checkMacMatches(this.recv_mac_buffer, this.recv_mac_buffer_cmp);
            }
        }
        ++this.recv_seq_number;
        if (log.isEnabled()) {
            log.log(90, "Received " + Packets.getMessageName(buffer[off] & 0xFF) + " " + payloadLength + " bytes payload");
        }
        return payloadLength;
    }

    private static int calculatePayloadLength(int bufferLength, int packetLength, int paddingLength) throws IOException {
        int payloadLength = packetLength - paddingLength - 1;
        if (payloadLength < 0) {
            throw new IOException("Illegal padding_length in packet from remote (" + paddingLength + ")");
        }
        if (payloadLength >= bufferLength) {
            throw new IOException("Receive buffer too small (" + bufferLength + ", need " + payloadLength + ")");
        }
        return payloadLength;
    }

    private static void checkMacMatches(byte[] buf1, byte[] buf2) throws IOException {
        int difference = 0;
        for (int i = 0; i < buf1.length; ++i) {
            difference |= buf1[i] ^ buf2[i];
        }
        if (difference != 0) {
            throw new IOException("Remote sent corrupt MAC.");
        }
    }

    private static int getPacketLength(byte[] packetHeader, boolean isEtm) throws IOException {
        int packetLength = (packetHeader[0] & 0xFF) << 24 | (packetHeader[1] & 0xFF) << 16 | (packetHeader[2] & 0xFF) << 8 | packetHeader[3] & 0xFF;
        if (packetLength > TransportManager.MAX_PACKET_SIZE || packetLength < (isEtm ? 8 : 12)) {
            throw new IOException("Illegal packet size! (" + packetLength + ")");
        }
        return packetLength;
    }
}

