/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.jenkins;

import com.trilead.ssh2.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FilterAlgorithms {
    private static final String ALGORITHMS = ".algorithms";
    private static final String ENABLED = ".enabled";
    private static final Logger LOGGER = Logger.getLogger(FilterAlgorithms.class);
    private final String isEnabledFilterProperty;
    private final String filteredAlgorithmsProperty;
    private List<String> filteredAlgorithms = new ArrayList<String>();

    public FilterAlgorithms(String clazz, List<String> filteredAlgorithms) {
        this.filteredAlgorithms = filteredAlgorithms;
        this.isEnabledFilterProperty = clazz + ENABLED;
        this.filteredAlgorithmsProperty = clazz + ALGORITHMS;
    }

    public String[] filter(String[] algorithms) {
        String[] ret = Collections.emptySet().toArray(new String[0]);
        if (algorithms != null) {
            if (!this.isEnabled()) {
                LOGGER.log(20, "Algorithms filter is disabled");
                ret = algorithms;
            } else {
                ret = (String[])Arrays.stream(algorithms).filter(x -> !this.getFilteredAlgorithms().contains(x)).toArray(String[]::new);
            }
        } else {
            LOGGER.log(20, "Algorithms is null");
        }
        return ret;
    }

    private boolean isEnabled() {
        return Boolean.parseBoolean(System.getProperty(this.isEnabledFilterProperty, "true"));
    }

    private List<String> getFilteredAlgorithms() {
        List<Object> ret = new ArrayList();
        ret = System.getProperty(this.filteredAlgorithmsProperty) != null && !System.getProperty(this.filteredAlgorithmsProperty).isEmpty() ? Arrays.asList(System.getProperty(this.filteredAlgorithmsProperty).split(",")) : this.filteredAlgorithms;
        return ret;
    }

    public String getIsEnabledFilterProperty() {
        return this.isEnabledFilterProperty;
    }

    public String getFilteredAlgorithmsProperty() {
        return this.filteredAlgorithmsProperty;
    }
}

