/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto;

import java.io.IOException;
import java.math.BigInteger;

public class SimpleDERReader {
    byte[] buffer;
    int pos;
    int count;

    public SimpleDERReader(byte[] b) {
        this.resetInput(b);
    }

    public SimpleDERReader(byte[] b, int off, int len) {
        this.resetInput(b, off, len);
    }

    public void resetInput(byte[] b) {
        this.resetInput(b, 0, b.length);
    }

    public void resetInput(byte[] b, int off, int len) {
        this.buffer = b;
        this.pos = off;
        this.count = len;
    }

    private byte readByte() throws IOException {
        if (this.count <= 0) {
            throw new IOException("DER byte array: out of data");
        }
        --this.count;
        return this.buffer[this.pos++];
    }

    private byte[] readBytes(int len) throws IOException {
        if (len > this.count) {
            throw new IOException("DER byte array: out of data");
        }
        byte[] b = new byte[len];
        System.arraycopy(this.buffer, this.pos, b, 0, len);
        this.pos += len;
        this.count -= len;
        return b;
    }

    public int available() {
        return this.count;
    }

    int readLength() throws IOException {
        int len = this.readByte() & 0xFF;
        if ((len & 0x80) == 0) {
            return len;
        }
        int remain = len & 0x7F;
        if (remain == 0 || remain > 4) {
            return -1;
        }
        len = 0;
        while (remain > 0) {
            len <<= 8;
            len |= this.readByte() & 0xFF;
            --remain;
        }
        if (len < 0) {
            return -1;
        }
        return len;
    }

    public int ignoreNextObject() throws IOException {
        int type = this.readByte() & 0xFF;
        int len = this.readLength();
        if (len < 0 || len > this.available()) {
            throw new IOException("Illegal len in DER object (" + len + ")");
        }
        this.readBytes(len);
        return type;
    }

    public BigInteger readInt() throws IOException {
        int type = this.readByte() & 0xFF;
        if (type != 2) {
            throw new IOException("Expected DER Integer, but found type " + type);
        }
        int len = this.readLength();
        if (len < 0 || len > this.available()) {
            throw new IOException("Illegal len in DER object (" + len + ")");
        }
        byte[] b = this.readBytes(len);
        BigInteger bi = new BigInteger(1, b);
        return bi;
    }

    public byte[] readSequenceAsByteArray() throws IOException {
        int type = this.readByte() & 0xFF;
        if (type != 48) {
            throw new IOException("Expected DER Sequence, but found type " + type);
        }
        int len = this.readLength();
        if (len < 0 || len > this.available()) {
            throw new IOException("Illegal len in DER object (" + len + ")");
        }
        byte[] b = this.readBytes(len);
        return b;
    }

    public String readOid() throws IOException {
        int type = this.readByte() & 0xFF;
        if (type != 6) {
            throw new IOException("Expected DER OID, but found type " + type);
        }
        int len = this.readLength();
        if (len < 1 || len > this.available()) {
            throw new IOException("Illegal len in DER object (" + len + ")");
        }
        byte[] b = this.readBytes(len);
        long value = 0L;
        StringBuilder sb = new StringBuilder(64);
        switch (b[0] / 40) {
            case 0: {
                sb.append('0');
                break;
            }
            case 1: {
                sb.append('1');
                b[0] = (byte)(b[0] - 40);
                break;
            }
            default: {
                sb.append('2');
                b[0] = (byte)(b[0] - 80);
            }
        }
        for (int i = 0; i < len; ++i) {
            value = (value << 7) + (long)(b[i] & 0x7F);
            if ((b[i] & 0x80) != 0) continue;
            sb.append('.');
            sb.append(value);
            value = 0L;
        }
        return sb.toString();
    }

    public SimpleDERReader readConstructed() throws IOException {
        int length = this.readLength();
        if (length < 0 || length > this.available()) {
            throw new IOException("Illegal length in DER object (" + length + ")");
        }
        SimpleDERReader reader = new SimpleDERReader(this.buffer, this.pos, length);
        this.pos += length;
        this.count -= length;
        return reader;
    }

    public int readConstructedType() throws IOException {
        int type = this.readByte() & 0xFF;
        if ((type & 0x20) != 32) {
            throw new IOException("Expected constructed type, but was " + type);
        }
        return type & 0x1F;
    }

    public byte[] readOctetString() throws IOException {
        int type = this.readByte() & 0xFF;
        if (type != 4 && type != 3) {
            throw new IOException("Expected DER Octetstring, but found type " + type);
        }
        int len = this.readLength();
        if (len < 0 || len > this.available()) {
            throw new IOException("Illegal len in DER object (" + len + ")");
        }
        byte[] b = this.readBytes(len);
        return b;
    }
}

