/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.channel;

import java.io.IOException;
import java.io.OutputStream;

class FifoBuffer {
    private static final String PROPERTY_TIMEOUT = FifoBuffer.class.getName() + ".timeout";
    private static long DEFAULT_WAIT_TIMEOUT = Long.parseLong(System.getProperty(PROPERTY_TIMEOUT, "1200000"));
    private final Object lock;
    private int sz;
    private int limit;
    private final int pageSize;
    private Pointer r;
    private Pointer w;
    private boolean closed;

    FifoBuffer(int pageSize, int limit) {
        this(null, pageSize, limit);
    }

    FifoBuffer(Object lock, int pageSize, int limit) {
        this.lock = lock == null ? this : lock;
        this.limit = limit;
        this.pageSize = pageSize;
        Page p = this.newPage();
        this.r = new Pointer(p, 0);
        this.w = new Pointer(p, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimit(int newLimit) {
        Object object = this.lock;
        synchronized (object) {
            this.limit = newLimit;
        }
    }

    private Page newPage() {
        return new Page(this.pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readable() {
        Object object = this.lock;
        synchronized (object) {
            return this.sz;
        }
    }

    int writable() {
        return Math.max(0, this.limit - this.readable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int start, int len) throws InterruptedException {
        while (len > 0) {
            Object object = this.lock;
            synchronized (object) {
                int chunk;
                while ((chunk = Math.min(len, this.writable())) == 0) {
                    this.lock.wait(DEFAULT_WAIT_TIMEOUT);
                }
                this.w.write(buf, start, chunk);
                start += chunk;
                len -= chunk;
                this.sz += chunk;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                this.releaseRing();
                this.lock.notifyAll();
            }
        }
    }

    private void releaseRing() {
        if (this.closed && this.readable() == 0) {
            this.w = null;
            this.r = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf, int start, int len) throws InterruptedException {
        if (len == 0) {
            return 0;
        }
        int read = 0;
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                int chunk;
                while ((chunk = Math.min(len, this.readable())) <= 0) {
                    if (read > 0) {
                        return read;
                    }
                    if (this.closed) {
                        this.releaseRing();
                        return -1;
                    }
                    this.lock.wait(DEFAULT_WAIT_TIMEOUT);
                }
                this.r.read(buf, start, chunk);
                start += chunk;
                len -= chunk;
                read += chunk;
                this.sz -= chunk;
                this.lock.notifyAll();
            }
        }
    }

    public int writeTo(OutputStream out) throws IOException {
        try {
            int total = 0;
            while (this.readable() > 0) {
                byte[] buf = new byte[1024];
                int read = this.read(buf, 0, buf.length);
                out.write(buf, 0, read);
                total += read;
            }
            return total;
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    static final class Page {
        final byte[] buf;
        Page next;

        Page(int sz) {
            this.buf = new byte[sz];
        }
    }

    class Pointer {
        Page p;
        int off;

        Pointer(Page p, int off) {
            this.p = p;
            this.off = off;
        }

        private int chunk() {
            int sz = FifoBuffer.this.pageSize - this.off;
            assert (sz >= 0);
            if (sz > 0) {
                return sz;
            }
            Page q = this.p.next;
            if (q == null) {
                q = this.p.next = FifoBuffer.this.newPage();
            }
            this.p = q;
            this.off = 0;
            return FifoBuffer.this.pageSize;
        }

        public void write(byte[] buf, int start, int len) {
            while (len > 0) {
                int chunk = Math.min(len, this.chunk());
                System.arraycopy(buf, start, this.p.buf, this.off, chunk);
                this.off += chunk;
                len -= chunk;
                start += chunk;
            }
        }

        public void read(byte[] buf, int start, int len) {
            while (len > 0) {
                int chunk = Math.min(len, this.chunk());
                System.arraycopy(this.p.buf, this.off, buf, start, chunk);
                this.off += chunk;
                len -= chunk;
                start += chunk;
            }
        }
    }
}

