/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.auth;

import com.trilead.ssh2.InteractiveCallback;
import com.trilead.ssh2.auth.AgentIdentity;
import com.trilead.ssh2.auth.AgentProxy;
import com.trilead.ssh2.crypto.PEMDecoder;
import com.trilead.ssh2.packets.PacketServiceAccept;
import com.trilead.ssh2.packets.PacketServiceRequest;
import com.trilead.ssh2.packets.PacketUserauthBanner;
import com.trilead.ssh2.packets.PacketUserauthFailure;
import com.trilead.ssh2.packets.PacketUserauthInfoRequest;
import com.trilead.ssh2.packets.PacketUserauthInfoResponse;
import com.trilead.ssh2.packets.PacketUserauthRequestGssapiWithMic;
import com.trilead.ssh2.packets.PacketUserauthRequestInteractive;
import com.trilead.ssh2.packets.PacketUserauthRequestNone;
import com.trilead.ssh2.packets.PacketUserauthRequestPassword;
import com.trilead.ssh2.packets.PacketUserauthRequestPublicKey;
import com.trilead.ssh2.packets.PacketUserauthTokenGssapiWithMic;
import com.trilead.ssh2.packets.Packets;
import com.trilead.ssh2.packets.TypesWriter;
import com.trilead.ssh2.signature.KeyAlgorithm;
import com.trilead.ssh2.signature.KeyAlgorithmManager;
import com.trilead.ssh2.transport.MessageHandler;
import com.trilead.ssh2.transport.TransportManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;

public class AuthenticationManager
implements MessageHandler {
    public static final String PROPERTY_TIMEOUT = AuthenticationManager.class.getName() + ".timeout";
    public static final long TIMEOUT = Long.valueOf(System.getProperty(PROPERTY_TIMEOUT, "120000"));
    TransportManager tm;
    Vector packets = new Vector();
    boolean connectionClosed = false;
    String banner;
    String[] remainingMethods = new String[0];
    boolean isPartialSuccess = false;
    boolean authenticated = false;
    boolean initDone = false;

    public AuthenticationManager(TransportManager tm) {
        this.tm = tm;
    }

    boolean methodPossible(String methName) {
        if (this.remainingMethods == null) {
            return false;
        }
        for (String remainingMethod : this.remainingMethods) {
            if (remainingMethod.compareTo(methName) != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] deQueue() throws IOException {
        Vector vector = this.packets;
        synchronized (vector) {
            long waitUntil = System.currentTimeMillis() + TIMEOUT;
            long now = System.currentTimeMillis();
            while (this.packets.size() == 0 && now < waitUntil) {
                if (this.connectionClosed) {
                    throw new IOException("The connection is closed.", this.tm.getReasonClosedCause());
                }
                try {
                    this.packets.wait(TIMEOUT);
                }
                catch (InterruptedException ign) {
                    throw new InterruptedIOException(ign.getMessage());
                }
                now = System.currentTimeMillis();
            }
            if (this.packets.size() == 0) {
                throw new IOException("No valid packets after " + TIMEOUT + " milliseconds, you can increase the timeout by setting the property -D" + PROPERTY_TIMEOUT + "=<MILLISECONDS>");
            }
            byte[] res = (byte[])this.packets.firstElement();
            this.packets.removeElementAt(0);
            return res;
        }
    }

    byte[] getNextMessage() throws IOException {
        byte[] msg;
        while ((msg = this.deQueue())[0] == 53) {
            PacketUserauthBanner sb = new PacketUserauthBanner(msg, 0, msg.length);
            this.banner = sb.getBanner();
        }
        return msg;
    }

    public String[] getRemainingMethods(String user) throws IOException {
        this.initialize(user);
        return this.remainingMethods;
    }

    public boolean getPartialSuccess() {
        return this.isPartialSuccess;
    }

    private boolean initialize(String user) throws IOException {
        if (!this.initDone) {
            this.tm.registerMessageHandler(this, 0, 255);
            PacketServiceRequest sr = new PacketServiceRequest("ssh-userauth");
            this.tm.sendMessage(sr.getPayload());
            PacketUserauthRequestNone urn = new PacketUserauthRequestNone("ssh-connection", user);
            this.tm.sendMessage(urn.getPayload());
            byte[] msg = this.getNextMessage();
            new PacketServiceAccept(msg, 0, msg.length);
            msg = this.getNextMessage();
            this.initDone = true;
            if (msg[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (msg[0] == 51) {
                PacketUserauthFailure puf = new PacketUserauthFailure(msg, 0, msg.length);
                this.remainingMethods = puf.getAuthThatCanContinue();
                this.isPartialSuccess = puf.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + msg[0] + ")");
        }
        return this.authenticated;
    }

    public boolean authenticateGssapiWithMic(String user, String host) throws IOException {
        this.initialize(user);
        PacketUserauthRequestGssapiWithMic ua = new PacketUserauthRequestGssapiWithMic(user);
        this.tm.sendMessage(ua.getPayload());
        byte[] message = this.getNextMessage();
        if (message[0] == 51) {
            return false;
        }
        if (message[0] == 60) {
            PacketUserauthTokenGssapiWithMic uat = new PacketUserauthTokenGssapiWithMic(user, host);
            this.tm.sendMessage(uat.getTokenPayload());
            message = this.getNextMessage();
            if (message[0] == 61) {
                this.tm.sendMessage(uat.getMicPayload(this.tm.getSessionIdentifier()));
                message = this.getNextMessage();
                if (message[0] == 52) {
                    this.authenticated = true;
                    this.tm.removeMessageHandler(this, 0, 255);
                    return true;
                }
                if (message[0] == 51) {
                    PacketUserauthFailure puf = new PacketUserauthFailure(message, 0, message.length);
                    this.remainingMethods = puf.getAuthThatCanContinue();
                    this.isPartialSuccess = puf.isPartialSuccess();
                    return false;
                }
            }
        }
        throw new IOException("Unexpected SSH message (type " + message[0] + ")");
    }

    public boolean authenticatePublicKey(String user, AgentProxy proxy) throws IOException {
        this.initialize(user);
        for (AgentIdentity identity : proxy.getIdentities()) {
            boolean success = this.authenticatePublicKey(user, proxy, identity);
            if (!success) continue;
            return true;
        }
        return false;
    }

    boolean authenticatePublicKey(String user, AgentProxy proxy, AgentIdentity identity) throws IOException {
        if (!this.methodPossible("publickey")) {
            throw new IOException("Authentication method publickey not supported by the server at this stage.");
        }
        byte[] pubKeyBlob = identity.getPublicKeyBlob();
        if (pubKeyBlob == null) {
            return false;
        }
        TypesWriter tw = new TypesWriter();
        byte[] H = this.tm.getSessionIdentifier();
        tw.writeString(H, 0, H.length);
        tw.writeByte(50);
        tw.writeString(user);
        tw.writeString("ssh-connection");
        tw.writeString("publickey");
        tw.writeBoolean(true);
        tw.writeString(identity.getAlgName());
        tw.writeString(pubKeyBlob, 0, pubKeyBlob.length);
        byte[] msg = tw.getBytes();
        byte[] response = identity.sign(msg);
        PacketUserauthRequestPublicKey ua = new PacketUserauthRequestPublicKey("ssh-connection", user, identity.getAlgName(), pubKeyBlob, response);
        this.tm.sendMessage(ua.getPayload());
        byte[] ar = this.getNextMessage();
        if (ar[0] == 52) {
            this.authenticated = true;
            this.tm.removeMessageHandler(this, 0, 255);
            return true;
        }
        if (ar[0] == 51) {
            PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
            this.remainingMethods = puf.getAuthThatCanContinue();
            this.isPartialSuccess = puf.isPartialSuccess();
            return false;
        }
        throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
    }

    public boolean authenticatePublicKey(String user, char[] PEMPrivateKey, String password, SecureRandom rnd) throws IOException {
        try {
            this.initialize(user);
            if (!this.methodPossible("publickey")) {
                throw new IOException("Authentication method publickey not supported by the server at this stage.");
            }
            KeyPair keyPair = PEMDecoder.decodeKeyPair(PEMPrivateKey, password);
            PrivateKey key = keyPair.getPrivate();
            List candidateAlgorithms = KeyAlgorithmManager.getSupportedAlgorithms().stream().filter(alg -> alg.supportsKey(key)).collect(Collectors.toList());
            if (candidateAlgorithms.isEmpty()) {
                throw new IOException("Unknown private key type returned by the PEM decoder.");
            }
            block6: for (KeyAlgorithm algorithm : candidateAlgorithms) {
                byte[] encodedKey = algorithm.encodePublicKey(keyPair.getPublic());
                TypesWriter tw = new TypesWriter();
                byte[] H = this.tm.getSessionIdentifier();
                tw.writeString(H, 0, H.length);
                tw.writeByte(50);
                tw.writeString(user);
                tw.writeString("ssh-connection");
                tw.writeString("publickey");
                tw.writeBoolean(true);
                tw.writeString(algorithm.getKeyFormat());
                tw.writeString(encodedKey, 0, encodedKey.length);
                byte[] msg = tw.getBytes();
                byte[] ds = algorithm.generateSignature(msg, keyPair.getPrivate(), rnd);
                byte[] ds_enc = algorithm.encodeSignature(ds);
                PacketUserauthRequestPublicKey ua = new PacketUserauthRequestPublicKey("ssh-connection", user, algorithm.getKeyFormat(), encodedKey, ds_enc);
                this.tm.sendMessage(ua.getPayload());
                byte[] ar = this.getNextMessage();
                switch (ar[0]) {
                    case 52: {
                        this.authenticated = true;
                        this.tm.removeMessageHandler(this, 0, 255);
                        return true;
                    }
                    case 51: {
                        PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
                        this.remainingMethods = puf.getAuthThatCanContinue();
                        this.isPartialSuccess = puf.isPartialSuccess();
                        continue block6;
                    }
                }
                throw new IOException("Unexpected SSH message (type " + Packets.getMessageName(ar[0]) + ")");
            }
            return false;
        }
        catch (IOException e) {
            this.tm.close(e, false);
            throw new IOException("Publickey authentication failed.", e);
        }
    }

    public boolean authenticateNone(String user) throws IOException {
        try {
            this.initialize(user);
            return this.authenticated;
        }
        catch (IOException e) {
            this.tm.close(e, false);
            throw new IOException("None authentication failed.", e);
        }
    }

    public boolean authenticatePassword(String user, String pass) throws IOException {
        try {
            this.initialize(user);
            if (!this.methodPossible("password")) {
                throw new IOException("Authentication method password not supported by the server at this stage.");
            }
            PacketUserauthRequestPassword ua = new PacketUserauthRequestPassword("ssh-connection", user, pass);
            this.tm.sendMessage(ua.getPayload());
            byte[] ar = this.getNextMessage();
            if (ar[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (ar[0] == 51) {
                PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
                this.remainingMethods = puf.getAuthThatCanContinue();
                this.isPartialSuccess = puf.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
        }
        catch (IOException e) {
            this.tm.close(e, false);
            throw new IOException("Password authentication failed.", e);
        }
    }

    public boolean authenticateInteractive(String user, String[] submethods, InteractiveCallback cb) throws IOException {
        try {
            byte[] ar;
            this.initialize(user);
            if (!this.methodPossible("keyboard-interactive")) {
                throw new IOException("Authentication method keyboard-interactive not supported by the server at this stage.");
            }
            if (submethods == null) {
                submethods = new String[]{};
            }
            PacketUserauthRequestInteractive ua = new PacketUserauthRequestInteractive("ssh-connection", user, submethods);
            this.tm.sendMessage(ua.getPayload());
            while (true) {
                String[] responses;
                if ((ar = this.getNextMessage())[0] == 52) {
                    this.authenticated = true;
                    this.tm.removeMessageHandler(this, 0, 255);
                    return true;
                }
                if (ar[0] == 51) {
                    PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
                    this.remainingMethods = puf.getAuthThatCanContinue();
                    this.isPartialSuccess = puf.isPartialSuccess();
                    return false;
                }
                if (ar[0] != 60) break;
                PacketUserauthInfoRequest pui = new PacketUserauthInfoRequest(ar, 0, ar.length);
                try {
                    responses = cb.replyToChallenge(pui.getName(), pui.getInstruction(), pui.getNumPrompts(), pui.getPrompt(), pui.getEcho());
                }
                catch (Exception e) {
                    throw new IOException("Exception in callback.", e);
                }
                if (responses == null) {
                    throw new IOException("Your callback may not return NULL!");
                }
                PacketUserauthInfoResponse puir = new PacketUserauthInfoResponse(responses);
                this.tm.sendMessage(puir.getPayload());
            }
            throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
        }
        catch (IOException e) {
            this.tm.close(e, false);
            throw new IOException("Keyboard-interactive authentication failed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(byte[] msg, int msglen) throws IOException {
        Vector vector = this.packets;
        synchronized (vector) {
            byte[] tmp = new byte[msglen];
            System.arraycopy(msg, 0, tmp, 0, msglen);
            this.packets.addElement(tmp);
            this.packets.notifyAll();
            if (this.packets.size() > 5) {
                this.connectionClosed = true;
                throw new IOException("Error, peer is flooding us with authentication packets.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEndMessage(Throwable cause) throws IOException {
        Vector vector = this.packets;
        synchronized (vector) {
            this.connectionClosed = true;
            this.packets.notifyAll();
        }
    }
}

