/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.dh;

import com.trilead.ssh2.crypto.dh.GenericDhExchange;
import com.trilead.ssh2.signature.ECDSAKeyAlgorithm;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreement;

public class EcDhExchange
extends GenericDhExchange {
    private ECPrivateKey clientPrivate;
    private ECPublicKey clientPublic;
    private ECPublicKey serverPublic;
    private ECDSAKeyAlgorithm ecdsKeyAlgorithm;

    @Override
    public void init(String name) throws IOException {
        ECParameterSpec spec;
        switch (name) {
            case "ecdh-sha2-nistp256": {
                this.ecdsKeyAlgorithm = new ECDSAKeyAlgorithm.ECDSASha2Nistp256();
                spec = this.ecdsKeyAlgorithm.getEcParameterSpec();
                break;
            }
            case "ecdh-sha2-nistp384": {
                this.ecdsKeyAlgorithm = new ECDSAKeyAlgorithm.ECDSASha2Nistp384();
                spec = this.ecdsKeyAlgorithm.getEcParameterSpec();
                break;
            }
            case "ecdh-sha2-nistp521": {
                this.ecdsKeyAlgorithm = new ECDSAKeyAlgorithm.ECDSASha2Nistp521();
                spec = this.ecdsKeyAlgorithm.getEcParameterSpec();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EC curve " + name);
            }
        }
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
            kpg.initialize(spec);
            KeyPair pair = kpg.generateKeyPair();
            this.clientPrivate = (ECPrivateKey)pair.getPrivate();
            this.clientPublic = (ECPublicKey)pair.getPublic();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("No DH keypair generator", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException("Invalid DH parameters", e);
        }
    }

    @Override
    public byte[] getE() {
        return ECDSAKeyAlgorithm.encodePoint(this.clientPublic.getW(), this.clientPublic.getParams().getCurve());
    }

    @Override
    protected byte[] getServerE() {
        return ECDSAKeyAlgorithm.encodePoint(this.serverPublic.getW(), this.serverPublic.getParams().getCurve());
    }

    @Override
    public void setF(byte[] f) throws IOException {
        KeyAgreement ka;
        if (this.clientPublic == null) {
            throw new IllegalStateException("EcDhExchange not initialized!");
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("EC");
            ECDSAKeyAlgorithm verifier = EcDhExchange.getVerifierForKey(this.clientPublic);
            if (verifier == null) {
                throw new IOException("No such EC group");
            }
            ECParameterSpec params = verifier.getEcParameterSpec();
            ECPoint serverPoint = ECDSAKeyAlgorithm.decodePoint(f, params.getCurve());
            this.serverPublic = (ECPublicKey)kf.generatePublic(new ECPublicKeySpec(serverPoint, params));
            ka = KeyAgreement.getInstance("ECDH");
            ka.init(this.clientPrivate);
            ka.doPhase(this.serverPublic, true);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("No ECDH key agreement method", e);
        }
        catch (InvalidKeyException | InvalidKeySpecException e) {
            throw new IOException("Invalid ECDH key", e);
        }
        this.sharedSecret = new BigInteger(1, ka.generateSecret());
    }

    public static ECDSAKeyAlgorithm getVerifierForKey(ECKey key) {
        switch (key.getParams().getCurve().getField().getFieldSize()) {
            case 256: {
                return new ECDSAKeyAlgorithm.ECDSASha2Nistp256();
            }
            case 384: {
                return new ECDSAKeyAlgorithm.ECDSASha2Nistp384();
            }
            case 521: {
                return new ECDSAKeyAlgorithm.ECDSASha2Nistp521();
            }
        }
        return null;
    }

    @Override
    public String getHashAlgo() {
        return ECDSAKeyAlgorithm.getDigestAlgorithmForParams(this.clientPublic);
    }
}

