/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.dh;

import com.google.crypto.tink.subtle.X25519;
import com.trilead.ssh2.crypto.dh.GenericDhExchange;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;

public class Curve25519Exchange
extends GenericDhExchange {
    public static final String NAME = "curve25519-sha256";
    public static final String ALT_NAME = "curve25519-sha256@libssh.org";
    public static final int KEY_SIZE = 32;
    private byte[] clientPublic;
    private byte[] clientPrivate;
    private byte[] serverPublic;

    public Curve25519Exchange() {
    }

    public Curve25519Exchange(byte[] secret) throws InvalidKeyException {
        if (secret.length != 32) {
            throw new AssertionError((Object)"secret must be key size");
        }
        this.clientPrivate = (byte[])secret.clone();
    }

    @Override
    public void init(String name) throws IOException {
        if (!NAME.equals(name) && !ALT_NAME.equals(name)) {
            throw new IOException("Invalid name " + name);
        }
        this.clientPrivate = X25519.generatePrivateKey();
        try {
            this.clientPublic = X25519.publicFromPrivate((byte[])this.clientPrivate);
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] getE() {
        return (byte[])this.clientPublic.clone();
    }

    @Override
    protected byte[] getServerE() {
        return (byte[])this.serverPublic.clone();
    }

    @Override
    public void setF(byte[] f) throws IOException {
        if (f.length != 32) {
            throw new IOException("Server sent invalid key length " + f.length + " (expected 32)");
        }
        this.serverPublic = (byte[])f.clone();
        try {
            byte[] sharedSecretBytes = X25519.computeSharedSecret((byte[])this.clientPrivate, (byte[])this.serverPublic);
            int allBytes = 0;
            for (int i = 0; i < sharedSecretBytes.length; ++i) {
                allBytes |= sharedSecretBytes[i];
            }
            if (allBytes == 0) {
                throw new IOException("Invalid key computed; all zeroes");
            }
            this.sharedSecret = new BigInteger(1, sharedSecretBytes);
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getHashAlgo() {
        return "SHA-256";
    }
}

