/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class JreCipherWrapper
implements BlockCipher {
    private final Cipher cipher;
    private final String algorithm;
    private final AlgorithmParameterSpec parameterSpec;

    public static JreCipherWrapper getInstance(String algorithm, AlgorithmParameterSpec parameterSpec) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            return new JreCipherWrapper(cipher, parameterSpec);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private JreCipherWrapper(Cipher cipher, AlgorithmParameterSpec parameterSpec) {
        this.cipher = cipher;
        this.parameterSpec = parameterSpec;
        String alg = cipher.getAlgorithm();
        this.algorithm = alg.contains("/") ? alg.substring(0, alg.indexOf(47)) : alg;
    }

    @Override
    public void init(boolean forEncryption, byte[] key) {
        int mode = forEncryption ? 1 : 2;
        try {
            this.cipher.init(mode, (Key)new SecretKeySpec(key, this.algorithm), this.parameterSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void init(boolean forEncryption, KeySpec keySpec) {
        int mode = forEncryption ? 1 : 2;
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(this.algorithm);
            SecretKey key = factory.generateSecret(keySpec);
            this.cipher.init(mode, (Key)key, this.parameterSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public void transformBlock(byte[] src, int srcoff, byte[] dst, int dstoff) {
        try {
            this.cipher.update(src, srcoff, this.cipher.getBlockSize(), dst, dstoff);
        }
        catch (ShortBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

