/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.auth.GSSContextKrb5;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.TypesWriter;
import java.net.UnknownHostException;
import org.ietf.jgss.GSSException;

public class PacketUserauthTokenGssapiWithMic {
    private static final Logger LOGGER = Logger.getLogger(PacketUserauthTokenGssapiWithMic.class);
    private static final String GSSAPI_WITH_MIC = "gssapi-with-mic";
    private static final String SSH_CONNECTION = "ssh-connection";
    private String user;
    private String host;
    private byte[] payload;
    private GSSContextKrb5 context = null;

    public PacketUserauthTokenGssapiWithMic(String user, String host) {
        this.user = user;
        this.host = host;
        this.context = new GSSContextKrb5();
        try {
            this.context.create(this.host);
        }
        catch (UnknownHostException | GSSException e) {
            throw new IllegalStateException("Could not create context with host " + this.host, e);
        }
    }

    public byte[] getTokenPayload() {
        if (this.payload == null) {
            byte[] token = new byte[]{};
            while (!this.context.isEstablished()) {
                try {
                    if ((token = this.context.init(token, 0, token.length)).length <= 1) continue;
                    break;
                }
                catch (SecurityException | GSSException e) {
                    if (!LOGGER.isEnabled()) continue;
                    LOGGER.log(50, "Could not get token", e);
                }
            }
            TypesWriter tw = new TypesWriter();
            tw.writeByte(61);
            tw.writeString(token, 0, token.length);
            this.payload = tw.getBytes();
        }
        return this.payload;
    }

    public byte[] getMicPayload(byte[] sessionIdentifier) {
        byte[] mic;
        this.payload = null;
        TypesWriter tw = new TypesWriter();
        tw.writeString(sessionIdentifier, 0, sessionIdentifier.length);
        tw.writeByte(50);
        tw.writeString(this.user);
        tw.writeString(SSH_CONNECTION);
        tw.writeString(GSSAPI_WITH_MIC);
        byte[] message = tw.getBytes();
        try {
            mic = this.context.getMIC(message, 0, message.length);
        }
        catch (GSSException e) {
            if (LOGGER.isEnabled()) {
                LOGGER.log(50, "Could not get MIC", e);
            }
            mic = null;
        }
        if (mic == null) {
            return null;
        }
        tw = new TypesWriter();
        tw.writeByte(66);
        tw.writeString(mic, 0, mic.length);
        this.payload = tw.getBytes();
        return this.payload;
    }
}

