/*
 * Decompiled with CFR 0.152.
 */
package net.uaznia.lukanus.hudson.plugins.gitparameter.scms;

import com.google.common.base.Strings;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.uaznia.lukanus.hudson.plugins.gitparameter.jobs.JobWrapper;
import net.uaznia.lukanus.hudson.plugins.gitparameter.scms.EmptySCM;
import net.uaznia.lukanus.hudson.plugins.gitparameter.scms.Messages;
import net.uaznia.lukanus.hudson.plugins.gitparameter.scms.MultiSCM;
import net.uaznia.lukanus.hudson.plugins.gitparameter.scms.ProxySCM;
import net.uaznia.lukanus.hudson.plugins.gitparameter.scms.RepoSCM;
import net.uaznia.lukanus.hudson.plugins.gitparameter.scms.SCMWrapper;
import net.uaznia.lukanus.hudson.plugins.gitparameter.scms.SingleSCM;

public class SCMFactory {
    private static final SCMWrapper EMPTY_SCM = new EmptySCM();
    private static final Logger LOGGER = Logger.getLogger(SCMFactory.class.getName());

    public static List<GitSCM> getGitSCMs(JobWrapper jobWrapper, String repositoryRegExpName) {
        Pattern repositoryNamePattern;
        List<SCM> scms = SCMFactory.getSCMs(jobWrapper);
        if (scms.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (Strings.isNullOrEmpty((String)repositoryRegExpName)) {
            return SCMFactory.getFirstGitSCM(scms);
        }
        try {
            repositoryNamePattern = Pattern.compile(repositoryRegExpName);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, Messages.SCMFactory_invalidUseRepositoryPattern(repositoryRegExpName), e.getMessage());
            return SCMFactory.getFirstGitSCM(scms);
        }
        return SCMFactory.matchAndGetGitSCM(scms, repositoryNamePattern);
    }

    private static List<GitSCM> matchAndGetGitSCM(List<SCM> scms, Pattern repositoryNamePattern) {
        ArrayList<GitSCM> gitSCMs = new ArrayList<GitSCM>();
        for (SCM scm : scms) {
            if (!(scm instanceof GitSCM) || !SCMFactory.anyUserRemoteConfigMatch(scm, repositoryNamePattern)) continue;
            gitSCMs.add((GitSCM)scm);
        }
        return gitSCMs;
    }

    private static boolean anyUserRemoteConfigMatch(SCM scm, Pattern repositoryNamePattern) {
        List userRemoteConfigs = ((GitSCM)scm).getUserRemoteConfigs();
        for (UserRemoteConfig userRemoteConfig : userRemoteConfigs) {
            if (!repositoryNamePattern.matcher(userRemoteConfig.getUrl()).find()) continue;
            return true;
        }
        return false;
    }

    private static List<GitSCM> getFirstGitSCM(List<SCM> scms) {
        SCM scm = scms.get(0);
        if (scm instanceof GitSCM) {
            return Collections.singletonList((GitSCM)scm);
        }
        return Collections.EMPTY_LIST;
    }

    private static List<SCM> getSCMs(JobWrapper jobWrapper) {
        if (jobWrapper == null) {
            return EMPTY_SCM.getSCMs();
        }
        List<SCM> projectSCMsFromJob = jobWrapper.getScms();
        if (projectSCMsFromJob == null || projectSCMsFromJob.isEmpty()) {
            return EMPTY_SCM.getSCMs();
        }
        return SCMFactory.transformSCMs(projectSCMsFromJob);
    }

    private static List<SCM> transformSCMs(List<SCM> SCMs) {
        ArrayList<SCM> projectSCMs = new ArrayList<SCM>();
        for (SCM scm : SCMs) {
            String projectSCMClassName = scm.getClass().getName();
            if ("hudson.plugins.templateproject.ProxySCM".equals(projectSCMClassName)) {
                List<SCM> SCMsFromProxy = new ProxySCM(scm).getSCMs();
                return SCMFactory.transformSCMs(SCMsFromProxy);
            }
            SCMWrapper scmWrapper = "hudson.plugins.repo.RepoScm".equals(projectSCMClassName) ? new RepoSCM(scm) : ("org.jenkinsci.plugins.multiplescms.MultiSCM".equals(projectSCMClassName) ? new MultiSCM(scm) : new SingleSCM(scm));
            projectSCMs.addAll(scmWrapper.getSCMs());
        }
        return projectSCMs;
    }
}

