/*
 * Decompiled with CFR 0.152.
 */
package net.uaznia.lukanus.hudson.plugins.gitparameter;

import com.google.common.base.Strings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.uaznia.lukanus.hudson.plugins.gitparameter.FilePathWrapper;
import net.uaznia.lukanus.hudson.plugins.gitparameter.GitParameterValue;
import net.uaznia.lukanus.hudson.plugins.gitparameter.Messages;
import net.uaznia.lukanus.hudson.plugins.gitparameter.RevisionInfo;
import net.uaznia.lukanus.hudson.plugins.gitparameter.RevisionInfoFactory;
import net.uaznia.lukanus.hudson.plugins.gitparameter.SelectedValue;
import net.uaznia.lukanus.hudson.plugins.gitparameter.SmartNumberStringComparer;
import net.uaznia.lukanus.hudson.plugins.gitparameter.SortMode;
import net.uaznia.lukanus.hudson.plugins.gitparameter.jobs.JobWrapper;
import net.uaznia.lukanus.hudson.plugins.gitparameter.jobs.JobWrapperFactory;
import net.uaznia.lukanus.hudson.plugins.gitparameter.scms.RepoSCM;
import net.uaznia.lukanus.hudson.plugins.gitparameter.scms.SCMFactory;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class GitParameterDefinition
extends ParameterDefinition
implements Comparable<GitParameterDefinition> {
    private static final long serialVersionUID = 9157832967140868122L;
    private static final String DEFAULT_LIST_SIZE = "5";
    private static final String DEFAULT_REMOTE = "origin";
    private static final String REFS_TAGS_PATTERN = ".*refs/tags/";
    public static final String PARAMETER_TYPE_TAG = "PT_TAG";
    public static final String PARAMETER_TYPE_REVISION = "PT_REVISION";
    public static final String PARAMETER_TYPE_BRANCH = "PT_BRANCH";
    public static final String PARAMETER_TYPE_TAG_BRANCH = "PT_BRANCH_TAG";
    public static final String PARAMETER_TYPE_PULL_REQUEST = "PT_PULL_REQUEST";
    public static final Pattern PULL_REQUEST_REFS_PATTERN = Pattern.compile("refs/pull.*/(\\d+)/[from|head]");
    public static final String TEMPORARY_DIRECTORY_PREFIX = "git_parameter_";
    public static final String EMPTY_JOB_NAME = "EMPTY_JOB_NAME";
    private static final Logger LOGGER = Logger.getLogger(GitParameterDefinition.class.getName());
    private final UUID uuid;
    private String type;
    private String branch;
    private String tagFilter;
    private String branchFilter;
    private SortMode sortMode;
    private String defaultValue;
    private SelectedValue selectedValue;
    private String useRepository;
    private Boolean quickFilterEnabled;
    private String listSize;

    @DataBoundConstructor
    public GitParameterDefinition(String name, String type, String defaultValue, String description, String branch, String branchFilter, String tagFilter, SortMode sortMode, SelectedValue selectedValue, String useRepository, Boolean quickFilterEnabled) {
        super(name, description);
        this.defaultValue = defaultValue;
        this.branch = branch;
        this.uuid = UUID.randomUUID();
        this.sortMode = sortMode;
        this.selectedValue = selectedValue;
        this.quickFilterEnabled = quickFilterEnabled;
        this.listSize = DEFAULT_LIST_SIZE;
        this.setUseRepository(useRepository);
        this.setType(type);
        this.setTagFilter(tagFilter);
        this.setBranchFilter(branchFilter);
    }

    public ParameterValue createValue(StaplerRequest request) {
        String[] value = request.getParameterValues(this.getName());
        if (value == null || value.length == 0 || StringUtils.isBlank((String)value[0])) {
            return this.getDefaultParameterValue();
        }
        return new GitParameterValue(this.getName(), value[0]);
    }

    public ParameterValue createValue(StaplerRequest request, JSONObject jO) {
        Object value = jO.get("value");
        StringBuilder strValue = new StringBuilder();
        if (value instanceof String) {
            strValue.append(value);
        } else if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            for (int i = 0; i < jsonValues.size(); ++i) {
                strValue.append(jsonValues.getString(i));
                if (i >= jsonValues.size() - 1) continue;
                strValue.append(",");
            }
        }
        if (strValue.length() == 0) {
            strValue.append(this.defaultValue);
        }
        GitParameterValue gitParameterValue = new GitParameterValue(jO.getString("name"), strValue.toString());
        return gitParameterValue;
    }

    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        if (StringUtils.isNotEmpty((String)value)) {
            return new GitParameterValue(this.getName(), value);
        }
        return this.getDefaultParameterValue();
    }

    public ParameterValue getDefaultParameterValue() {
        String defValue = this.getDefaultValue();
        if (!StringUtils.isBlank((String)defValue)) {
            return new GitParameterValue(this.getName(), defValue);
        }
        switch (this.getSelectedValue()) {
            case TOP: {
                try {
                    ListBoxModel valueItems = this.getDescriptor().doFillValueItems(this.getParentJob(), this.getName());
                    if (valueItems.size() > 0) {
                        return new GitParameterValue(this.getName(), ((ListBoxModel.Option)valueItems.get((int)0)).value);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, this.getCustomeJobName() + " " + Messages.GitParameterDefinition_unexpectedError(), e);
                }
                break;
            }
            default: {
                return super.getDefaultParameterValue();
            }
        }
        return super.getDefaultParameterValue();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = this.isParameterTypeCorrect(type) ? type : PARAMETER_TYPE_BRANCH;
    }

    private boolean isParameterTypeCorrect(String type) {
        return type.equals(PARAMETER_TYPE_TAG) || type.equals(PARAMETER_TYPE_REVISION) || type.equals(PARAMETER_TYPE_BRANCH) || type.equals(PARAMETER_TYPE_TAG_BRANCH) || type.equals(PARAMETER_TYPE_PULL_REQUEST);
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String nameOfBranch) {
        this.branch = nameOfBranch;
    }

    public SortMode getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(SortMode sortMode) {
        this.sortMode = sortMode;
    }

    public String getTagFilter() {
        return this.tagFilter;
    }

    public void setTagFilter(String tagFilter) {
        if (StringUtils.isEmpty((String)StringUtils.trim((String)tagFilter))) {
            tagFilter = "*";
        }
        this.tagFilter = tagFilter;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getBranchFilter() {
        return this.branchFilter;
    }

    public void setBranchFilter(String branchFilter) {
        if (StringUtils.isEmpty((String)StringUtils.trim((String)branchFilter))) {
            branchFilter = ".*";
        }
        this.branchFilter = branchFilter;
    }

    public String getListSize() {
        return this.listSize == null ? DEFAULT_LIST_SIZE : this.listSize;
    }

    @DataBoundSetter
    public void setListSize(String listSize) {
        this.listSize = listSize;
    }

    public SelectedValue getSelectedValue() {
        return this.selectedValue == null ? SelectedValue.TOP : this.selectedValue;
    }

    public Boolean getQuickFilterEnabled() {
        return this.quickFilterEnabled;
    }

    public Job getParentJob() {
        Job context = null;
        List jobs = Jenkins.getInstance().getAllItems(Job.class);
        block0: for (Job job : jobs) {
            List parameterDefinitions;
            ParametersDefinitionProperty property;
            if (!(job instanceof TopLevelItem) || (property = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class)) == null || (parameterDefinitions = property.getParameterDefinitions()) == null) continue;
            for (ParameterDefinition pd : parameterDefinitions) {
                if (!(pd instanceof GitParameterDefinition) || ((GitParameterDefinition)pd).compareTo(this) != 0) continue;
                context = job;
                continue block0;
            }
        }
        return context;
    }

    @Override
    public int compareTo(GitParameterDefinition pd) {
        return pd.uuid.equals(this.uuid) ? 0 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Map<String, String> generateContents(JobWrapper jobWrapper, GitSCM git) {
        LinkedHashMap<String, String> paramList = new LinkedHashMap<String, String>();
        try {
            EnvVars environment = this.getEnvironment(jobWrapper);
            Iterator iterator = git.getRepositories().iterator();
            while (iterator.hasNext()) {
                RemoteConfig repository = (RemoteConfig)iterator.next();
                Class<GitParameterDefinition> clazz = GitParameterDefinition.class;
                // MONITORENTER : net.uaznia.lukanus.hudson.plugins.gitparameter.GitParameterDefinition.class
                for (URIish remoteURL : repository.getURIs()) {
                    GitClient gitClient = this.getGitClient(jobWrapper, null, git, environment);
                    String gitUrl = Util.replaceMacro((String)remoteURL.toPrivateASCIIString(), (Map)environment);
                    if (this.notMatchUseRepository(gitUrl)) continue;
                    if (this.isTagType()) {
                        Set<String> tagSet = this.getTag(gitClient, gitUrl);
                        this.sortAndPutToParam(tagSet, paramList);
                    }
                    if (this.isBranchType()) {
                        Set<String> branchSet = this.getBranch(gitClient, gitUrl, repository.getName());
                        this.sortAndPutToParam(branchSet, paramList);
                    }
                    if (this.isRevisionType()) {
                        this.getRevision(jobWrapper, git, paramList, environment, repository, remoteURL);
                    }
                    if (!this.isPullRequestType()) continue;
                    Set<String> pullRequestSet = this.getPullRequest(gitClient, gitUrl);
                    this.sortAndPutToParam(pullRequestSet, paramList);
                }
                // MONITOREXIT : clazz
            }
            return paramList;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, this.getCustomeJobName() + " " + Messages.GitParameterDefinition_unexpectedError(), e);
            String message = e.getMessage() + Messages.GitParameterDefinition_lookAtLog();
            paramList.clear();
            paramList.put(message, message);
        }
        return paramList;
    }

    private boolean notMatchUseRepository(String gitUrl) {
        Pattern repositoryNamePattern;
        if (Strings.isNullOrEmpty((String)this.useRepository)) {
            return false;
        }
        try {
            repositoryNamePattern = Pattern.compile(this.useRepository);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, Messages.GitParameterDefinition_invalidUseRepositoryPattern(this.useRepository), e.getMessage());
            return false;
        }
        return !repositoryNamePattern.matcher(gitUrl).find();
    }

    private boolean isRevisionType() {
        return this.type.equalsIgnoreCase(PARAMETER_TYPE_REVISION);
    }

    private boolean isBranchType() {
        return this.type.equalsIgnoreCase(PARAMETER_TYPE_BRANCH) || this.type.equalsIgnoreCase(PARAMETER_TYPE_TAG_BRANCH);
    }

    private boolean isTagType() {
        return this.type.equalsIgnoreCase(PARAMETER_TYPE_TAG) || this.type.equalsIgnoreCase(PARAMETER_TYPE_TAG_BRANCH);
    }

    private boolean isPullRequestType() {
        return this.type.equalsIgnoreCase(PARAMETER_TYPE_PULL_REQUEST);
    }

    private Set<String> getTag(GitClient gitClient, String gitUrl) throws InterruptedException {
        HashSet<String> tagSet = new HashSet<String>();
        try {
            Map tags = gitClient.getRemoteReferences(gitUrl, this.tagFilter, false, true);
            for (String tagName : tags.keySet()) {
                tagSet.add(tagName.replaceFirst(REFS_TAGS_PATTERN, ""));
            }
        }
        catch (GitException e) {
            LOGGER.log(Level.WARNING, this.getCustomeJobName() + " " + Messages.GitParameterDefinition_getTag(), e);
        }
        return tagSet;
    }

    private Set<String> getBranch(GitClient gitClient, String gitUrl, String remoteName) throws InterruptedException {
        HashSet<String> branchSet = new HashSet<String>();
        Pattern branchFilterPattern = this.compileBranchFilterPattern();
        Map branches = gitClient.getRemoteReferences(gitUrl, null, true, false);
        Iterator remoteBranchesName = branches.keySet().iterator();
        while (remoteBranchesName.hasNext()) {
            String branchName = this.strip((String)remoteBranchesName.next(), remoteName);
            Matcher matcher = branchFilterPattern.matcher(branchName);
            if (!matcher.matches()) continue;
            if (matcher.groupCount() == 1) {
                branchSet.add(matcher.group(1));
                continue;
            }
            branchSet.add(branchName);
        }
        return branchSet;
    }

    private Set<String> getPullRequest(GitClient gitClient, String gitUrl) throws InterruptedException {
        HashSet<String> pullRequestSet = new HashSet<String>();
        Map remoteReferences = gitClient.getRemoteReferences(gitUrl, null, false, false);
        for (String remoteReference : remoteReferences.keySet()) {
            Matcher matcher = PULL_REQUEST_REFS_PATTERN.matcher(remoteReference);
            if (!matcher.find()) continue;
            pullRequestSet.add(matcher.group(1));
        }
        return pullRequestSet;
    }

    private Pattern compileBranchFilterPattern() {
        Pattern branchFilterPattern;
        try {
            branchFilterPattern = Pattern.compile(this.branchFilter);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, this.getCustomeJobName() + " " + Messages.GitParameterDefinition_branchFilterNotValid(), e.getMessage());
            branchFilterPattern = Pattern.compile(".*");
        }
        return branchFilterPattern;
    }

    private String strip(String name, String remote) {
        return remote + "/" + name.substring(name.indexOf(47, 5) + 1);
    }

    private void getRevision(JobWrapper jobWrapper, GitSCM git, Map<String, String> paramList, EnvVars environment, RemoteConfig repository, URIish remoteURL) throws IOException, InterruptedException {
        boolean isRepoScm = RepoSCM.isRepoSCM(repository.getName());
        FilePathWrapper workspace = this.getWorkspace(jobWrapper, isRepoScm);
        GitClient gitClient = this.getGitClient(jobWrapper, workspace, git, environment);
        this.initWorkspace(workspace, gitClient, remoteURL);
        FetchCommand fetch = gitClient.fetch_().prune().from(remoteURL, repository.getFetchRefSpecs());
        fetch.execute();
        RevisionInfoFactory revisionInfoFactory = new RevisionInfoFactory(gitClient, this.branch);
        List<RevisionInfo> revisions = revisionInfoFactory.getRevisions();
        for (RevisionInfo revision : revisions) {
            paramList.put(revision.getSha1(), revision.getRevisionInfo());
        }
        workspace.delete();
    }

    private void sortAndPutToParam(Set<String> setElement, Map<String, String> paramList) {
        ArrayList<String> sorted = this.sort(setElement);
        for (String element : sorted) {
            paramList.put(element, element);
        }
    }

    private ArrayList<String> sort(Set<String> toSort) {
        ArrayList<String> sorted;
        if (this.getSortMode().getIsSorting()) {
            sorted = this.sortByName(toSort);
            if (this.getSortMode().getIsDescending()) {
                Collections.reverse(sorted);
            }
        } else {
            sorted = new ArrayList<String>(toSort);
        }
        return sorted;
    }

    private FilePathWrapper getWorkspace(JobWrapper jobWrapper, boolean isRepoScm) throws IOException, InterruptedException {
        FilePathWrapper someWorkspace = new FilePathWrapper(jobWrapper.getSomeWorkspace());
        if (isRepoScm) {
            FilePath repoDir = new FilePath(someWorkspace.getFilePath(), RepoSCM.getRepoMainfestsDir());
            someWorkspace = repoDir.exists() ? new FilePathWrapper(repoDir) : this.getTemporaryWorkspace();
        } else if (someWorkspace.getFilePath() == null) {
            someWorkspace = this.getTemporaryWorkspace();
        }
        someWorkspace.getFilePath().mkdirs();
        return someWorkspace;
    }

    private FilePathWrapper getTemporaryWorkspace() throws IOException {
        Path temporaryWorkspacePath = Files.createTempDirectory(TEMPORARY_DIRECTORY_PREFIX, new FileAttribute[0]);
        FilePath filePath = new FilePath(temporaryWorkspacePath.toFile());
        FilePathWrapper filePathWrapper = new FilePathWrapper(filePath);
        filePathWrapper.setThatTemporary();
        return filePathWrapper;
    }

    private EnvVars getEnvironment(JobWrapper jobWrapper) throws IOException, InterruptedException {
        EnvVars environment = jobWrapper.getEnvironment(Jenkins.getInstance().toComputer().getNode(), TaskListener.NULL);
        EnvVars buildEnvironments = jobWrapper.getSomeBuildEnvironments();
        if (buildEnvironments != null) {
            environment.putAll((Map)buildEnvironments);
        }
        EnvVars jobDefautEnvironments = this.getJobDefaultEnvironment(jobWrapper);
        environment.putAll((Map)jobDefautEnvironments);
        EnvVars.resolve((Map)environment);
        return environment;
    }

    private EnvVars getJobDefaultEnvironment(JobWrapper jobWrapper) {
        EnvVars environment = new EnvVars();
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)jobWrapper.getJob().getProperty(ParametersDefinitionProperty.class);
        if (property != null) {
            for (ParameterDefinition parameterDefinition : property.getParameterDefinitions()) {
                if (parameterDefinition == null || !this.isAcceptedParameterClass(parameterDefinition)) continue;
                this.checkAndAddDefaultParameterValue(parameterDefinition, environment);
            }
        }
        return environment;
    }

    private boolean isAcceptedParameterClass(ParameterDefinition parameterDefinition) {
        return parameterDefinition instanceof StringParameterDefinition || parameterDefinition instanceof ChoiceParameterDefinition;
    }

    private void checkAndAddDefaultParameterValue(ParameterDefinition parameterDefinition, EnvVars environment) {
        ParameterValue defaultParameterValue = parameterDefinition.getDefaultParameterValue();
        if (defaultParameterValue != null && defaultParameterValue.getValue() != null && defaultParameterValue.getValue() instanceof String) {
            environment.put(parameterDefinition.getName(), (String)defaultParameterValue.getValue());
        }
    }

    private void initWorkspace(FilePathWrapper workspace, GitClient gitClient, URIish remoteURL) throws IOException, InterruptedException {
        if (this.isEmptyWorkspace(workspace.getFilePath())) {
            gitClient.init();
            gitClient.clone(remoteURL.toASCIIString(), DEFAULT_REMOTE, false, null);
            LOGGER.log(Level.INFO, this.getCustomeJobName() + " " + Messages.GitParameterDefinition_genContentsCloneDone());
        }
    }

    private boolean isEmptyWorkspace(FilePath workspaceDir) throws IOException, InterruptedException {
        return workspaceDir.list().size() == 0;
    }

    private GitClient getGitClient(JobWrapper jobWrapper, FilePathWrapper workspace, GitSCM git, EnvVars environment) throws IOException, InterruptedException {
        int nextBuildNumber = jobWrapper.getNextBuildNumber();
        GitClient gitClient = git.createClient(TaskListener.NULL, environment, new Run(jobWrapper.getJob()){}, workspace != null ? workspace.getFilePath() : null);
        jobWrapper.updateNextBuildNumber(nextBuildNumber);
        return gitClient;
    }

    public ArrayList<String> sortByName(Set<String> set) {
        ArrayList<String> tags = new ArrayList<String>(set);
        if (this.sortMode.getIsUsingSmartSort()) {
            Collections.sort(tags, new SmartNumberStringComparer());
        } else {
            Collections.sort(tags);
        }
        return tags;
    }

    public String getDivUUID() {
        StringBuilder randomSelectName = new StringBuilder();
        randomSelectName.append(this.getName()).append("-").append(this.uuid);
        return randomSelectName.toString();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getUseRepository() {
        return this.useRepository;
    }

    public void setUseRepository(String useRepository) {
        this.useRepository = StringUtils.isEmpty((String)StringUtils.trim((String)useRepository)) ? null : useRepository;
    }

    public String getCustomeJobName() {
        Job job = this.getParentJob();
        String fullName = job != null ? job.getFullName() : EMPTY_JOB_NAME;
        return "[ " + fullName + " ] ";
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        private List<GitSCM> scms;

        public String getDisplayName() {
            return Messages.GitParameterDefinition_DisplayName();
        }

        public ListBoxModel doFillValueItems(@AncestorInPath Job job, @QueryParameter String param) throws IOException, InterruptedException {
            ParameterDefinition def;
            ListBoxModel items = new ListBoxModel();
            JobWrapper jobWrapper = JobWrapperFactory.createJobWrapper(job);
            ParametersDefinitionProperty prop = jobWrapper.getProperty(ParametersDefinitionProperty.class);
            if (prop != null && (def = prop.getParameterDefinition(param)) instanceof GitParameterDefinition) {
                GitParameterDefinition paramDef = (GitParameterDefinition)def;
                String repositoryName = paramDef.getUseRepository();
                this.scms = this.getProjectSCMs(jobWrapper, repositoryName);
                if (this.scms == null || this.scms.isEmpty()) {
                    items.add(Messages.GitParameterDefinition_noRepositoryConfigured());
                    return items;
                }
                for (GitSCM scm : this.scms) {
                    Map<String, String> paramList = paramDef.generateContents(jobWrapper, scm);
                    for (Map.Entry<String, String> entry : paramList.entrySet()) {
                        items.add(entry.getValue(), entry.getKey());
                    }
                }
            }
            return items;
        }

        public List<GitSCM> getProjectSCMs(JobWrapper jobWrapper, String repositoryName) {
            return SCMFactory.getGitSCMs(jobWrapper, repositoryName);
        }

        public FormValidation doCheckBranchFilter(@QueryParameter String value) {
            String errorMessage = Messages.GitParameterDefinition_invalidBranchPattern(value);
            return this.validationRegularExpression(value, errorMessage);
        }

        public FormValidation doCheckUseRepository(@QueryParameter String value) {
            String errorMessage = Messages.GitParameterDefinition_invalidUseRepositoryPattern(value);
            return this.validationRegularExpression(value, errorMessage);
        }

        private FormValidation validationRegularExpression(String value, String errorMessage) {
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException e) {
                LOGGER.log(Level.WARNING, errorMessage, e);
                return FormValidation.error((String)errorMessage);
            }
            return FormValidation.ok();
        }
    }
}

