/*
 * Decompiled with CFR 0.152.
 */
package com.thed.zephyr.jenkins.utils.rest;

import com.thed.zephyr.jenkins.utils.rest.RestClient;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;

public class Version {
    private static String URL_GET_VERSIONS = "{SERVER}/rest/api/2/project/{PROJ_ID}/versions?expand";

    public static Long getVersionIdByNameProjectId(String versionName, Long projectId, RestClient restClient) {
        Long releaseId = 0L;
        CloseableHttpResponse response = null;
        try {
            response = restClient.getHttpclient().execute((HttpUriRequest)new HttpGet(restClient.getUrl() + "/flex/services/rest/latest/release?name=" + URLEncoder.encode(versionName, "utf-8") + "&project.id=" + projectId), (HttpContext)restClient.getContext());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            HttpEntity entity = response.getEntity();
            String string = null;
            try {
                string = EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                JSONArray releaseArray = new JSONArray(string);
                ArrayList<Long> releaseIdList = new ArrayList<Long>();
                for (int i = 0; i < releaseArray.length(); ++i) {
                    Long id = releaseArray.getJSONObject(i).getLong("id");
                    releaseIdList.add(id);
                }
                Collections.sort(releaseIdList);
                releaseId = (Long)releaseIdList.get(0);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            try {
                throw new ClientProtocolException("Unexpected response status: " + statusCode);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
        }
        return releaseId;
    }

    public static Map<Long, String> getVersionsByProjectID(Long projectID, RestClient restClient) {
        TreeMap<Long, String> releases = new TreeMap<Long, String>();
        CloseableHttpResponse response = null;
        String url = URL_GET_VERSIONS.replace("{SERVER}", restClient.getUrl()).replace("{PROJ_ID}", projectID + "");
        try {
            response = restClient.getHttpclient().execute((HttpUriRequest)new HttpGet(url), (HttpContext)restClient.getContext());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            HttpEntity entity = response.getEntity();
            String string = null;
            try {
                string = EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                JSONArray projArray = new JSONArray(string);
                for (int i = 0; i < projArray.length(); ++i) {
                    Long id = projArray.getJSONObject(i).getLong("id");
                    String projName = projArray.getJSONObject(i).getString("name");
                    releases.put(id, projName);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            try {
                throw new ClientProtocolException("Unexpected response status: " + statusCode);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
        }
        releases.put(-1L, "Unscheduled");
        return releases;
    }
}

