/*
 * Decompiled with CFR 0.152.
 */
package com.thed.zephyr.jenkins.utils.rest;

import com.thed.zephyr.jenkins.model.TestCaseResultModel;
import com.thed.zephyr.jenkins.model.ZephyrConfigModel;
import com.thed.zephyr.jenkins.utils.rest.Cycle;
import com.thed.zephyr.jenkins.utils.rest.RestBase;
import com.thed.zephyr.jenkins.utils.rest.RestClient;
import com.thed.zephyr.jenkins.utils.rest.ServerInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TestCaseUtil
implements RestBase {
    public static final long NEW_CYCLE_KEY_IDENTIFIER = 1000000000L;
    private static final int MAX_BULK_OPERATION_COUNT = 50;
    private static final int MAX_BULK_ISSUE_CREATE_COUNT = 50;
    private static final int MAX_BULK_ISSUE_SEARCH_COUNT = 250;
    private static final int MAX_ALLOWED_EXECUTION_ID_FETCH = 50;
    private static final String URL_GET_ALL_TESTS = "{SERVER}/rest/api/2/search";
    private static final String URL_CREATE_TESTS = "{SERVER}/rest/api/2/issue/bulk";
    private static final String URL_ASSIGN_TESTS = "{SERVER}/rest/zapi/latest/execution/addTestsToCycle/";
    private static final String URL_CREATE_EXECUTIONS_URL = "{SERVER}/rest/zapi/latest/execution?projectId={projectId}&versionId={versionId}&cycleId={cycleId}";
    private static final String URL_EXECUTE_TEST = "{SERVER}/rest/zapi/latest/execution/updateBulkStatus";
    private static final String JQL_SEARCH_TESTS = "jql=project={pId}&issuetype={issueTypeId}&maxResults=250&startAt={searchIssueStartcount}";
    private static final String URL_JOB_PROGRESS_bulkexecute = "{SERVER}/rest/zapi/latest/execution/jobProgress/{jobProgressToken}?type=update_bulk_execution_status_job_progress";
    private static final String URL_GET_CYCLES = "{SERVER}/rest/zapi/latest/cycle";
    private static final String URL_JOB_PROGRESS = "{SERVER}/rest/zapi/latest/execution/jobProgress/{jobProgressToken}?type=add_tests_to_cycle_job_progress";
    public static final String URL_JOB_PROGRESS_ZFJC = "{SERVER}/public/rest/api/1.0/jobprogress/{jobProgressToken}";

    public static Map<Long, Map<String, Boolean>> getTestCaseDetails(ZephyrConfigModel zephyrData) {
        JSONObject bulkIssues = new JSONObject();
        JSONArray issueUpdates = new JSONArray();
        ArrayList<JSONArray> issueKeyJSONArrayList = new ArrayList<JSONArray>();
        HashMap<Long, Map<String, Boolean>> testCaseResultMap = new HashMap<Long, Map<String, Boolean>>();
        List<TestCaseResultModel> testCases = zephyrData.getTestcases();
        if (testCases == null || testCases.size() == 0) {
            return testCaseResultMap;
        }
        Map<String, Map<Long, String>> searchedTests = TestCaseUtil.searchIssues(zephyrData);
        for (TestCaseResultModel testCaseWithStatus : testCases) {
            if (searchedTests.containsKey(testCaseWithStatus.getTestCaseName())) {
                Map<Long, String> tempTestIdTestKeyMap = searchedTests.get(testCaseWithStatus.getTestCaseName());
                Set<Map.Entry<Long, String>> entrySet = tempTestIdTestKeyMap.entrySet();
                Map.Entry<Long, String> entry = entrySet.iterator().next();
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                map.put(entry.getValue(), testCaseWithStatus.getPassed());
                testCaseResultMap.put(entry.getKey(), map);
                continue;
            }
            String testCase = testCaseWithStatus.getTestCase();
            JSONObject issue = new JSONObject(testCase);
            issueUpdates.put((Object)issue);
            if (issueUpdates.length() != 50) continue;
            issueKeyJSONArrayList.add(issueUpdates);
            issueUpdates = new JSONArray();
        }
        if (issueUpdates.length() > 0) {
            issueKeyJSONArrayList.add(issueUpdates);
        }
        if (issueKeyJSONArrayList.size() == 0) {
            return testCaseResultMap;
        }
        for (int i = 0; i < issueKeyJSONArrayList.size(); ++i) {
            bulkIssues.put("issueUpdates", issueKeyJSONArrayList.get(i));
            TestCaseUtil.createTests(zephyrData, bulkIssues, testCaseResultMap, testCases);
        }
        Map<String, Map<Long, String>> searchedTestsAfterCreation = TestCaseUtil.searchIssues(zephyrData);
        for (TestCaseResultModel testCaseWithStatus : testCases) {
            if (!searchedTestsAfterCreation.containsKey(testCaseWithStatus.getTestCaseName())) continue;
            Map<Long, String> tempTestIdTestKeyMap = searchedTestsAfterCreation.get(testCaseWithStatus.getTestCaseName());
            Set<Map.Entry<Long, String>> entrySet = tempTestIdTestKeyMap.entrySet();
            Map.Entry<Long, String> entry = entrySet.iterator().next();
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put(entry.getValue(), testCaseWithStatus.getPassed());
            testCaseResultMap.put(entry.getKey(), map);
        }
        return testCaseResultMap;
    }

    private static void createTests(ZephyrConfigModel zephyrData, JSONObject bulkIssues, Map<Long, Map<String, Boolean>> testCaseResultMap, List<TestCaseResultModel> testCases) {
        String createURL = URL_CREATE_TESTS.replace("{SERVER}", zephyrData.getRestClient().getUrl());
        HttpPost httpPost = new HttpPost(createURL);
        httpPost.addHeader("Content-Type", "application/json");
        CloseableHttpResponse issueCreateResponse = null;
        try {
            StringEntity se = new StringEntity(bulkIssues.toString());
            httpPost.setEntity((HttpEntity)se);
            issueCreateResponse = zephyrData.getRestClient().getHttpclient().execute((HttpUriRequest)httpPost, (HttpContext)zephyrData.getRestClient().getContext());
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (ClientProtocolException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int statusCode1 = issueCreateResponse.getStatusLine().getStatusCode();
        if (statusCode1 < 200 || statusCode1 < 300) {
            // empty if block
        }
        if (issueCreateResponse != null) {
            try {
                issueCreateResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<Long, String> getAllCyclesByVersionId(ZephyrConfigModel zephyrData) {
        TreeMap<Long, String> cycles = new TreeMap<Long, String>();
        CloseableHttpResponse response = null;
        String url = URL_GET_CYCLES.replace("{SERVER}", zephyrData.getRestClient().getUrl()) + "?projectId=" + zephyrData.getZephyrProjectId() + "&versionId=" + zephyrData.getVersionId();
        try {
            response = zephyrData.getRestClient().getHttpclient().execute((HttpUriRequest)new HttpGet(url), (HttpContext)zephyrData.getRestClient().getContext());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            HttpEntity entity = response.getEntity();
            String string = null;
            try {
                string = EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                JSONObject projObj = new JSONObject(string);
                for (int i = 0; i < projObj.length(); ++i) {
                    Iterator keys = projObj.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if (key.trim().equals("-1")) continue;
                        JSONObject cycleObject = projObj.getJSONObject(key);
                        String cycleName = cycleObject.getString("name");
                        long id = Long.parseLong(key);
                        cycles.put(id, cycleName);
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            cycles.put(0L, "No Cycle");
            try {
                throw new ClientProtocolException("Unexpected response status: " + statusCode);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return cycles;
    }

    public static void assignTests(ZephyrConfigModel zephyrData, JSONObject jsonObject) {
        if (zephyrData.isZfjClud()) {
            try {
                TestCaseUtil.assignTestsZFJC(zephyrData, jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        Long cycleId = 0L;
        CloseableHttpResponse response = null;
        try {
            String assignTestsToCycleURL = URL_ASSIGN_TESTS.replace("{SERVER}", zephyrData.getRestClient().getUrl());
            StringEntity se = new StringEntity(jsonObject.toString());
            HttpPost createCycleRequest = new HttpPost(assignTestsToCycleURL);
            createCycleRequest.setHeader("Content-Type", "application/json");
            createCycleRequest.setEntity((HttpEntity)se);
            response = zephyrData.getRestClient().getHttpclient().execute((HttpUriRequest)createCycleRequest, (HttpContext)zephyrData.getRestClient().getContext());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity1 = response.getEntity();
        String token = null;
        try {
            String tokenObject = EntityUtils.toString((HttpEntity)entity1);
            token = new JSONObject(tokenObject).getString("jobProgressToken");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int maxTryCount = 0;
        boolean checkJobProgress = true;
        while (checkJobProgress) {
            ++maxTryCount;
            try {
                checkJobProgress = TestCaseUtil.checkJobProgress(zephyrData, token);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (checkJobProgress) {
                checkJobProgress = false;
            }
            if (maxTryCount != 10) continue;
            checkJobProgress = false;
        }
        if (statusCode < 200 || statusCode >= 300) {
            try {
                throw new ClientProtocolException("Unexpected response status: " + statusCode);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean checkJobProgress(ZephyrConfigModel zephyrData, String token) {
        try {
            TimeUnit.SECONDS.sleep(10L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        boolean jobCompleted = false;
        CloseableHttpResponse response = null;
        String url = null;
        if (zephyrData.isZfjClud()) {
            RestClient restClient = zephyrData.getRestClient();
            try {
                url = URL_JOB_PROGRESS_ZFJC.replace("{SERVER}", zephyrData.getRestClient().getZephyrCloudURL()).replace("{jobProgressToken}", token);
                String jwtHeaderValue = ServerInfo.generateJWT(restClient, url, "GET");
                HttpGet jobProgressRequest = new HttpGet(url);
                jobProgressRequest.addHeader("Content-Type", "application/json");
                jobProgressRequest.addHeader("Authorization", jwtHeaderValue);
                jobProgressRequest.addHeader("zapiAccessKey", restClient.getAccessKey());
                response = zephyrData.getRestClient().getHttpclient().execute((HttpUriRequest)jobProgressRequest, (HttpContext)zephyrData.getRestClient().getContext());
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                String progress = new JSONObject(result).get("progress").toString();
                if (progress != null && progress.equals("1.0")) {
                    jobCompleted = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            url = URL_JOB_PROGRESS.replace("{SERVER}", zephyrData.getRestClient().getUrl()).replace("{jobProgressToken}", token);
            RestClient restClient = zephyrData.getRestClient();
            try {
                HttpGet jobProgressRequest = new HttpGet(url);
                jobProgressRequest.setHeader("Content-Type", "application/json");
                response = zephyrData.getRestClient().getHttpclient().execute((HttpUriRequest)jobProgressRequest, (HttpContext)zephyrData.getRestClient().getContext());
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                String progress = new JSONObject(result).get("progress").toString();
                if (progress != null && progress.equals("1.0")) {
                    jobCompleted = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jobCompleted;
    }

    public static Map<String, Long> fetchExecutionIds(ZephyrConfigModel zephyrData, JSONObject jsonObject) {
        HashMap<String, Long> issueKeyExecutionIdMap = new HashMap<String, Long>();
        CloseableHttpResponse response = null;
        try {
            String executionsURL = URL_CREATE_EXECUTIONS_URL.replace("{SERVER}", zephyrData.getRestClient().getUrl()).replace("{projectId}", zephyrData.getZephyrProjectId() + "").replace("{versionId}", zephyrData.getVersionId() + "").replace("{cycleId}", zephyrData.getCycleId() + "");
            HttpGet executionsURLRequest = new HttpGet(executionsURL);
            response = zephyrData.getRestClient().getHttpclient().execute((HttpUriRequest)executionsURLRequest, (HttpContext)zephyrData.getRestClient().getContext());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            HttpEntity entity = response.getEntity();
            String string = null;
            try {
                string = EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                JSONObject executionObject = new JSONObject(string);
                JSONArray executions = executionObject.getJSONArray("executions");
                for (int i = 0; i < executions.length(); ++i) {
                    JSONObject execution = executions.getJSONObject(i);
                    String issueKey = execution.getString("issueKey").trim();
                    long executionId = execution.getLong("id");
                    issueKeyExecutionIdMap.put(issueKey, executionId);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            try {
                throw new ClientProtocolException("Unexpected response status: " + statusCode);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return issueKeyExecutionIdMap;
    }

    public static void executeTests(ZephyrConfigModel zephyrData, List<Long> passList, List<Long> failList) {
        CloseableHttpResponse response = null;
        try {
            StringEntity failEntity;
            String bulkExecuteTestsURL = URL_EXECUTE_TEST.replace("{SERVER}", zephyrData.getRestClient().getUrl());
            if (failList.size() > 0) {
                JSONArray failedTests = new JSONArray();
                JSONObject failObj = new JSONObject();
                for (long failedTest : failList) {
                    failedTests.put(failedTest);
                }
                failObj.put("executions", (Object)failedTests);
                failObj.put("status", 2);
                failEntity = new StringEntity(failObj.toString());
                HttpPut bulkUpdateFailedTests = new HttpPut(bulkExecuteTestsURL);
                bulkUpdateFailedTests.setHeader("Content-Type", "application/json");
                bulkUpdateFailedTests.setEntity((HttpEntity)failEntity);
                response = zephyrData.getRestClient().getHttpclient().execute((HttpUriRequest)bulkUpdateFailedTests, (HttpContext)zephyrData.getRestClient().getContext());
            }
            if (passList.size() > 0) {
                if (response != null) {
                    response.close();
                }
                JSONArray passedTests = new JSONArray();
                JSONObject passObj = new JSONObject();
                failEntity = passList.iterator();
                while (failEntity.hasNext()) {
                    long passedTest = failEntity.next();
                    passedTests.put(passedTest);
                }
                passObj.put("executions", (Object)passedTests);
                passObj.put("status", 1);
                StringEntity passEntity = new StringEntity(passObj.toString());
                HttpPut bulkUpdatePassedTests = new HttpPut(bulkExecuteTestsURL);
                bulkUpdatePassedTests.setHeader("Content-Type", "application/json");
                bulkUpdatePassedTests.setEntity((HttpEntity)passEntity);
                response = zephyrData.getRestClient().getHttpclient().execute((HttpUriRequest)bulkUpdatePassedTests, (HttpContext)zephyrData.getRestClient().getContext());
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode < 200 || statusCode >= 300) {
            try {
                throw new ClientProtocolException("Unexpected response status: " + statusCode);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void processTestCaseDetails(ZephyrConfigModel zephyrData) {
        Map<Long, Map<String, Boolean>> testCaseDetails = TestCaseUtil.getTestCaseDetails(zephyrData);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("versionId", (Object)zephyrData.getVersionId());
        jsonObject.put("projectId", (Object)zephyrData.getZephyrProjectId());
        jsonObject.put("method", (Object)"1");
        long cycleId = 0L;
        if (zephyrData.isZfjClud()) {
            if (zephyrData.getCycleIdZfjCloud() == null || zephyrData.getCycleIdZfjCloud() == "1000000000") {
                String cycleIdZFJC = Cycle.createCycleZFJC(zephyrData);
                zephyrData.setCycleIdZfjCloud(cycleIdZFJC);
                jsonObject.put("cycleId", (Object)cycleIdZFJC);
            } else {
                jsonObject.put("cycleId", (Object)zephyrData.getCycleIdZfjCloud());
            }
        } else {
            if (zephyrData.getCycleId() == null || zephyrData.getCycleId() == 1000000000L) {
                cycleId = Cycle.createCycle(zephyrData);
                zephyrData.setCycleId(cycleId);
                jsonObject.put("cycleId", cycleId);
            }
            jsonObject.put("cycleId", (Object)zephyrData.getCycleId());
        }
        ArrayList<JSONArray> issueKeyJSONArrayList = new ArrayList<JSONArray>();
        JSONArray jArr = new JSONArray();
        JSONObject createExecutionsJObj = new JSONObject();
        Set<Map.Entry<Long, Map<String, Boolean>>> entrySet = testCaseDetails.entrySet();
        for (Map.Entry<Long, Map<String, Boolean>> entry : entrySet) {
            Map<String, Boolean> value = entry.getValue();
            Set<String> keySet = value.keySet();
            for (String issueKey : keySet) {
                jArr.put((Object)issueKey);
                if (jArr.length() != 50) continue;
                issueKeyJSONArrayList.add(jArr);
                jArr = new JSONArray();
            }
        }
        issueKeyJSONArrayList.add(jArr);
        for (int i = 0; i < issueKeyJSONArrayList.size(); ++i) {
            jsonObject.put("issues", issueKeyJSONArrayList.get(i));
            TestCaseUtil.assignTests(zephyrData, jsonObject);
        }
        if (!zephyrData.isZfjClud()) {
            Map<String, Long> issueKeyExecutionIdMap = TestCaseUtil.fetchExecutionIds(zephyrData, createExecutionsJObj);
            ArrayList<Long> passList = new ArrayList<Long>();
            ArrayList<Long> failList = new ArrayList<Long>();
            for (Map.Entry<Long, Map<String, Boolean>> entry : entrySet) {
                Map<String, Boolean> value = entry.getValue();
                Set<String> keySet = value.keySet();
                for (String issueKey : keySet) {
                    createExecutionsJObj.put("issueId", (Object)entry.getKey());
                    createExecutionsJObj.put("versionId", (Object)zephyrData.getVersionId());
                    createExecutionsJObj.put("cycleId", (Object)zephyrData.getCycleId());
                    createExecutionsJObj.put("projectId", (Object)zephyrData.getZephyrProjectId());
                    boolean pass = value.get(issueKey);
                    Long executionId = issueKeyExecutionIdMap.get(issueKey);
                    if (pass) {
                        passList.add(executionId);
                        continue;
                    }
                    failList.add(executionId);
                }
            }
            TestCaseUtil.executeTests(zephyrData, passList, failList);
        } else {
            int totalExecutionsCount = 0;
            HashMap<String, String> issueKeyExecutionIdMap = new HashMap<String, String>();
            totalExecutionsCount = TestCaseUtil.fetchExecutionIdsZFJC(zephyrData, createExecutionsJObj, issueKeyExecutionIdMap, 0);
            while (issueKeyExecutionIdMap.size() < totalExecutionsCount) {
                TestCaseUtil.fetchExecutionIdsZFJC(zephyrData, createExecutionsJObj, issueKeyExecutionIdMap, issueKeyExecutionIdMap.size());
            }
            ArrayList<String> passList = new ArrayList<String>();
            ArrayList<String> failList = new ArrayList<String>();
            for (Map.Entry<Long, Map<String, Boolean>> entry : entrySet) {
                Map<String, Boolean> value = entry.getValue();
                Set<String> keySet = value.keySet();
                for (String issueKey : keySet) {
                    createExecutionsJObj.put("issueId", (Object)entry.getKey());
                    createExecutionsJObj.put("versionId", (Object)zephyrData.getVersionId());
                    createExecutionsJObj.put("cycleId", (Object)zephyrData.getCycleIdZfjCloud());
                    createExecutionsJObj.put("projectId", (Object)zephyrData.getZephyrProjectId());
                    boolean pass = value.get(issueKey);
                    String executionId = (String)issueKeyExecutionIdMap.get(issueKey);
                    if (pass) {
                        passList.add(executionId);
                        continue;
                    }
                    failList.add(executionId);
                }
            }
            TestCaseUtil.executeTestsZFJC(zephyrData, passList, failList);
        }
    }

    private static Map<String, Map<Long, String>> searchIssues(ZephyrConfigModel zephyrData) {
        CustomReturnTypeBean returnValue1;
        long searchIssueStartcount = -1L;
        long totalIssueCount = 0L;
        long searchedIsssuesCount = 0L;
        HashMap<String, Map<Long, String>> searchedTests = new HashMap<String, Map<Long, String>>();
        CustomReturnTypeBean returnValue = TestCaseUtil.searchTests(zephyrData, searchIssueStartcount, searchedTests);
        totalIssueCount = returnValue.getTotalIssuesCount();
        for (searchedIsssuesCount = returnValue.getSearchedIssuesCount(); searchedIsssuesCount < totalIssueCount; searchedIsssuesCount += returnValue1.getSearchedIssuesCount()) {
            returnValue1 = TestCaseUtil.searchTests(zephyrData, searchedIsssuesCount, searchedTests);
        }
        return searchedTests;
    }

    private static CustomReturnTypeBean searchTests(ZephyrConfigModel zephyrData, long searchIssueStartcount, Map<String, Map<Long, String>> searchedTests) {
        CustomReturnTypeBean customReturnTypeBean = new CustomReturnTypeBean();
        long totalIssueCount = 0L;
        CloseableHttpResponse response = null;
        String isssueSearchURL = null;
        String searchJQL = JQL_SEARCH_TESTS;
        searchJQL = searchJQL.replace("{pId}", zephyrData.getZephyrProjectId() + "");
        searchJQL = searchJQL.replace("{issueTypeId}", zephyrData.getTestIssueTypeId() + "");
        searchJQL = searchJQL.replace("{searchIssueStartcount}", searchIssueStartcount + "");
        isssueSearchURL = URL_GET_ALL_TESTS.replace("{SERVER}", zephyrData.getRestClient().getUrl()) + "?" + searchJQL;
        JSONArray searchedIssues = null;
        try {
            response = zephyrData.getRestClient().getHttpclient().execute((HttpUriRequest)new HttpGet(isssueSearchURL), (HttpContext)zephyrData.getRestClient().getContext());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            HttpEntity entity = response.getEntity();
            String string = null;
            try {
                string = EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                JSONObject testCaseIssues = new JSONObject(string);
                totalIssueCount = testCaseIssues.getLong("total");
                searchedIssues = testCaseIssues.getJSONArray("issues");
                customReturnTypeBean.setSearchedIssuesCount(searchedIssues.length());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            try {
                throw new ClientProtocolException("Unexpected response status: " + statusCode);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
        }
        try {
            if (searchedIssues != null && searchedIssues.length() > 0) {
                for (int i = 0; i < searchedIssues.length(); ++i) {
                    JSONObject jsonObject = searchedIssues.getJSONObject(i);
                    String testName = jsonObject.getJSONObject("fields").getString("summary").trim();
                    long testId = jsonObject.getLong("id");
                    String testKey = jsonObject.getString("key").trim();
                    HashMap<Long, String> tempTestIdTestKeyMap = new HashMap<Long, String>();
                    tempTestIdTestKeyMap.put(testId, testKey);
                    searchedTests.put(testName, tempTestIdTestKeyMap);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        customReturnTypeBean.setTotalIssuesCount(totalIssueCount);
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return customReturnTypeBean;
    }

    public static void assignTestsZFJC(ZephyrConfigModel zephyrData, JSONObject jsonObject) {
        CloseableHttpResponse response = null;
        try {
            RestClient restClient = zephyrData.getRestClient();
            String assignTestsToCycleURL = "{ZFJC_SERVER}/public/rest/api/1.0/executions/add/cycle/{CYCLEID}".replace("{ZFJC_SERVER}", restClient.getZephyrCloudURL()).replace("{CYCLEID}", zephyrData.getCycleIdZfjCloud());
            String jwtHeaderValue = ServerInfo.generateJWT(restClient, assignTestsToCycleURL, "POST");
            StringEntity se = new StringEntity(jsonObject.toString());
            HttpPost createCycleRequest = new HttpPost(assignTestsToCycleURL);
            createCycleRequest.addHeader("Content-Type", "application/json");
            createCycleRequest.addHeader("Authorization", jwtHeaderValue);
            createCycleRequest.addHeader("zapiAccessKey", restClient.getAccessKey());
            createCycleRequest.setEntity((HttpEntity)se);
            response = zephyrData.getRestClient().getHttpclient().execute((HttpUriRequest)createCycleRequest, (HttpContext)zephyrData.getRestClient().getContext());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity1 = response.getEntity();
        String token = null;
        try {
            token = EntityUtils.toString((HttpEntity)entity1);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int maxTryCount = 0;
        boolean checkJobProgress = true;
        while (checkJobProgress) {
            ++maxTryCount;
            try {
                checkJobProgress = TestCaseUtil.checkJobProgress(zephyrData, token);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (checkJobProgress) {
                checkJobProgress = false;
            }
            if (maxTryCount != 10) continue;
            checkJobProgress = false;
        }
        if (statusCode >= 200 && statusCode < 300) {
            HttpEntity entity = response.getEntity();
            String string = null;
            try {
                string = EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                throw new ClientProtocolException("Unexpected response status: " + statusCode);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static int fetchExecutionIdsZFJC(ZephyrConfigModel zephyrData, JSONObject jsonObject, Map<String, String> issueKeyExecutionIdMap, int offset) {
        int totalCount = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        CloseableHttpResponse response = null;
        try {
            RestClient restClient = zephyrData.getRestClient();
            String executionsURL = "{ZFJC_SERVER}/public/rest/api/1.0/executions/search/cycle/{CYCLEID}?projectId={PROJECTID}&versionId={VERSIONID}&offset={PAGINATION_OFFSET}&action=expand".replace("{ZFJC_SERVER}", restClient.getZephyrCloudURL()).replace("{CYCLEID}", zephyrData.getCycleIdZfjCloud()).replace("{PROJECTID}", zephyrData.getZephyrProjectId() + "").replace("{VERSIONID}", zephyrData.getVersionId() + "").replace("{PAGINATION_OFFSET}", offset + "");
            String jwtHeaderValue = ServerInfo.generateJWT(restClient, executionsURL, "GET");
            HttpGet executionsURLRequest = new HttpGet(executionsURL);
            executionsURLRequest.addHeader("Content-Type", "application/json");
            executionsURLRequest.addHeader("Authorization", jwtHeaderValue);
            executionsURLRequest.addHeader("zapiAccessKey", restClient.getAccessKey());
            response = zephyrData.getRestClient().getHttpclient().execute((HttpUriRequest)executionsURLRequest, (HttpContext)zephyrData.getRestClient().getContext());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            HttpEntity entity = response.getEntity();
            String string = null;
            try {
                string = EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                JSONObject executionObject = new JSONObject(string);
                JSONArray executions = executionObject.getJSONArray("searchObjectList");
                totalCount = executionObject.getInt("totalCount");
                for (int i = 0; i < executions.length(); ++i) {
                    JSONObject execution = executions.getJSONObject(i);
                    String issueKey = execution.getString("issueKey").trim();
                    String executionId = execution.getJSONObject("execution").getString("id");
                    map.put(issueKey, executionId);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            try {
                throw new ClientProtocolException("Unexpected response status: " + statusCode);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        issueKeyExecutionIdMap.putAll(map);
        return totalCount;
    }

    private static void executeTestsZFJC(ZephyrConfigModel zephyrData, List<String> passList, List<String> failList) {
        CloseableHttpResponse response = null;
        try {
            int passListSize;
            RestClient restClient = zephyrData.getRestClient();
            String bulkExecuteTestsURL = "{ZFJC_SERVER}/public/rest/api/1.0/executions".replace("{ZFJC_SERVER}", restClient.getZephyrCloudURL());
            String jwtHeaderValue = ServerInfo.generateJWT(restClient, bulkExecuteTestsURL, "POST");
            int failListSize = failList.size();
            if (failListSize > 0) {
                int bulkOperationSetCount = failListSize / 50;
                bulkOperationSetCount += failListSize % 50 > 0 ? 1 : 0;
                for (int i = 0; i < bulkOperationSetCount; ++i) {
                    List<String> tempFailList = failList.subList(i * 50, bulkOperationSetCount - i > 1 ? i * 50 + 50 : failList.size());
                    JSONArray failedTests = new JSONArray();
                    JSONObject failObj = new JSONObject();
                    for (String failedTest : tempFailList) {
                        failedTests.put((Object)failedTest);
                    }
                    failObj.put("executions", (Object)failedTests);
                    failObj.put("status", 2);
                    failObj.put("stepStatus", -1);
                    failObj.put("testStepStatusChangeFlag", true);
                    failObj.put("clearDefectMappingFlag", false);
                    StringEntity failEntity = new StringEntity(failObj.toString());
                    HttpPost bulkUpdateFailedTests = new HttpPost(bulkExecuteTestsURL);
                    bulkUpdateFailedTests.addHeader("Content-Type", "application/json");
                    bulkUpdateFailedTests.addHeader("Authorization", jwtHeaderValue);
                    bulkUpdateFailedTests.addHeader("zapiAccessKey", restClient.getAccessKey());
                    bulkUpdateFailedTests.setEntity((HttpEntity)failEntity);
                    if (response != null) {
                        response.close();
                    }
                    response = restClient.getHttpclient().execute((HttpUriRequest)bulkUpdateFailedTests);
                }
            }
            if ((passListSize = passList.size()) > 0) {
                int bulkOperationSetCount = passListSize / 50;
                bulkOperationSetCount += passListSize % 50 > 0 ? 1 : 0;
                for (int i = 0; i < bulkOperationSetCount; ++i) {
                    List<String> tempPassList = passList.subList(i * 50, bulkOperationSetCount - i > 1 ? i * 50 + 50 : passList.size());
                    JSONArray passedTests = new JSONArray();
                    JSONObject passObj = new JSONObject();
                    for (String passedTest : tempPassList) {
                        passedTests.put((Object)passedTest);
                    }
                    passObj.put("executions", (Object)passedTests);
                    passObj.put("status", 1);
                    passObj.put("stepStatus", -1);
                    passObj.put("testStepStatusChangeFlag", true);
                    passObj.put("clearDefectMappingFlag", false);
                    StringEntity passEntity = new StringEntity(passObj.toString());
                    HttpPost bulkUpdatePassedTests = new HttpPost(bulkExecuteTestsURL);
                    bulkUpdatePassedTests.addHeader("Content-Type", "application/json");
                    bulkUpdatePassedTests.addHeader("Authorization", jwtHeaderValue);
                    bulkUpdatePassedTests.addHeader("zapiAccessKey", restClient.getAccessKey());
                    bulkUpdatePassedTests.setEntity((HttpEntity)passEntity);
                    if (response != null) {
                        response.close();
                    }
                    response = restClient.getHttpclient().execute((HttpUriRequest)bulkUpdatePassedTests);
                }
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            HttpEntity entity = response.getEntity();
            String string = null;
            try {
                string = EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                throw new ClientProtocolException("Unexpected response status: " + statusCode);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
        }
    }

    static class CustomReturnTypeBean {
        private long totalIssuesCount;
        private long searchedIssuesCount;

        CustomReturnTypeBean() {
        }

        public long getTotalIssuesCount() {
            return this.totalIssuesCount;
        }

        public void setTotalIssuesCount(long totalIssuesCount) {
            this.totalIssuesCount = totalIssuesCount;
        }

        public long getSearchedIssuesCount() {
            return this.searchedIssuesCount;
        }

        public void setSearchedIssuesCount(long searchedIssuesCount) {
            this.searchedIssuesCount = searchedIssuesCount;
        }
    }
}

