/*
 * Decompiled with CFR 0.152.
 */
package com.thed.zephyr.jenkins.utils.rest;

import com.thed.zephyr.jenkins.model.ZephyrInstance;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class RestClient {
    private CloseableHttpClient httpclient;
    private HttpClientContext context;
    private String url;
    private String userName;
    private String password;
    private String zephyrCloudURL;
    private String accessKey;
    private String secretKey;

    public RestClient(String url, String userName, String password, String zephyrCloudURL, String accessKey, String secretKey) {
        this(url, userName, password);
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.zephyrCloudURL = zephyrCloudURL;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public RestClient(String url, String userName, String password) {
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.createClientContext(this.url, this.userName, this.password);
        this.createHttpClient();
    }

    public RestClient(@Nonnull ZephyrInstance zephyrServer) {
        this(zephyrServer.getServerAddress(), zephyrServer.getUsername(), zephyrServer.getPassword());
    }

    public void destroy() {
        if (this.httpclient != null) {
            try {
                this.httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private HttpClientContext createClientContext(String hostAddressWithProtocol, String userName, String password) {
        try {
            URL url = new URL(hostAddressWithProtocol);
            HttpHost targetHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(targetHost, (AuthScheme)new BasicScheme());
            this.context = HttpClientContext.create();
            this.context.setCredentialsProvider((CredentialsProvider)credsProvider);
            this.context.setAuthCache((AuthCache)authCache);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return this.context;
    }

    private void createHttpClient() {
        int connectTimeout = 10;
        int dataWaitTimeout = 3600;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(dataWaitTimeout * 1000).setConnectionRequestTimeout(dataWaitTimeout * 1000).setSocketTimeout(dataWaitTimeout * 1000).build();
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            this.httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (KeyStoreException e1) {
            e1.printStackTrace();
        }
    }

    public CloseableHttpClient getHttpclient() {
        return this.httpclient;
    }

    public HttpClientContext getContext() {
        return this.context;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getZephyrCloudURL() {
        return this.zephyrCloudURL;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }
}

