/*
 * Decompiled with CFR 0.152.
 */
package com.thed.zephyr.jenkins.utils.rest;

import com.thed.zephyr.jenkins.model.ZephyrConfigModel;
import com.thed.zephyr.jenkins.utils.rest.RestBase;
import com.thed.zephyr.jenkins.utils.rest.RestClient;
import com.thed.zephyr.jenkins.utils.rest.ServerInfo;
import com.thed.zephyr.jenkins.utils.rest.TestCaseUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Cycle
implements RestBase {
    public static final long NEW_CYCLE_KEY_IDENTIFIER = 1000000000L;
    private static String URL_GET_CYCLES = "{SERVER}/rest/zapi/latest/cycle?projectId={projectId}&versionId={versionId}";
    private static String URL_CREATE_CYCLES = "{SERVER}/rest/zapi/latest/cycle";
    private static String URL_DELETE_CYCLE = "{SERVER}/rest/zapi/latest/cycle/{id}";

    public static Long createCycle(ZephyrConfigModel zephyrData) {
        Long cycleId = 0L;
        CloseableHttpResponse response = null;
        try {
            String createCycleURL = URL_CREATE_CYCLES.replace("{SERVER}", zephyrData.getRestClient().getUrl());
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("E dd, yyyy hh:mm a");
            String dateFormatForCycleCreation = sdf.format(date);
            JSONObject jObject = new JSONObject();
            String cycleName = zephyrData.getCyclePrefix() + dateFormatForCycleCreation;
            SimpleDateFormat sdf1 = new SimpleDateFormat("d/MMM/yy");
            String startDate = sdf1.format(date);
            GregorianCalendar gCal = new GregorianCalendar();
            if (zephyrData.getCycleDuration().trim().equalsIgnoreCase("30 days")) {
                gCal.add(5, 29);
            } else if (zephyrData.getCycleDuration().trim().equalsIgnoreCase("7 days")) {
                gCal.add(5, 6);
            }
            String endDate = sdf1.format(gCal.getTime());
            jObject.put("name", (Object)cycleName);
            jObject.put("projectId", (Object)zephyrData.getZephyrProjectId());
            jObject.put("versionId", (Object)zephyrData.getVersionId());
            jObject.put("startDate", (Object)startDate);
            jObject.put("endDate", (Object)endDate);
            jObject.put("build", zephyrData.getBuilNumber());
            StringEntity se = new StringEntity(jObject.toString(), "utf-8");
            HttpPost createCycleRequest = new HttpPost(createCycleURL);
            createCycleRequest.setHeader("Content-Type", "application/json");
            createCycleRequest.setEntity((HttpEntity)se);
            response = zephyrData.getRestClient().getHttpclient().execute((HttpUriRequest)createCycleRequest, (HttpContext)zephyrData.getRestClient().getContext());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            HttpEntity entity = response.getEntity();
            String string = null;
            try {
                string = EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                JSONObject cycleObj = new JSONObject(string);
                cycleId = cycleObj.getLong("id");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if (statusCode == 405) {
            try {
                throw new ClientProtocolException("ZAPI plugin license is invalid" + statusCode);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
        } else {
            try {
                throw new ClientProtocolException("Unexpected response status: " + statusCode);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
        }
        return cycleId;
    }

    public static Long deleteCycle(ZephyrConfigModel zephyrData) {
        Long cycleId = 0L;
        CloseableHttpResponse response = null;
        try {
            String deleteCycleURL = URL_DELETE_CYCLE.replace("{SERVER}", zephyrData.getRestClient().getUrl()).replace("{id}", zephyrData.getCycleId() + "");
            HttpDelete createCycleRequest = new HttpDelete(deleteCycleURL);
            response = zephyrData.getRestClient().getHttpclient().execute((HttpUriRequest)createCycleRequest, (HttpContext)zephyrData.getRestClient().getContext());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            HttpEntity entity = response.getEntity();
            String string = null;
            try {
                string = EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                throw new ClientProtocolException("Unexpected response status: " + statusCode);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
        }
        return cycleId;
    }

    public static Map<String, String> getAllCyclesByVersionId(long versionId, RestClient restClient, String projectId) {
        TreeMap<String, String> cycles = new TreeMap<String, String>();
        CloseableHttpResponse response = null;
        String url = URL_GET_CYCLES.replace("{SERVER}", restClient.getUrl()).replace("{projectId}", projectId).replace("{versionId}", versionId + "");
        try {
            response = restClient.getHttpclient().execute((HttpUriRequest)new HttpGet(url), (HttpContext)restClient.getContext());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            HttpEntity entity = response.getEntity();
            String string = null;
            try {
                string = EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                JSONObject projObj = new JSONObject(string);
                for (int i = 0; i < projObj.length(); ++i) {
                    Iterator keys = projObj.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if (key.trim().equals("recordsCount")) continue;
                        JSONObject cycleObject = projObj.getJSONObject(key);
                        String cycleName = cycleObject.getString("name");
                        long id = Long.parseLong(key);
                        cycles.put(id + "", cycleName);
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return cycles;
    }

    public static Map<String, String> getAllCyclesByVersionIdZFJC(long versionId, RestClient restClient, String projectId) {
        TreeMap<String, String> cycles;
        block17: {
            cycles = new TreeMap<String, String>();
            CloseableHttpResponse response = null;
            try {
                String constructedURL = "{ZFJC_SERVER}/public/rest/api/1.0/cycles/search?versionId={VERSIONID}&projectId={PROJECTID}".replace("{ZFJC_SERVER}", restClient.getZephyrCloudURL()).replace("{PROJECTID}", projectId + "").replace("{VERSIONID}", versionId + "");
                String jwtHeaderValue = ServerInfo.generateJWT(restClient, constructedURL, "GET");
                HttpGet getRequest = new HttpGet(constructedURL);
                getRequest.addHeader("Content-Type", "text/plain");
                getRequest.addHeader("Authorization", jwtHeaderValue);
                getRequest.addHeader("zapiAccessKey", restClient.getAccessKey());
                response = restClient.getHttpclient().execute((HttpUriRequest)getRequest);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 400) {
                System.out.println("Bad request. Please check content type and other request parameters");
            } else if (statusCode == 401) {
                System.out.println("UnAuthorized");
            } else if (statusCode == 404) {
                System.out.println("Invalid Zephyr for JIRA Cloud URL");
            } else if (statusCode == 200) {
                HttpEntity entity = response.getEntity();
                String stringCycles = null;
                try {
                    stringCycles = EntityUtils.toString((HttpEntity)entity);
                    if (stringCycles != null && stringCycles.startsWith("[") && stringCycles.endsWith("]") && stringCycles.contains("tenantKey")) {
                        try {
                            JSONArray projObj = new JSONArray(stringCycles);
                            for (int i = 0; i < projObj.length(); ++i) {
                                JSONObject cycleObj = projObj.getJSONObject(i);
                                String cycleName = cycleObj.getString("name");
                                String id = cycleObj.getString("id");
                                cycles.put(id, cycleName);
                            }
                            break block17;
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            break block17;
                        }
                    }
                    System.out.println("Invalid cycle response : " + stringCycles);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return cycles;
    }

    public static void main(String[] args) {
        String jiraCloudAddress = "https://justforkix.atlassian.net";
        String jiraCloudUserName = "zal@getzephyr.com";
        String jiraCloudPassword = "Gr00v!12";
        String zephyrCloudAddress = "https://prod-api.zephyr4jiracloud.com/connect";
        String zephyrCloudAccessKey = "amlyYTpmMDJhZTJkZC1mZmE5LTQ5NWYtYTRiYy1lZTkyMzkyYjIwMzggemFsQGdldHplcGh5ci5jb20";
        String zephyrCloudSecretKey = "R8h5WK6TUSkiU2QmTnCGwn1r9M2nF0elb2Ll1gygAMI";
        RestClient restClient = new RestClient(jiraCloudAddress, jiraCloudUserName, jiraCloudPassword, zephyrCloudAddress, zephyrCloudAccessKey, zephyrCloudSecretKey);
        long zephyrProjectId = 10703L;
        long versionId = 10900L;
        ZephyrConfigModel zephyrData = new ZephyrConfigModel();
        zephyrData.setRestClient(restClient);
        zephyrData.setCyclePrefix("TestPrefix1");
        zephyrData.setCycleDuration("7 days");
        zephyrData.setZephyrProjectId(zephyrProjectId);
        zephyrData.setVersionId(versionId);
        zephyrData.setZfjClud(true);
        String createCycleZFJC = Cycle.createCycleZFJC(zephyrData);
        zephyrData.setCycleIdZfjCloud(createCycleZFJC);
        System.out.println("createCycleZFJC : " + createCycleZFJC);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("versionId", (Object)zephyrData.getVersionId());
        jsonObject.put("cycleId", (Object)zephyrData.getCycleIdZfjCloud());
        jsonObject.put("projectId", (Object)zephyrData.getZephyrProjectId());
        jsonObject.put("method", (Object)"1");
        jsonObject.put("assigneeType", (Object)"currentUser");
        JSONArray jArr = new JSONArray();
        jArr.put((Object)"SIP-881");
        jArr.put((Object)"SIP-882");
        jsonObject.put("issues", (Object)jArr);
        TestCaseUtil.assignTestsZFJC(zephyrData, jsonObject);
        HashMap<String, String> fetchExecutionIdsZFJC = new HashMap<String, String>();
        TestCaseUtil.fetchExecutionIdsZFJC(zephyrData, jsonObject, fetchExecutionIdsZFJC, 0);
        System.out.println("fetchExecutionIdsZFJC : " + fetchExecutionIdsZFJC);
    }

    public static String createCycleZFJC(ZephyrConfigModel zephyrData) {
        String cycleId;
        block25: {
            String string;
            HttpEntity entity;
            cycleId = null;
            CloseableHttpResponse response = null;
            try {
                RestClient restClient = zephyrData.getRestClient();
                String createCycleURL = "{ZFJC_SERVER}/public/rest/api/1.0/cycle".replace("{ZFJC_SERVER}", restClient.getZephyrCloudURL());
                String jwtHeaderValue = ServerInfo.generateJWT(restClient, createCycleURL, "POST");
                Date date = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("E dd, yyyy hh:mm a");
                String dateFormatForCycleCreation = sdf.format(date);
                JSONObject jObject = new JSONObject();
                String cycleName = zephyrData.getCyclePrefix() + dateFormatForCycleCreation;
                SimpleDateFormat sdf1 = new SimpleDateFormat("d/MMM/yy");
                String startDate = sdf1.format(date);
                GregorianCalendar gCal = new GregorianCalendar();
                if (zephyrData.getCycleDuration().trim().equalsIgnoreCase("30 days")) {
                    gCal.add(5, 29);
                } else if (zephyrData.getCycleDuration().trim().equalsIgnoreCase("7 days")) {
                    gCal.add(5, 6);
                }
                String endDate = sdf1.format(gCal.getTime());
                jObject.put("name", (Object)cycleName);
                jObject.put("projectId", (Object)zephyrData.getZephyrProjectId());
                jObject.put("versionId", (Object)zephyrData.getVersionId());
                jObject.put("startDate", date.getTime());
                jObject.put("endDate", gCal.getTimeInMillis());
                StringEntity se = new StringEntity(jObject.toString(), "utf-8");
                HttpPost createCycleRequest = new HttpPost(createCycleURL);
                createCycleRequest.addHeader("Content-Type", "application/json");
                createCycleRequest.addHeader("Authorization", jwtHeaderValue);
                createCycleRequest.addHeader("zapiAccessKey", restClient.getAccessKey());
                createCycleRequest.setEntity((HttpEntity)se);
                response = restClient.getHttpclient().execute((HttpUriRequest)createCycleRequest);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 200 && statusCode < 300) {
                entity = response.getEntity();
                string = null;
                try {
                    string = EntityUtils.toString((HttpEntity)entity);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    JSONObject cycleObj = new JSONObject(string);
                    cycleId = cycleObj.getString("id");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                if (statusCode == 401) {
                    entity = response.getEntity();
                    string = null;
                    try {
                        string = EntityUtils.toString((HttpEntity)entity);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        throw new ClientProtocolException("Unauthorized. Please check your accessKey and secretKey are valid" + statusCode);
                    }
                    catch (ClientProtocolException e) {
                        e.printStackTrace();
                        break block25;
                    }
                }
                if (statusCode == 405) {
                    try {
                        throw new ClientProtocolException("ZAPI plugin license is invalid" + statusCode);
                    }
                    catch (ClientProtocolException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        throw new ClientProtocolException("Unexpected response status: " + statusCode);
                    }
                    catch (ClientProtocolException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return cycleId;
    }
}

