/*
 * Decompiled with CFR 0.152.
 */
package com.thed.zephyr.jenkins.reporter;

import com.thed.zephyr.jenkins.model.TestCaseResultModel;
import com.thed.zephyr.jenkins.model.ZephyrCloudInstance;
import com.thed.zephyr.jenkins.model.ZephyrConfigModel;
import com.thed.zephyr.jenkins.model.ZephyrInstance;
import com.thed.zephyr.jenkins.reporter.ZfjDescriptor;
import com.thed.zephyr.jenkins.utils.rest.Project;
import com.thed.zephyr.jenkins.utils.rest.RestClient;
import com.thed.zephyr.jenkins.utils.rest.ServerInfo;
import com.thed.zephyr.jenkins.utils.rest.TestCaseUtil;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResultAction;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ZfjReporter
extends Notifier {
    public static PrintStream logger;
    private String serverAddress;
    private String projectKey;
    private String versionKey;
    private String cycleKey;
    private String cyclePrefix;
    private String cycleDuration;
    private static final String PluginName;
    private final String pInfo = String.format("%s [INFO]", PluginName);

    @DataBoundConstructor
    public ZfjReporter(String serverAddress, String projectKey, String versionKey, String cycleKey, String cycleDuration, String cyclePrefix) {
        this.serverAddress = serverAddress;
        this.projectKey = projectKey;
        this.versionKey = versionKey;
        this.cycleKey = cycleKey;
        this.cyclePrefix = cyclePrefix;
        this.cycleDuration = cycleDuration;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        logger = listener.getLogger();
        logger.printf("%s Examining test results...%n", this.pInfo);
        logger.printf(String.format("Build result is %s%n", build.getResult().toString()), new Object[0]);
        if (!this.validateBuildConfig()) {
            logger.println("Cannot Proceed. Please verify the job configuration");
            return false;
        }
        int number = build.getRootBuild().getNumber();
        ZephyrConfigModel zephyrConfig = this.initializeZephyrData();
        zephyrConfig.setBuilNumber(number);
        boolean prepareZephyrTests = this.prepareZephyrTests(build, zephyrConfig);
        if (!prepareZephyrTests) {
            logger.println("Error parsing surefire reports.");
            logger.println("Please ensure \"Publish JUnit test result report is added\" as a post build action");
            return false;
        }
        TestCaseUtil.processTestCaseDetails(zephyrConfig);
        zephyrConfig.getRestClient().destroy();
        logger.printf("%s Done.%n", this.pInfo);
        return true;
    }

    private boolean prepareZephyrTests(AbstractBuild build, ZephyrConfigModel zephyrConfig) {
        boolean status = true;
        HashMap<String, Boolean> zephyrTestCaseMap = new HashMap<String, Boolean>();
        TestResultAction testResultAction = (TestResultAction)build.getAction(TestResultAction.class);
        Collection suites = null;
        try {
            suites = testResultAction.getResult().getSuites();
        }
        catch (Exception e) {
            logger.println(e.getMessage());
        }
        if (suites == null || suites.size() == 0) {
            logger.println("Problem parsing JUnit test Results.");
            return false;
        }
        for (SuiteResult suiteResult : suites) {
            List cases = suiteResult.getCases();
            for (CaseResult caseResult : cases) {
                boolean isPassed = caseResult.isPassed();
                String name = caseResult.getFullName();
                if (zephyrTestCaseMap.containsKey(name)) continue;
                zephyrTestCaseMap.put(name, isPassed);
            }
        }
        logger.print("Total Test Cases : " + zephyrTestCaseMap.size());
        ArrayList<TestCaseResultModel> testcases = new ArrayList<TestCaseResultModel>();
        Set keySet = zephyrTestCaseMap.keySet();
        for (String testCaseName : keySet) {
            Boolean isPassed = (Boolean)zephyrTestCaseMap.get(testCaseName);
            JSONObject isssueType = new JSONObject();
            isssueType.put("id", (Object)(zephyrConfig.getTestIssueTypeId() + ""));
            JSONObject project = new JSONObject();
            project.put("id", (Object)zephyrConfig.getZephyrProjectId());
            JSONObject fields = new JSONObject();
            fields.put("project", (Object)project);
            fields.put("summary", (Object)testCaseName);
            fields.put("description", (Object)"Creating the Test via Jenkins");
            fields.put("issuetype", (Object)isssueType);
            JSONObject issue = new JSONObject();
            issue.put("fields", (Object)fields);
            TestCaseResultModel caseWithStatus = new TestCaseResultModel();
            caseWithStatus.setPassed(isPassed);
            caseWithStatus.setTestCase(issue.toString());
            caseWithStatus.setTestCaseName(testCaseName);
            testcases.add(caseWithStatus);
        }
        zephyrConfig.setTestcases(testcases);
        return status;
    }

    private boolean validateBuildConfig() {
        boolean valid = true;
        if (StringUtils.isBlank((String)this.serverAddress) || StringUtils.isBlank((String)this.projectKey) || StringUtils.isBlank((String)this.versionKey) || StringUtils.isBlank((String)this.cycleKey) || "Please Add Zephyr Server in the Global config".equals(this.serverAddress.trim()) || "Please Add Zephyr Server in the Global config".equals(this.projectKey.trim()) || "Please Add Zephyr Server in the Global config".equals(this.versionKey.trim()) || "Please Add Zephyr Server in the Global config".equals(this.cycleKey.trim())) {
            logger.println("Cannot Proceed");
            valid = false;
        }
        return valid;
    }

    private void determineTestIssueTypeId(ZephyrConfigModel zephyrConfig) {
        long testIssueTypeId = ServerInfo.findTestIssueTypeId(zephyrConfig.getRestClient());
        zephyrConfig.setTestIssueTypeId(testIssueTypeId);
    }

    private void determineCyclePrefix(ZephyrConfigModel zephyrConfig) {
        if (StringUtils.isNotBlank((String)this.cyclePrefix)) {
            zephyrConfig.setCyclePrefix(this.cyclePrefix + "_");
        } else {
            zephyrConfig.setCyclePrefix("Automation_");
        }
    }

    private ZephyrConfigModel initializeZephyrData() {
        ZephyrConfigModel zephyrConfig = new ZephyrConfigModel();
        String hostName = StringUtils.removeEnd((String)this.serverAddress, (String)"/");
        this.prepareRestClient(zephyrConfig, hostName);
        zephyrConfig.setCycleDuration(this.cycleDuration);
        this.determineProjectID(zephyrConfig);
        this.determineVersionID(zephyrConfig);
        this.determineCycleID(zephyrConfig);
        this.determineCyclePrefix(zephyrConfig);
        this.determineTestIssueTypeId(zephyrConfig);
        return zephyrConfig;
    }

    private void prepareRestClient(ZephyrConfigModel zephyrConfig, String url) {
        List<ZephyrInstance> jiraInstances = this.getDescriptor().getJiraInstances();
        List<ZephyrCloudInstance> jiraCloudInstances = this.getDescriptor().getJiraCloudInstances();
        String tempUserName = null;
        String tempPassword = null;
        RestClient restClient = null;
        if (this.serverAddress.contains("atlassian.net")) {
            for (ZephyrCloudInstance zephyrCloudInstance : jiraCloudInstances) {
                if (!zephyrCloudInstance.getJiraCloudAddress().trim().equals(this.serverAddress)) continue;
                String jiraCloudUserName = zephyrCloudInstance.getJiraCloudUserName();
                String jiraCloudPassword = zephyrCloudInstance.getJiraCloudPassword();
                String zephyrCloudAddress = zephyrCloudInstance.getZephyrCloudAddress();
                String zephyrCloudAccessKey = zephyrCloudInstance.getZephyrCloudAccessKey();
                String zephyrCloudSecretKey = zephyrCloudInstance.getZephyrCloudSecretKey();
                restClient = new RestClient(this.serverAddress, jiraCloudUserName, jiraCloudPassword, zephyrCloudAddress, zephyrCloudAccessKey, zephyrCloudSecretKey);
                zephyrConfig.setZfjClud(true);
                break;
            }
        } else {
            for (ZephyrInstance z : jiraInstances) {
                if (!z.getServerAddress().trim().equals(this.serverAddress)) continue;
                tempUserName = z.getUsername();
                tempPassword = z.getPassword();
                restClient = new RestClient(this.serverAddress, tempUserName, tempPassword);
                zephyrConfig.setZfjClud(false);
                break;
            }
        }
        zephyrConfig.setRestClient(restClient);
    }

    private void determineCycleID(ZephyrConfigModel zephyrConfig) {
        if (zephyrConfig.isZfjClud()) {
            if (this.cycleKey.equalsIgnoreCase("CreateNewCycle")) {
                zephyrConfig.setCycleId(1000000000L);
                zephyrConfig.setCycleIdZfjCloud("1000000000");
                return;
            }
            zephyrConfig.setCycleName(this.cycleKey);
            zephyrConfig.setCycleIdZfjCloud(this.cycleKey);
            return;
        }
        if (this.cycleKey.equalsIgnoreCase("CreateNewCycle")) {
            zephyrConfig.setCycleId(1000000000L);
            return;
        }
        long cycleId = 0L;
        try {
            cycleId = Long.parseLong(this.cycleKey);
        }
        catch (NumberFormatException e1) {
            logger.println("Cycle Key appears to be the name of the cycle");
            e1.printStackTrace();
        }
        zephyrConfig.setCycleName(this.cycleKey);
        zephyrConfig.setCycleId(cycleId);
    }

    private void determineVersionID(ZephyrConfigModel zephyrData) {
        long versionId = 0L;
        try {
            versionId = Long.parseLong(this.versionKey);
        }
        catch (NumberFormatException e1) {
            logger.println("Version Key appears to be Name of the Version");
            e1.printStackTrace();
        }
        zephyrData.setVersionId(versionId);
    }

    private void determineProjectID(ZephyrConfigModel zephyrData) {
        long projectId = 0L;
        try {
            projectId = Long.parseLong(this.projectKey);
        }
        catch (NumberFormatException e1) {
            logger.println("Project Key appears to be Name of the project");
            try {
                Long projectIdByName = Project.getProjectIdByName(this.projectKey, zephyrData.getRestClient());
                projectId = projectIdByName;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            e1.printStackTrace();
        }
        zephyrData.setZephyrProjectId(projectId);
    }

    public ZfjDescriptor getDescriptor() {
        return (ZfjDescriptor)super.getDescriptor();
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getVersionKey() {
        return this.versionKey;
    }

    public void setVersionKey(String versionKey) {
        this.versionKey = versionKey;
    }

    public String getCycleKey() {
        return this.cycleKey;
    }

    public void setCycleKey(String cycleKey) {
        this.cycleKey = cycleKey;
    }

    public String getCyclePrefix() {
        return this.cyclePrefix;
    }

    public void setCyclePrefix(String cyclePrefix) {
        this.cyclePrefix = cyclePrefix;
    }

    public String getCycleDuration() {
        return this.cycleDuration;
    }

    public void setCycleDuration(String cycleDuration) {
        this.cycleDuration = cycleDuration;
    }

    static {
        PluginName = new String("[ZapiTestResultReporter]");
    }
}

