/*
 * Decompiled with CFR 0.152.
 */
package com.thed.zephyr.jenkins.reporter;

import com.thed.zephyr.jenkins.model.ZephyrCloudInstance;
import com.thed.zephyr.jenkins.model.ZephyrInstance;
import com.thed.zephyr.jenkins.reporter.ZfjReporter;
import com.thed.zephyr.jenkins.utils.ConfigurationValidator;
import com.thed.zephyr.jenkins.utils.URLValidator;
import com.thed.zephyr.jenkins.utils.rest.Cycle;
import com.thed.zephyr.jenkins.utils.rest.Project;
import com.thed.zephyr.jenkins.utils.rest.RestClient;
import com.thed.zephyr.jenkins.utils.rest.ServerInfo;
import com.thed.zephyr.jenkins.utils.rest.Version;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public final class ZfjDescriptor
extends BuildStepDescriptor<Publisher> {
    private List<ZephyrInstance> jiraInstances;
    private List<ZephyrCloudInstance> jiraCloudInstances;
    private String[] config = new String[5];

    public ZfjDescriptor() {
        super(ZfjReporter.class);
        this.load();
    }

    public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        return (Publisher)super.newInstance(req, formData);
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        JSONObject jObj;
        JSONArray jArr;
        req.bindParameters((Object)this);
        this.jiraInstances = new ArrayList<ZephyrInstance>();
        this.jiraCloudInstances = new ArrayList<ZephyrCloudInstance>();
        Object jiraInstancesObject = formData.getJSONObject("dynamic").get("jiraInstances");
        Object jiraCloudInstancesObject = formData.getJSONObject("dynamic").get("jiraCloudInstances");
        if (jiraInstancesObject instanceof JSONArray) {
            jArr = (JSONArray)jiraInstancesObject;
            for (JSONObject jObj2 : jArr) {
                ZephyrInstance zephyrInstance = new ZephyrInstance();
                String server = jObj2.getString("serverAddress").trim();
                String user = jObj2.getString("username").trim();
                String pass = jObj2.getString("password").trim();
                server = StringUtils.removeEnd((String)server, (String)"/");
                zephyrInstance.setServerAddress(server);
                zephyrInstance.setUsername(user);
                zephyrInstance.setPassword(pass);
                RestClient restClient = new RestClient(server, user, pass);
                boolean zephyrServerValidation = ConfigurationValidator.validateZephyrConfiguration(restClient);
                restClient.destroy();
                if (!zephyrServerValidation) continue;
                this.jiraInstances.add(zephyrInstance);
            }
        } else if (jiraInstancesObject instanceof JSONObject) {
            jObj = formData.getJSONObject("dynamic").getJSONObject("jiraInstances");
            ZephyrInstance zephyrInstance = new ZephyrInstance();
            String server = jObj.getString("serverAddress").trim();
            String user = jObj.getString("username").trim();
            String pass = jObj.getString("password").trim();
            server = StringUtils.removeEnd((String)server, (String)"/");
            zephyrInstance.setServerAddress(server);
            zephyrInstance.setUsername(user);
            zephyrInstance.setPassword(pass);
            RestClient restClient = new RestClient(server, user, pass);
            boolean zephyrServerValidation = ConfigurationValidator.validateZephyrConfiguration(restClient);
            restClient.destroy();
            if (zephyrServerValidation) {
                this.jiraInstances.add(zephyrInstance);
            }
        }
        if (jiraCloudInstancesObject instanceof JSONArray) {
            jArr = (JSONArray)jiraCloudInstancesObject;
            for (JSONObject jObj2 : jArr) {
                ZephyrCloudInstance zephyrCloudInstance = new ZephyrCloudInstance();
                String jiraCloudAddress = jObj2.getString("jiraCloudAddress").trim();
                String zephyrCloudAddress = jObj2.getString("zephyrCloudAddress").trim();
                String jiraCloudUserName = jObj2.getString("jiraCloudUserName").trim();
                String jiraCloudPassword = jObj2.getString("jiraCloudPassword").trim();
                String zephyrCloudAccessKey = jObj2.getString("zephyrCloudAccessKey").trim();
                String zephyrCloudSecretKey = jObj2.getString("zephyrCloudSecretKey").trim();
                jiraCloudAddress = StringUtils.removeEnd((String)jiraCloudAddress, (String)"/");
                zephyrCloudAddress = StringUtils.removeEnd((String)zephyrCloudAddress, (String)"/");
                zephyrCloudInstance.setJiraCloudAddress(jiraCloudAddress);
                zephyrCloudInstance.setZephyrCloudAddress(zephyrCloudAddress);
                zephyrCloudInstance.setJiraCloudUserName(jiraCloudUserName);
                zephyrCloudInstance.setJiraCloudPassword(jiraCloudPassword);
                zephyrCloudInstance.setZephyrCloudAccessKey(zephyrCloudAccessKey);
                zephyrCloudInstance.setZephyrCloudSecretKey(zephyrCloudSecretKey);
                this.jiraCloudInstances.add(zephyrCloudInstance);
            }
        } else if (jiraCloudInstancesObject instanceof JSONObject) {
            jObj = formData.getJSONObject("dynamic").getJSONObject("jiraCloudInstances");
            ZephyrCloudInstance zephyrCloudInstance = new ZephyrCloudInstance();
            String jiraCloudAddress = jObj.getString("jiraCloudAddress").trim();
            String zephyrCloudAddress = jObj.getString("zephyrCloudAddress").trim();
            String jiraCloudUserName = jObj.getString("jiraCloudUserName").trim();
            String jiraCloudPassword = jObj.getString("jiraCloudPassword").trim();
            String zephyrCloudAccessKey = jObj.getString("zephyrCloudAccessKey").trim();
            String zephyrCloudSecretKey = jObj.getString("zephyrCloudSecretKey").trim();
            jiraCloudAddress = StringUtils.removeEnd((String)jiraCloudAddress, (String)"/");
            zephyrCloudAddress = StringUtils.removeEnd((String)zephyrCloudAddress, (String)"/");
            zephyrCloudInstance.setJiraCloudAddress(jiraCloudAddress);
            zephyrCloudInstance.setZephyrCloudAddress(zephyrCloudAddress);
            zephyrCloudInstance.setJiraCloudUserName(jiraCloudUserName);
            zephyrCloudInstance.setJiraCloudPassword(jiraCloudPassword);
            zephyrCloudInstance.setZephyrCloudAccessKey(zephyrCloudAccessKey);
            zephyrCloudInstance.setZephyrCloudSecretKey(zephyrCloudSecretKey);
            this.jiraCloudInstances.add(zephyrCloudInstance);
        }
        this.save();
        return super.configure(req, formData);
    }

    public String getDisplayName() {
        return "Publish test result to Zephyr for JIRA";
    }

    public FormValidation doTestConnection(@QueryParameter String serverAddress, @QueryParameter String username, @QueryParameter String password) {
        if (StringUtils.isBlank((String)(serverAddress = StringUtils.removeEnd((String)serverAddress, (String)"/")))) {
            return FormValidation.error((String)"Please enter the server name");
        }
        if (StringUtils.isBlank((String)username)) {
            return FormValidation.error((String)"Please enter the username");
        }
        if (StringUtils.isBlank((String)password)) {
            return FormValidation.error((String)"Please enter the password");
        }
        if (!serverAddress.trim().startsWith("https://") && !serverAddress.trim().startsWith("http://")) {
            return FormValidation.error((String)"Incorrect server address format");
        }
        String jiraURL = URLValidator.validateURL(serverAddress);
        if (!jiraURL.startsWith("http")) {
            return FormValidation.error((String)jiraURL);
        }
        RestClient restClient = new RestClient(serverAddress, username, password);
        if (!ServerInfo.findServerAddressIsValidZephyrURL(restClient)) {
            return FormValidation.error((String)"This is not a valid Jira Server");
        }
        if (!ServerInfo.validateCredentials(restClient)) {
            return FormValidation.error((String)"Invalid user credentials");
        }
        restClient.destroy();
        return FormValidation.ok((String)"Connection to JIRA has been validated");
    }

    public FormValidation doTestZephyrCloudConnection(@QueryParameter String jiraCloudAddress, @QueryParameter String zephyrCloudAddress, @QueryParameter String jiraCloudUserName, @QueryParameter String jiraCloudPassword, @QueryParameter String zephyrCloudAccessKey, @QueryParameter String zephyrCloudSecretKey) {
        jiraCloudAddress = StringUtils.removeEnd((String)jiraCloudAddress, (String)"/");
        zephyrCloudAddress = StringUtils.removeEnd((String)zephyrCloudAddress, (String)"/");
        if (StringUtils.isBlank((String)jiraCloudAddress)) {
            return FormValidation.error((String)"Please enter the JIRA Cloud URL");
        }
        if (StringUtils.isBlank((String)zephyrCloudAddress)) {
            return FormValidation.error((String)"Please enter the Zephyr for JIRA Cloud base URL");
        }
        if (StringUtils.isBlank((String)jiraCloudUserName)) {
            return FormValidation.error((String)"Please enter the JIRA Cloud user name");
        }
        if (StringUtils.isBlank((String)jiraCloudPassword)) {
            return FormValidation.error((String)"Please enter the JIRA Cloud user password");
        }
        if (StringUtils.isBlank((String)zephyrCloudAccessKey)) {
            return FormValidation.error((String)"Please enter the Zephyr for JIRA Cloud access key");
        }
        if (StringUtils.isBlank((String)zephyrCloudSecretKey)) {
            return FormValidation.error((String)"Please enter the Zephyr for JIRA Cloud secret key");
        }
        if (!jiraCloudAddress.trim().startsWith("https://") && !jiraCloudAddress.trim().startsWith("http://")) {
            return FormValidation.error((String)"Incorrect server address format (JIRA Cloud)");
        }
        if (!zephyrCloudAddress.trim().startsWith("https://") && !zephyrCloudAddress.trim().startsWith("http://")) {
            return FormValidation.error((String)"Incorrect server address format (Zephyr for JIRA Cloud)");
        }
        String jiraCloudAddr = URLValidator.validateURL(jiraCloudAddress);
        if (!jiraCloudAddr.startsWith("http")) {
            return FormValidation.error((String)jiraCloudAddr);
        }
        String zephyrCloudAddr = URLValidator.validateURL(zephyrCloudAddress);
        if (!zephyrCloudAddr.startsWith("http")) {
            return FormValidation.error((String)zephyrCloudAddr);
        }
        RestClient restClient = new RestClient(jiraCloudAddr, jiraCloudUserName, jiraCloudPassword);
        if (!ServerInfo.findServerAddressIsValidZephyrURL(restClient)) {
            return FormValidation.error((String)"This is not a valid Jira Server");
        }
        if (!ServerInfo.validateCredentials(restClient)) {
            return FormValidation.error((String)"Invalid user credentials");
        }
        restClient.destroy();
        RestClient restClient2 = new RestClient(jiraCloudAddress, jiraCloudUserName, jiraCloudPassword, zephyrCloudAddress, zephyrCloudAccessKey, zephyrCloudSecretKey);
        Map<Boolean, String> findServerAddressIsValidZephyrCloudURL = ServerInfo.findServerAddressIsValidZephyrCloudURL(restClient2);
        if (!findServerAddressIsValidZephyrCloudURL.containsKey(true)) {
            return FormValidation.error((String)findServerAddressIsValidZephyrCloudURL.get(false));
        }
        return FormValidation.ok((String)"Validated sucessfully !");
    }

    public ListBoxModel doFillServerAddressItems(@QueryParameter String serverAddress) {
        ListBoxModel m = this.fetchServerList(serverAddress);
        return m;
    }

    public ListBoxModel doFillProjectKeyItems(@QueryParameter String serverAddress) {
        if (StringUtils.isBlank((String)serverAddress)) {
            ListBoxModel mi = this.fetchServerList(serverAddress);
            serverAddress = ((ListBoxModel.Option)mi.get((int)0)).value;
        }
        ListBoxModel m = new ListBoxModel();
        if (serverAddress.trim().equals("Please Add Zephyr Server in the Global config") || this.jiraInstances.size() == 0 && this.jiraCloudInstances.size() == 0) {
            m.add("Please Add Zephyr Server in the Global config");
            return m;
        }
        this.fetchProjectList(serverAddress, m);
        return m;
    }

    public ListBoxModel doFillVersionKeyItems(@QueryParameter String projectKey, @QueryParameter String serverAddress) {
        if (StringUtils.isBlank((String)serverAddress)) {
            ListBoxModel mi = this.fetchServerList(serverAddress);
            serverAddress = ((ListBoxModel.Option)mi.get((int)0)).value;
        }
        if (StringUtils.isBlank((String)projectKey)) {
            ListBoxModel mp = new ListBoxModel();
            if (serverAddress.trim().equals("Please Add Zephyr Server in the Global config") || this.jiraInstances.size() == 0 && this.jiraCloudInstances.size() == 0) {
                mp.add("Please Add Zephyr Server in the Global config");
            } else {
                this.fetchProjectList(serverAddress, mp);
            }
            projectKey = ((ListBoxModel.Option)mp.get((int)0)).value;
        }
        ListBoxModel m = new ListBoxModel();
        if (StringUtils.isBlank((String)projectKey) || projectKey.trim().equals("Please Add Zephyr Server in the Global config") || this.jiraInstances.size() == 0 && this.jiraCloudInstances.size() == 0) {
            m.add("Please Add Zephyr Server in the Global config");
            return m;
        }
        this.fetchVersionList(projectKey, serverAddress, m);
        return m;
    }

    public ListBoxModel doFillCycleKeyItems(@QueryParameter String versionKey, @QueryParameter String serverAddress, @QueryParameter String projectKey) {
        ListBoxModel m = new ListBoxModel();
        if (StringUtils.isBlank((String)serverAddress)) {
            ListBoxModel ms = this.fetchServerList(serverAddress);
            serverAddress = ((ListBoxModel.Option)ms.get((int)0)).value;
        }
        if (StringUtils.isBlank((String)projectKey)) {
            ListBoxModel mp = new ListBoxModel();
            if (serverAddress.trim().equals("Please Add Zephyr Server in the Global config") || this.jiraInstances.size() == 0 && this.jiraCloudInstances.size() == 0) {
                mp.add("Please Add Zephyr Server in the Global config");
            } else {
                this.fetchProjectList(serverAddress, mp);
            }
            projectKey = ((ListBoxModel.Option)mp.get((int)0)).value;
        }
        if (StringUtils.isBlank((String)versionKey)) {
            ListBoxModel mv = new ListBoxModel();
            if (StringUtils.isBlank((String)projectKey) || projectKey.trim().equals("Please Add Zephyr Server in the Global config") || this.jiraInstances.size() == 0 && this.jiraCloudInstances.size() == 0) {
                mv.add("Please Add Zephyr Server in the Global config");
            } else {
                this.fetchVersionList(projectKey, serverAddress, mv);
            }
            versionKey = ((ListBoxModel.Option)mv.get((int)0)).value;
        }
        if (StringUtils.isBlank((String)versionKey) || versionKey.trim().equals("Please Add Zephyr Server in the Global config") || this.jiraInstances.size() == 0 && this.jiraCloudInstances.size() == 0) {
            m.add("Please Add Zephyr Server in the Global config");
            return m;
        }
        long versionId = Long.parseLong(versionKey);
        RestClient restClient = this.getRestclient(serverAddress);
        Map<String, String> cycles = null;
        cycles = serverAddress.contains("atlassian.net") ? Cycle.getAllCyclesByVersionIdZFJC(versionId, restClient, projectKey) : Cycle.getAllCyclesByVersionId(versionId, restClient, projectKey);
        Set<Map.Entry<String, String>> cycleEntrySet = cycles.entrySet();
        for (Map.Entry<String, String> entry : cycleEntrySet) {
            m.add(entry.getValue(), entry.getKey());
        }
        m.add("New Cycle", "CreateNewCycle");
        restClient.destroy();
        return m;
    }

    public ListBoxModel doFillCycleDurationItems(@QueryParameter String versionKey, @QueryParameter String serverAddress) {
        ListBoxModel m = new ListBoxModel();
        m.add("30 days");
        m.add("7 days");
        m.add("1 day");
        return m;
    }

    private ListBoxModel fetchServerList(String serverAddress) {
        ListBoxModel m = new ListBoxModel();
        if (this.jiraInstances.size() > 0) {
            for (ZephyrInstance s : this.jiraInstances) {
                m.add(s.getServerAddress());
                if (!StringUtils.isBlank((String)this.config[0])) continue;
                this.config[0] = s.getServerAddress();
            }
        } else if (this.jiraCloudInstances.size() > 0) {
            for (ZephyrCloudInstance zephyrCloudInstance : this.jiraCloudInstances) {
                m.add(zephyrCloudInstance.getJiraCloudAddress());
                if (!StringUtils.isBlank((String)this.config[0])) continue;
                this.config[0] = zephyrCloudInstance.getJiraCloudAddress();
            }
        } else if (StringUtils.isBlank((String)serverAddress) || serverAddress.trim().equals("Please Add Zephyr Server in the Global config")) {
            m.add("Please Add Zephyr Server in the Global config");
        } else {
            m.add("Please Add Zephyr Server in the Global config");
        }
        return m;
    }

    private void fetchProjectList(String serverAddress, ListBoxModel m) {
        RestClient restClient = null;
        restClient = this.getRestclient(serverAddress);
        Map<Long, String> projects = Project.getAllProjects(restClient);
        Set<Map.Entry<Long, String>> projectEntrySet = projects.entrySet();
        for (Map.Entry<Long, String> entry : projectEntrySet) {
            m.add(entry.getValue(), entry.getKey() + "");
            if (!StringUtils.isBlank((String)this.config[1])) continue;
            this.config[1] = entry.getKey() + "";
        }
        restClient.destroy();
    }

    private void fetchVersionList(String projectKey, String serverAddress, ListBoxModel m) {
        long parseLong = Long.parseLong(projectKey);
        RestClient restClient = this.getRestclient(serverAddress);
        Map<Long, String> versions = Version.getVersionsByProjectID(parseLong, restClient);
        Set<Map.Entry<Long, String>> versionEntrySet = versions.entrySet();
        for (Map.Entry<Long, String> entry : versionEntrySet) {
            m.add(entry.getValue(), entry.getKey() + "");
            if (!StringUtils.isBlank((String)this.config[2])) continue;
            this.config[2] = entry.getKey() + "";
        }
        restClient.destroy();
    }

    private RestClient getRestclient(String serverAddress) {
        String tempUserName = null;
        String tempPassword = null;
        RestClient restClient = null;
        if (serverAddress.contains("atlassian.net")) {
            for (ZephyrCloudInstance zephyrCloudInstance : this.jiraCloudInstances) {
                if (!zephyrCloudInstance.getJiraCloudAddress().trim().equals(serverAddress)) continue;
                String jiraCloudUserName = zephyrCloudInstance.getJiraCloudUserName();
                String jiraCloudPassword = zephyrCloudInstance.getJiraCloudPassword();
                String zephyrCloudAddress = zephyrCloudInstance.getZephyrCloudAddress();
                String zephyrCloudAccessKey = zephyrCloudInstance.getZephyrCloudAccessKey();
                String zephyrCloudSecretKey = zephyrCloudInstance.getZephyrCloudSecretKey();
                restClient = new RestClient(serverAddress, jiraCloudUserName, jiraCloudPassword, zephyrCloudAddress, zephyrCloudAccessKey, zephyrCloudSecretKey);
            }
        } else {
            for (ZephyrInstance z : this.jiraInstances) {
                if (!z.getServerAddress().trim().equals(serverAddress)) continue;
                tempUserName = z.getUsername();
                tempPassword = z.getPassword();
                restClient = new RestClient(serverAddress, tempUserName, tempPassword);
            }
        }
        return restClient;
    }

    public List<ZephyrInstance> getJiraInstances() {
        return this.jiraInstances;
    }

    public void setJiraInstances(List<ZephyrInstance> jiraInstances) {
        this.jiraInstances = jiraInstances;
    }

    public List<ZephyrCloudInstance> getJiraCloudInstances() {
        return this.jiraCloudInstances;
    }

    public void setJiraCloudInstances(List<ZephyrCloudInstance> jiraCloudInstances) {
        this.jiraCloudInstances = jiraCloudInstances;
    }
}

