/*
 * Decompiled with CFR 0.152.
 */
package com.thed.zephyr.cloud.rest.model;

import com.atlassian.connect.play.java.AcHost;
import com.atlassian.fugue.Option;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ZConfig
extends PropertiesConfiguration {
    public Option<String> USER_NAME;
    public String JIRA_HOST_KEY;
    public String JIRA_BASE_URL;
    public String JIRA_SHARED_SECRET;
    public String ZEPHYR_BASE_URL;
    public String APP_KEY;
    public String SECRET_KEY;
    public String ACCESS_KEY;
    public AcHost host;
    final List<String> reqdConfigKeys = ImmutableList.builder().add((Object)"userName").add((Object)"jiraHostKey").add((Object)"jiraBaseURL").add((Object)"sharedSecret").add((Object)"zephyrBaseURL").add((Object)"accessKey").add((Object)"secretKey").add((Object)"appKey").build();

    private ZConfig() {
    }

    public ZConfig(String accessKey, String secretKey, String userName, String zephyrBaseUrl) {
        this.JIRA_HOST_KEY = accessKey;
        this.JIRA_SHARED_SECRET = secretKey;
        this.ZEPHYR_BASE_URL = zephyrBaseUrl;
        this.ACCESS_KEY = accessKey;
        this.USER_NAME = Option.option((Object)userName);
        this.host = new AcHost();
        this.host.setKey(this.JIRA_HOST_KEY);
        this.host.setBaseUrl(this.JIRA_BASE_URL);
        this.host.setSharedSecret(this.JIRA_SHARED_SECRET);
    }

    public ZConfig(String fileName) throws ConfigurationException {
        super(fileName);
        this.configure();
    }

    public ZConfig(Map<String, String> props) throws ConfigurationException {
        for (Map.Entry<String, String> prop : props.entrySet()) {
            this.addProperty(prop.getKey(), prop.getValue());
        }
        this.configure();
    }

    private void configure() throws ConfigurationException {
        this.checkMandatoryPropertiesSet();
        this.setLocalPropertyValues();
    }

    private void checkMandatoryPropertiesSet() throws ConfigurationException {
        for (String key : this.reqdConfigKeys) {
            if (this.containsKey(key)) continue;
            this.getLogger().fatal((Object)(key + "is required in ZFJ Cloud configration"));
            throw new ConfigurationException(key + "is required in ZFJ Cloud configration");
        }
    }

    private void setLocalPropertyValues() {
        this.JIRA_HOST_KEY = this.getString("accessKey");
        this.JIRA_SHARED_SECRET = this.getString("secretKey");
        this.ZEPHYR_BASE_URL = this.getString("zephyrBaseURL");
        this.ACCESS_KEY = this.getString("accessKey");
        this.USER_NAME = Option.some((Object)this.getString("userName"));
        this.host = new AcHost();
        this.host.setKey(this.JIRA_HOST_KEY);
        this.host.setBaseUrl(this.JIRA_BASE_URL);
        this.host.setSharedSecret(this.JIRA_SHARED_SECRET);
    }

    public static class ZConfigBuilder {
        private ZConfig zconfig = new ZConfig();

        public ZConfigBuilder withJiraHostKey(String hostKey) {
            this.zconfig.addProperty("jiraHostKey", hostKey);
            return this;
        }

        public ZConfigBuilder withJIRABaseUrl(String baseUrl) {
            this.zconfig.addProperty("jiraBaseURL", baseUrl);
            return this;
        }

        public ZConfigBuilder withJIRASharedSecret(String sharedSecret) {
            this.zconfig.addProperty("sharedSecret", sharedSecret);
            return this;
        }

        public ZConfigBuilder withZephyrBaseUrl(String zephyrBaseUrl) {
            this.zconfig.addProperty("zephyrBaseURL", zephyrBaseUrl);
            return this;
        }

        public ZConfigBuilder withZephyrAppKey(String appKey) {
            this.zconfig.addProperty("appKey", appKey);
            return this;
        }

        public ZConfigBuilder withZephyrAccessKey(String accessKey) {
            this.zconfig.addProperty("accessKey", accessKey);
            return this;
        }

        public ZConfigBuilder withZephyrSecretKey(String secretKey) {
            this.zconfig.addProperty("secretKey", secretKey);
            return this;
        }

        public ZConfigBuilder withJiraUserName(String userName) {
            this.zconfig.addProperty("userName", userName);
            return this;
        }

        public ZConfig build() throws ConfigurationException {
            this.zconfig.configure();
            return this.zconfig;
        }
    }
}

