/*
 * Decompiled with CFR 0.152.
 */
package com.thed.zephyr.cloud.rest.client.impl;

import com.atlassian.connect.play.java.AcHost;
import com.atlassian.connect.play.java.http.HttpMethod;
import com.atlassian.fugue.Option;
import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.core.TimeUtil;
import com.atlassian.jwt.core.writer.JsonSmartJwtJsonBuilder;
import com.atlassian.jwt.core.writer.JwtClaimsBuilder;
import com.atlassian.jwt.core.writer.NimbusJwtWriterFactory;
import com.atlassian.jwt.exception.JwtIssuerLacksSharedSecretException;
import com.atlassian.jwt.exception.JwtSigningException;
import com.atlassian.jwt.exception.JwtUnknownIssuerException;
import com.atlassian.jwt.httpclient.CanonicalHttpUriRequest;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import com.atlassian.jwt.writer.JwtWriter;
import com.atlassian.jwt.writer.JwtWriterFactory;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.thed.zephyr.cloud.rest.client.JwtAuthorizationGenerator;
import com.thed.zephyr.cloud.rest.client.JwtGenerator;
import com.thed.zephyr.cloud.rest.model.ZConfig;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;

public class JwtGeneratorImpl
implements JwtGenerator {
    private ZConfig zConfig;

    public JwtGeneratorImpl(ZConfig zConfig) {
        this.zConfig = zConfig;
    }

    @Override
    public String generateJWT(String requestMethod, URI uri, final int jwtExpiryWindowSeconds) {
        NimbusJwtWriterFactory jwtWriterFactory = new NimbusJwtWriterFactory();
        char[] QUERY_DELIMITERS = new char[]{'&'};
        JwtAuthorizationGenerator jwtAuthorisationGenerator = new JwtAuthorizationGenerator((JwtWriterFactory)jwtWriterFactory, jwtExpiryWindowSeconds, (JwtWriterFactory)jwtWriterFactory, QUERY_DELIMITERS){
            final /* synthetic */ JwtWriterFactory val$jwtWriterFactory;
            final /* synthetic */ char[] val$QUERY_DELIMITERS;
            {
                this.val$jwtWriterFactory = jwtWriterFactory2;
                this.val$QUERY_DELIMITERS = cArray;
                super(jwtWriterFactory, jwtExpiryWindowSeconds2);
            }

            @Override
            public Option<String> generate(HttpMethod httpMethod, URI url, Map<String, List<String>> parameters, AcHost acHost, Option<String> userId) throws JwtIssuerLacksSharedSecretException, JwtUnknownIssuerException {
                Preconditions.checkArgument((null != parameters ? 1 : 0) != 0, (Object)"Parameters Map argument cannot be null");
                Preconditions.checkNotNull((Object)acHost);
                Map paramsAsArrays = Maps.transformValues(parameters, (Function)new Function<List<String>, String[]>(){

                    public String[] apply(List<String> input) {
                        return ((List)Preconditions.checkNotNull(input)).toArray(new String[input.size()]);
                    }
                });
                return Option.some((Object)("JWT " + this.encodeJwt(httpMethod, url, paramsAsArrays, (String)userId.getOrNull(), acHost)));
            }

            private String encodeJwt(HttpMethod httpMethod, URI targetPath, Map<String, String[]> params, String userKeyValue, AcHost acHost) throws JwtUnknownIssuerException, JwtIssuerLacksSharedSecretException {
                Preconditions.checkArgument((null != httpMethod ? 1 : 0) != 0, (Object)"HttpMethod argument cannot be null");
                Preconditions.checkArgument((null != targetPath ? 1 : 0) != 0, (Object)"URI argument cannot be null");
                JwtJsonBuilder jsonBuilder = new JsonSmartJwtJsonBuilder().issuedAt(TimeUtil.currentTimeSeconds()).expirationTime(TimeUtil.currentTimePlusNSeconds((long)jwtExpiryWindowSeconds)).issuer(((JwtGeneratorImpl)JwtGeneratorImpl.this).zConfig.host.getKey());
                if (null != userKeyValue) {
                    jsonBuilder = jsonBuilder.subject(userKeyValue);
                }
                Map<String, String[]> completeParams = params;
                try {
                    if (!StringUtils.isEmpty((CharSequence)targetPath.getQuery())) {
                        completeParams = new HashMap<String, String[]>(params);
                        completeParams.putAll(this.constructParameterMap(targetPath));
                    }
                    CanonicalHttpUriRequest canonicalHttpUriRequest = new CanonicalHttpUriRequest(httpMethod.toString(), targetPath.getPath(), "", completeParams);
                    JwtClaimsBuilder.appendHttpRequestClaims((JwtJsonBuilder)jsonBuilder, (CanonicalHttpRequest)canonicalHttpUriRequest);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                String build = jsonBuilder.build();
                return this.issueJwt(build, JwtGeneratorImpl.this.zConfig);
            }

            private String issueJwt(String jsonPayload, ZConfig config) throws JwtSigningException, JwtIssuerLacksSharedSecretException, JwtUnknownIssuerException {
                return this.getJwtWriter(config).jsonToJwt(jsonPayload);
            }

            private JwtWriter getJwtWriter(ZConfig config) throws JwtUnknownIssuerException, JwtIssuerLacksSharedSecretException {
                return this.val$jwtWriterFactory.macSigningWriter(SigningAlgorithm.HS256, config.JIRA_SHARED_SECRET);
            }

            private Map<String, String[]> constructParameterMap(URI uri) throws UnsupportedEncodingException {
                String query = uri.getQuery();
                if (query == null) {
                    return Collections.emptyMap();
                }
                HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
                CharArrayBuffer buffer = new CharArrayBuffer(query.length());
                buffer.append(query);
                ParserCursor cursor = new ParserCursor(0, buffer.length());
                while (!cursor.atEnd()) {
                    NameValuePair nameValuePair = BasicHeaderValueParser.DEFAULT.parseNameValuePair(buffer, cursor, this.val$QUERY_DELIMITERS);
                    if (StringUtils.isEmpty((CharSequence)nameValuePair.getName())) continue;
                    String decodedName = this.urlDecode(nameValuePair.getName());
                    String decodedValue = this.urlDecode(nameValuePair.getValue());
                    String[] oldValues = (String[])queryParams.get(decodedName);
                    String[] newValues = null == oldValues ? new String[1] : Arrays.copyOf(oldValues, oldValues.length + 1);
                    newValues[newValues.length - 1] = decodedValue;
                    queryParams.put(decodedName, newValues);
                }
                return queryParams;
            }

            private String urlDecode(String content) throws UnsupportedEncodingException {
                return null == content ? null : URLDecoder.decode(content, "UTF-8");
            }
        };
        Option<String> jwt = null;
        try {
            URI uriWithoutProductContext = this.getUri(uri, this.zConfig.ZEPHYR_BASE_URL);
            jwt = jwtAuthorisationGenerator.generate(HttpMethod.valueOf((String)requestMethod), uriWithoutProductContext, new HashMap<String, List<String>>(), this.zConfig.host, this.zConfig.USER_NAME);
        }
        catch (Exception uriWithoutProductContext) {
            // empty catch block
        }
        String authorizationHeaderValue = (String)jwt.getOrNull();
        return authorizationHeaderValue;
    }

    private URI getUri(URI uri, String baseUrlString) throws URISyntaxException {
        String path = uri.getPath();
        URI baseUrl = new URI(baseUrlString);
        String productContext = baseUrl.getPath();
        String pathWithoutProductContext = path.substring(productContext.length());
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), pathWithoutProductContext, uri.getQuery(), uri.getFragment());
    }
}

