/*
 * Decompiled with CFR 0.152.
 */
package com.thed.zephyr.cloud.rest.client;

import com.atlassian.connect.play.java.AC;
import com.atlassian.connect.play.java.AcHost;
import com.atlassian.connect.play.java.http.HttpMethod;
import com.atlassian.fugue.Option;
import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.core.TimeUtil;
import com.atlassian.jwt.core.writer.JsonSmartJwtJsonBuilder;
import com.atlassian.jwt.core.writer.JwtClaimsBuilder;
import com.atlassian.jwt.exception.JwtIssuerLacksSharedSecretException;
import com.atlassian.jwt.exception.JwtSigningException;
import com.atlassian.jwt.exception.JwtUnknownIssuerException;
import com.atlassian.jwt.httpclient.CanonicalHttpUriRequest;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import com.atlassian.jwt.writer.JwtWriter;
import com.atlassian.jwt.writer.JwtWriterFactory;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;

public class JwtAuthorizationGenerator {
    private static final char[] QUERY_DELIMITERS = new char[]{'&'};
    private static final int JWT_EXPIRY_WINDOW_SECONDS_DEFAULT = 180;
    private final int jwtExpiryWindowSeconds;
    private final JwtWriterFactory jwtWriterFactory;

    public JwtAuthorizationGenerator(JwtWriterFactory jwtWriterFactory) {
        this(jwtWriterFactory, 180);
    }

    public JwtAuthorizationGenerator(JwtWriterFactory jwtWriterFactory, int jwtExpiryWindowSeconds) {
        this.jwtWriterFactory = (JwtWriterFactory)Preconditions.checkNotNull((Object)jwtWriterFactory);
        this.jwtExpiryWindowSeconds = jwtExpiryWindowSeconds;
    }

    public Option<String> generate(String httpMethodStr, String url, Map<String, List<String>> parameters, AcHost acHost, Option<String> userId) throws JwtIssuerLacksSharedSecretException, JwtUnknownIssuerException, URISyntaxException {
        HttpMethod method = HttpMethod.valueOf((String)httpMethodStr);
        URI uri = new URI(url);
        String path = uri.getPath();
        URI baseUrl = new URI(acHost.getBaseUrl());
        String productContext = baseUrl.getPath();
        String pathWithoutProductContext = path.substring(productContext.length());
        URI uriWithoutProductContext = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), pathWithoutProductContext, uri.getQuery(), uri.getFragment());
        return this.generate(method, uriWithoutProductContext, parameters, acHost, userId);
    }

    public Option<String> generate(HttpMethod httpMethod, URI url, Map<String, List<String>> parameters, AcHost acHost, Option<String> userId) throws JwtIssuerLacksSharedSecretException, JwtUnknownIssuerException {
        Preconditions.checkArgument((null != parameters ? 1 : 0) != 0, (Object)"Parameters Map argument cannot be null");
        Preconditions.checkNotNull((Object)acHost);
        Map paramsAsArrays = Maps.transformValues(parameters, (Function)new Function<List<String>, String[]>(){

            public String[] apply(List<String> input) {
                return ((List)Preconditions.checkNotNull(input)).toArray(new String[input.size()]);
            }
        });
        return Option.some((Object)("JWT " + this.encodeJwt(httpMethod, url, paramsAsArrays, (String)userId.getOrNull(), acHost)));
    }

    private String encodeJwt(HttpMethod httpMethod, URI targetPath, Map<String, String[]> params, String userKeyValue, AcHost acHost) throws JwtUnknownIssuerException, JwtIssuerLacksSharedSecretException {
        Preconditions.checkArgument((null != httpMethod ? 1 : 0) != 0, (Object)"HttpMethod argument cannot be null");
        Preconditions.checkArgument((null != targetPath ? 1 : 0) != 0, (Object)"URI argument cannot be null");
        JwtJsonBuilder jsonBuilder = new JsonSmartJwtJsonBuilder().issuedAt(TimeUtil.currentTimeSeconds()).expirationTime(TimeUtil.currentTimePlusNSeconds((long)this.jwtExpiryWindowSeconds)).issuer(AC.PLUGIN_KEY).audience(acHost.getKey());
        if (null != userKeyValue) {
            jsonBuilder = jsonBuilder.subject(userKeyValue);
        }
        Map<String, String[]> completeParams = params;
        try {
            if (!StringUtils.isEmpty((CharSequence)targetPath.getQuery())) {
                completeParams = new HashMap<String, String[]>(params);
                completeParams.putAll(JwtAuthorizationGenerator.constructParameterMap(targetPath));
            }
            CanonicalHttpUriRequest e = new CanonicalHttpUriRequest(httpMethod.toString(), targetPath.getPath(), "", completeParams);
            JwtClaimsBuilder.appendHttpRequestClaims((JwtJsonBuilder)jsonBuilder, (CanonicalHttpRequest)e);
        }
        catch (UnsupportedEncodingException var9) {
            throw new RuntimeException(var9);
        }
        catch (NoSuchAlgorithmException var10) {
            throw new RuntimeException(var10);
        }
        return this.issueJwt(jsonBuilder.build(), acHost);
    }

    private String issueJwt(String jsonPayload, AcHost acHost) throws JwtSigningException, JwtIssuerLacksSharedSecretException, JwtUnknownIssuerException {
        return this.getJwtWriter(acHost).jsonToJwt(jsonPayload);
    }

    private JwtWriter getJwtWriter(AcHost acHost) throws JwtUnknownIssuerException, JwtIssuerLacksSharedSecretException {
        return this.jwtWriterFactory.macSigningWriter(SigningAlgorithm.HS256, acHost.getSharedSecret());
    }

    private static Map<String, String[]> constructParameterMap(URI uri) throws UnsupportedEncodingException {
        String query = uri.getQuery();
        if (query == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        CharArrayBuffer buffer = new CharArrayBuffer(query.length());
        buffer.append(query);
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        while (!cursor.atEnd()) {
            NameValuePair nameValuePair = BasicHeaderValueParser.DEFAULT.parseNameValuePair(buffer, cursor, QUERY_DELIMITERS);
            if (StringUtils.isEmpty((CharSequence)nameValuePair.getName())) continue;
            String decodedName = JwtAuthorizationGenerator.urlDecode(nameValuePair.getName());
            String decodedValue = JwtAuthorizationGenerator.urlDecode(nameValuePair.getValue());
            String[] oldValues = queryParams.get(decodedName);
            String[] newValues = null == oldValues ? new String[1] : Arrays.copyOf(oldValues, oldValues.length + 1);
            newValues[newValues.length - 1] = decodedValue;
            queryParams.put(decodedName, newValues);
        }
        return queryParams;
    }

    private static String urlDecode(String content) throws UnsupportedEncodingException {
        return null == content ? null : URLDecoder.decode(content, "UTF-8");
    }
}

