/*
 * Decompiled with CFR 0.152.
 */
package com.thed.zephyr.cloud.rest;

import com.thed.zephyr.cloud.rest.client.JwtGenerator;
import com.thed.zephyr.cloud.rest.client.impl.JwtGeneratorImpl;
import com.thed.zephyr.cloud.rest.model.ZConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZFJCloudRestClient {
    private JwtGenerator jwtGenerator;
    private Logger log = LoggerFactory.getLogger(ZFJCloudRestClient.class);

    private ZFJCloudRestClient() {
    }

    public static Builder restBuilder(String zephyrBaseUrl, String accessKey, String secretKey, String userName) {
        ZFJCloudRestClient zFJCloudRestClient = new ZFJCloudRestClient();
        zFJCloudRestClient.getClass();
        return zFJCloudRestClient.new Builder(zephyrBaseUrl, accessKey, secretKey, userName);
    }

    public JwtGenerator getJwtGenerator() {
        return this.jwtGenerator;
    }

    public class Builder {
        private String accessKey;
        private String secretKey;
        private String userName;
        private String zephyrBaseUrl;

        private Builder(String zephyrBaseUrl, String accessKey, String secretKey, String userName) {
            this.zephyrBaseUrl = zephyrBaseUrl;
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.userName = userName;
        }

        public ZFJCloudRestClient build() {
            ZConfig zConfig = new ZConfig(this.accessKey, this.secretKey, this.userName, this.zephyrBaseUrl);
            ZFJCloudRestClient.this.jwtGenerator = new JwtGeneratorImpl(zConfig);
            return ZFJCloudRestClient.this;
        }
    }
}

