/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit;

import hudson.DescriptorExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Items;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.dtkit.descriptor.TestTypeDescriptor;
import org.jenkinsci.lib.dtkit.type.TestType;
import org.jenkinsci.plugins.xunit.XUnitPublisher;

public class AliasInitializer {
    @Initializer(before=InitMilestone.JOB_LOADED)
    public static void init(Jenkins jenkins) {
        Items.XSTREAM.alias("xunit", XUnitPublisher.class);
        DescriptorExtensionList extensionList = jenkins.getDescriptorList(TestType.class);
        for (TestTypeDescriptor testTypeTestTypeDescriptor : extensionList) {
            Class classType = testTypeTestTypeDescriptor.clazz;
            String className = AliasInitializer.getClassName(classType);
            Items.XSTREAM.alias(className, classType);
        }
        Items.XSTREAM.processAnnotations(XUnitPublisher.class);
    }

    private static String getClassName(Class<? extends TestType> classType) {
        String packageSep;
        String name = classType.getName();
        if (name.contains(packageSep = ".")) {
            return name.substring(name.lastIndexOf(packageSep) + 1);
        }
        return name;
    }
}

