/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.service;

import com.google.inject.Inject;
import hudson.Util;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.plugins.xunit.service.NoNewTestReportException;
import org.jenkinsci.plugins.xunit.service.NoTestFoundException;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.service.XUnitToolInfo;

public class XUnitReportProcessorService
implements Serializable {
    private static final long serialVersionUID = 2640258179567685368L;
    private XUnitLog xUnitLog;

    @Inject
    public XUnitReportProcessorService(XUnitLog xUnitLog) {
        this.xUnitLog = xUnitLog;
    }

    public boolean isEmptyPattern(String pattern) {
        return Util.fixEmptyAndTrim((String)pattern) == null;
    }

    public List<String> findReports(XUnitToolInfo xUnitToolInfo, File parentPath, String pattern) throws NoTestFoundException {
        String toolName = xUnitToolInfo.getInputMetric().getLabel();
        FileSet fs = Util.createFileSet((File)parentPath, (String)pattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] xunitFiles = ds.getIncludedFiles();
        if (xunitFiles.length == 0) {
            String msg = "[" + toolName + "] - No test report file(s) were found with the pattern '" + pattern + "' relative to '" + parentPath + "' for the testing framework '" + toolName + "'.  Did you enter a pattern relative to (and within) the workspace directory?  Did you generate the result report(s) for '" + toolName + "'?";
            throw new NoTestFoundException(msg);
        }
        String msg = "[" + toolName + "] - " + xunitFiles.length + " test report file(s) were found with the pattern '" + pattern + "' relative to '" + parentPath + "' for the testing framework '" + toolName + "'.";
        this.xUnitLog.info(msg);
        return Arrays.asList(xunitFiles);
    }

    public void checkIfFindsFilesNewFiles(XUnitToolInfo xUnitToolInfo, List<String> files, File workspace) throws NoNewTestReportException {
        if (xUnitToolInfo.isFailIfNotNew()) {
            ArrayList<File> oldResults = new ArrayList<File>();
            for (String value : files) {
                File reportFile = new File(workspace, value);
                if (xUnitToolInfo.getBuildTime() - xUnitToolInfo.getTestTimeMargin() <= reportFile.lastModified()) continue;
                oldResults.add(reportFile);
            }
            if (!oldResults.isEmpty()) {
                long localTime = System.currentTimeMillis();
                if (localTime < xUnitToolInfo.getBuildTime() - 1000L) {
                    String msg = "Clock on this slave is out of sync with the master, and therefore \nI can't figure out what test results are new and what are old.\nPlease keep the slave clock in sync with the master.";
                    throw new NoNewTestReportException(msg);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.format("Test reports were found but not all of them are new. Did all the tests run?%n", new Object[0]));
                for (File f : oldResults) {
                    stringBuilder.append(String.format("  * %s is %s old%n", f, Util.getTimeSpanString((long)(xUnitToolInfo.getBuildTime() - f.lastModified()))));
                }
                String msg = stringBuilder.toString();
                throw new NoNewTestReportException(msg);
            }
        }
    }

    public File getCurrentReport(File root, String name) {
        return new File(root, name);
    }

    public boolean isStopProcessingIfError(XUnitToolInfo xUnitToolInfo) {
        return xUnitToolInfo.isStopProcessingIfError();
    }
}

