/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.threshold;

import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.TestResultAction;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.kohsuke.stapler.DataBoundConstructor;

public class FailedThreshold
extends XUnitThreshold {
    @DataBoundConstructor
    public FailedThreshold() {
    }

    @Override
    public Result getResultThresholdNumber(XUnitLog log, Run<?, ?> build, TestResultAction testResultAction, TestResultAction previousTestResultAction) {
        int failedCount = testResultAction.getFailCount();
        int previousFailedCount = 0;
        if (previousTestResultAction != null) {
            previousFailedCount = previousTestResultAction.getFailCount();
        }
        int newFailedCount = failedCount - previousFailedCount;
        return this.getResultThresholdNumber(log, failedCount, newFailedCount);
    }

    @Override
    public Result getResultThresholdPercent(XUnitLog log, Run<?, ?> build, TestResultAction testResultAction, TestResultAction previousTestResultAction) {
        double count = testResultAction.getTotalCount();
        double failedCount = testResultAction.getFailCount();
        double percentFailed = failedCount / count * 100.0;
        double previousFailedCount = 0.0;
        if (previousTestResultAction != null) {
            previousFailedCount = previousTestResultAction.getFailCount();
        }
        double newFailedCount = failedCount - previousFailedCount;
        double percentNewFailed = newFailedCount / count * 100.0;
        return this.getResultThresholdPercent(log, percentFailed, percentNewFailed);
    }
}

