/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.service;

import com.google.inject.Inject;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.jenkinsci.lib.dtkit.util.validator.ValidationError;
import org.jenkinsci.plugins.xunit.NoFoundTestException;
import org.jenkinsci.plugins.xunit.OldTestReportException;
import org.jenkinsci.plugins.xunit.SkipTestException;
import org.jenkinsci.plugins.xunit.service.XUnitConversionService;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.service.XUnitReportProcessorService;
import org.jenkinsci.plugins.xunit.service.XUnitService;
import org.jenkinsci.plugins.xunit.service.XUnitToolInfo;
import org.jenkinsci.plugins.xunit.service.XUnitValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitTransformer
extends XUnitService
implements FilePath.FileCallable<Boolean>,
Serializable {
    private XUnitReportProcessorService xUnitReportProcessorService;
    private XUnitConversionService xUnitConversionService;
    private XUnitValidationService xUnitValidationService;
    private XUnitToolInfo xUnitToolInfo;
    private XUnitLog xUnitLog;

    @Inject
    void load(XUnitReportProcessorService xUnitReportProcessorService, XUnitConversionService xUnitConversionService, XUnitValidationService xUnitValidationService, XUnitToolInfo xUnitToolInfo, XUnitLog xUnitLog) {
        this.xUnitReportProcessorService = xUnitReportProcessorService;
        this.xUnitValidationService = xUnitValidationService;
        this.xUnitConversionService = xUnitConversionService;
        this.xUnitToolInfo = xUnitToolInfo;
        this.xUnitLog = xUnitLog;
    }

    public Boolean invoke(File ws, VirtualChannel channel) throws IOException, InterruptedException {
        try {
            File junitOutputDir = new File(ws, "generatedJUnitFiles");
            if (!junitOutputDir.exists() && !junitOutputDir.mkdirs()) {
                String msg = "Can't create the path " + junitOutputDir + ". Maybe the directory already exists.";
                this.xUnitLog.warningConsoleLogger(msg);
                this.warningSystemLogger(msg);
            }
            String metricName = this.xUnitToolInfo.getInputMetric().getToolName();
            List<String> resultFiles = this.xUnitReportProcessorService.findReports(this.xUnitToolInfo, ws, this.xUnitToolInfo.getExpandedPattern());
            int nbTestFiles = resultFiles.size();
            if (nbTestFiles == 0 && this.xUnitToolInfo.isSkipNoTestFiles()) {
                String msg = "No test reports found for the metric '" + metricName + "' with the resolved pattern '" + this.xUnitToolInfo.getExpandedPattern() + "'.";
                this.xUnitLog.warningConsoleLogger(msg);
                throw new SkipTestException();
            }
            if (nbTestFiles == 0) {
                String msg = "No test reports found for the metric '" + metricName + "' with the resolved pattern '" + this.xUnitToolInfo.getExpandedPattern() + "'. Configuration error?.";
                this.xUnitLog.errorConsoleLogger(msg);
                this.errorSystemLogger(msg);
                throw new NoFoundTestException();
            }
            this.xUnitReportProcessorService.checkIfFindsFilesNewFiles(this.xUnitToolInfo, resultFiles, ws);
            boolean atLeastOneWarningOrError = false;
            for (String curFileName : resultFiles) {
                String msg;
                File curFile = this.xUnitReportProcessorService.getCurrentReport(ws, curFileName);
                boolean isStopProcessingIfError = this.xUnitReportProcessorService.isStopProcessingIfError(this.xUnitToolInfo);
                if (!this.xUnitValidationService.checkFileIsNotEmpty(curFile)) {
                    msg = "The result file '" + curFile.getPath() + "' for the metric '" + metricName + "' is empty. The result file has been skipped.";
                    if (isStopProcessingIfError) {
                        this.xUnitLog.errorConsoleLogger(msg);
                        this.errorSystemLogger(msg);
                        return false;
                    }
                    atLeastOneWarningOrError = true;
                    this.errorSystemLogger(msg);
                    continue;
                }
                if (!this.xUnitValidationService.validateInputFile(this.xUnitToolInfo, curFile)) {
                    msg = "The result file '" + curFile + "' for the metric '" + metricName + "' is not valid. The result file has been skipped.";
                    if (isStopProcessingIfError) {
                        this.xUnitLog.errorConsoleLogger(msg);
                        this.errorSystemLogger(msg);
                        return false;
                    }
                    atLeastOneWarningOrError = true;
                    this.errorSystemLogger(msg);
                    continue;
                }
                File junitTargetFile = this.xUnitConversionService.convert(this.xUnitToolInfo, curFile, ws, junitOutputDir);
                if (this.xUnitValidationService.validateOutputFile(this.xUnitToolInfo, curFile, junitTargetFile)) continue;
                String msg2 = "The converted file for the result file '" + curFile + "' (during conversion process for the metric '" + metricName + "') is not valid. The report file has been skipped.";
                this.xUnitLog.errorConsoleLogger(msg2);
                this.errorSystemLogger(msg2);
                for (ValidationError validatorError : this.xUnitToolInfo.getInputMetric().getOutputValidationErrors()) {
                    this.xUnitLog.errorConsoleLogger(validatorError.getMessage());
                }
                if (isStopProcessingIfError) {
                    return false;
                }
                atLeastOneWarningOrError = true;
                this.errorSystemLogger(msg2);
            }
            if (atLeastOneWarningOrError) {
                String msg = "There is at least one problem. Check the Jenkins system log for more information. (if you don't have configured yet the system log before, you have to rebuild).";
                this.xUnitLog.errorConsoleLogger(msg);
                return false;
            }
        }
        catch (SkipTestException se) {
            throw new SkipTestException();
        }
        catch (NoFoundTestException se) {
            throw new NoFoundTestException();
        }
        catch (OldTestReportException oe) {
            throw new OldTestReportException();
        }
        catch (Exception xe) {
            String msg = xe.getMessage();
            if (msg != null) {
                this.xUnitLog.errorConsoleLogger(msg);
            }
            xe.printStackTrace();
            throw new IOException2("There are some problems during the conversion into JUnit reports: ", (Throwable)xe);
        }
        return true;
    }
}

