/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.test.TestResultProjectAction;
import java.io.IOException;
import java.io.Serializable;
import org.jenkinsci.lib.dryrun.DryRun;
import org.jenkinsci.lib.dtkit.descriptor.TestTypeDescriptor;
import org.jenkinsci.lib.dtkit.type.TestType;
import org.jenkinsci.plugins.xunit.ExtraConfiguration;
import org.jenkinsci.plugins.xunit.Messages;
import org.jenkinsci.plugins.xunit.XUnitProcessor;
import org.jenkinsci.plugins.xunit.threshold.FailedThreshold;
import org.jenkinsci.plugins.xunit.threshold.SkippedThreshold;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.jenkinsci.plugins.xunit.threshold.XUnitThresholdDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitPublisher
extends Recorder
implements DryRun,
Serializable {
    private TestType[] types;
    private XUnitThreshold[] thresholds;
    private int thresholdMode;
    private ExtraConfiguration extraConfiguration;

    public XUnitPublisher(TestType[] types, XUnitThreshold[] thresholds) {
        this.types = types;
        this.thresholds = thresholds;
        this.thresholdMode = 1;
    }

    @DataBoundConstructor
    public XUnitPublisher(TestType[] tools, XUnitThreshold[] thresholds, int thresholdMode, String testTimeMargin) {
        this.types = tools;
        this.thresholds = thresholds;
        this.thresholdMode = thresholdMode;
        long longTestTimeMargin = 3000L;
        if (testTimeMargin != null && testTimeMargin.trim().length() != 0) {
            longTestTimeMargin = Long.parseLong(testTimeMargin);
        }
        this.extraConfiguration = new ExtraConfiguration(longTestTimeMargin);
    }

    public TestType[] getTypes() {
        return this.types;
    }

    public XUnitThreshold[] getThresholds() {
        return this.thresholds;
    }

    public int getThresholdMode() {
        return this.thresholdMode;
    }

    public ExtraConfiguration getExtraConfiguration() {
        if (this.extraConfiguration == null) {
            this.extraConfiguration = new ExtraConfiguration(3000L);
        }
        return this.extraConfiguration;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        JUnitResultArchiver jUnitResultArchiver = (JUnitResultArchiver)project.getPublishersList().get(JUnitResultArchiver.class);
        if (jUnitResultArchiver == null) {
            return new TestResultProjectAction(project);
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        XUnitProcessor xUnitProcessor = new XUnitProcessor(this.getTypes(), this.getThresholds(), this.getThresholdMode(), this.getExtraConfiguration());
        return xUnitProcessor.performXUnit(false, build, listener);
    }

    public boolean performDryRun(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        try {
            XUnitProcessor xUnitProcessor = new XUnitProcessor(this.getTypes(), this.getThresholds(), this.getThresholdMode(), this.getExtraConfiguration());
            xUnitProcessor.performXUnit(true, build, listener);
        }
        catch (Throwable t) {
            listener.getLogger().println("[ERROR] - There is an error: " + t.getCause().getMessage());
        }
        build.setResult(Result.SUCCESS);
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class XUnitDescriptorPublisher
    extends BuildStepDescriptor<Publisher> {
        public XUnitDescriptorPublisher() {
            super(XUnitPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.xUnit_PublisherName();
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/xunit/help.html";
        }

        public DescriptorExtensionList<TestType, TestTypeDescriptor<?>> getListXUnitTypeDescriptors() {
            return TestTypeDescriptor.all();
        }

        public DescriptorExtensionList<XUnitThreshold, XUnitThresholdDescriptor<?>> getListXUnitThresholdDescriptors() {
            return XUnitThresholdDescriptor.all();
        }

        public XUnitThreshold[] getListXUnitThresholdInstance() {
            return new XUnitThreshold[]{new FailedThreshold(), new SkippedThreshold()};
        }
    }
}

