/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit.service;

import com.google.inject.Inject;
import com.thalesgroup.dtkit.metrics.model.InputMetric;
import com.thalesgroup.dtkit.util.converter.ConversionException;
import com.thalesgroup.hudson.plugins.xunit.exception.XUnitException;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitLog;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitService;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitToolInfo;
import com.thalesgroup.hudson.plugins.xunit.types.CustomInputMetric;
import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class XUnitConversionService
extends XUnitService
implements Serializable {
    private XUnitLog xUnitLog;

    @Inject
    void load(XUnitLog xUnitLog) {
        this.xUnitLog = xUnitLog;
    }

    public File convert(XUnitToolInfo xUnitToolInfo, File inputFile, File workspace, File junitOutputDirectory) throws XUnitException {
        InputMetric inputMetric = xUnitToolInfo.getInputMetric();
        String JUNIT_FILE_POSTFIX = ".xml";
        String JUNIT_FILE_PREFIX = "TEST-";
        File parent = new File(junitOutputDirectory, inputMetric.getToolName());
        parent.mkdirs();
        if (!parent.exists()) {
            throw new XUnitException("Can't create " + parent);
        }
        File junitTargetFile = new File(parent, "TEST-" + inputFile.hashCode() + ".xml");
        this.infoSystemLogger("Converting '" + inputFile + "' .");
        try {
            if (inputMetric instanceof CustomInputMetric) {
                CustomInputMetric customInputMetric = (CustomInputMetric)inputMetric;
                FilePath xslFilePath = xUnitToolInfo.getCusXSLFile();
                if (!xslFilePath.exists()) {
                    throw new XUnitException("The input xsl '" + xslFilePath.getName() + "' relative to the workspace '" + workspace + "'doesn't exist.");
                }
                customInputMetric.setCustomXSLFile(new File(xUnitToolInfo.getCusXSLFile().getRemote()));
            }
            inputMetric.convert(inputFile, junitTargetFile);
        }
        catch (ConversionException ce) {
            throw new XUnitException("Conversion error " + ce.getMessage(), ce);
        }
        catch (InterruptedException ie) {
            throw new XUnitException("Conversion error " + ie.getMessage(), ie);
        }
        catch (IOException ie) {
            throw new XUnitException("Conversion error " + ie.getMessage(), ie);
        }
        return junitTargetFile;
    }
}

