/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.threshold;

import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.TestResultAction;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.kohsuke.stapler.DataBoundConstructor;

public class SkippedThreshold
extends XUnitThreshold {
    public SkippedThreshold() {
    }

    @DataBoundConstructor
    public SkippedThreshold(String unstableThreshold, String unstableNewThreshold, String failureThreshold, String failureNewThreshold) {
        super(unstableThreshold, unstableNewThreshold, failureThreshold, failureNewThreshold);
    }

    @Override
    public Result getResultThresholdNumber(XUnitLog log, Run<?, ?> build, TestResultAction testResultAction, TestResultAction previousTestResultAction) {
        int skipCount = testResultAction.getSkipCount();
        int previousSkipCount = 0;
        if (previousTestResultAction != null) {
            previousSkipCount = previousTestResultAction.getSkipCount();
        }
        int newSkipCount = skipCount - previousSkipCount;
        return this.getResultThresholdNumber(log, skipCount, newSkipCount);
    }

    @Override
    public Result getResultThresholdPercent(XUnitLog log, Run<?, ?> build, TestResultAction testResultAction, TestResultAction previousTestResultAction) {
        int count = testResultAction.getTotalCount();
        int skippedCount = testResultAction.getSkipCount();
        int percentSkipped = count == 0 ? 0 : skippedCount / count * 100;
        int previousSkippedCount = 0;
        if (previousTestResultAction != null) {
            previousSkippedCount = previousTestResultAction.getSkipCount();
        }
        int newSkippedCount = skippedCount - previousSkippedCount;
        int percentNewSkipped = count == 0 ? 0 : newSkippedCount * 100 / count;
        return this.getResultThresholdPercent(log, percentSkipped, percentNewSkipped);
    }
}

