/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Singleton;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import jenkins.SlaveToMasterFileCallable;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.lib.dtkit.model.InputMetric;
import org.jenkinsci.lib.dtkit.type.TestType;
import org.jenkinsci.plugins.xunit.ExtraConfiguration;
import org.jenkinsci.plugins.xunit.NoFoundTestException;
import org.jenkinsci.plugins.xunit.OldTestReportException;
import org.jenkinsci.plugins.xunit.SkipTestException;
import org.jenkinsci.plugins.xunit.exception.XUnitException;
import org.jenkinsci.plugins.xunit.service.XUnitConversionService;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.service.XUnitReportProcessorService;
import org.jenkinsci.plugins.xunit.service.XUnitToolInfo;
import org.jenkinsci.plugins.xunit.service.XUnitTransformer;
import org.jenkinsci.plugins.xunit.service.XUnitValidationService;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.jenkinsci.plugins.xunit.types.CustomType;

public class XUnitProcessor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TestType[] types;
    private XUnitThreshold[] thresholds;
    private int thresholdMode;
    private ExtraConfiguration extraConfiguration;

    public XUnitProcessor(TestType[] types, XUnitThreshold[] thresholds, int thresholdMode, ExtraConfiguration extraConfiguration) {
        this.types = types;
        if (types == null) {
            throw new NullPointerException("The types section is required.");
        }
        this.thresholds = thresholds;
        this.thresholdMode = thresholdMode;
        this.extraConfiguration = extraConfiguration;
    }

    public boolean performXunit(boolean dryRun, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        return this.performXUnit(dryRun, (Run<?, ?>)build, build.getWorkspace(), (TaskListener)listener);
    }

    public boolean performXUnit(boolean dryRun, Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        XUnitLog xUnitLog = this.getXUnitLogObject(listener);
        try {
            boolean continueTestProcessing;
            xUnitLog.infoConsoleLogger("Starting to record.");
            try {
                continueTestProcessing = this.performTests(xUnitLog, build, workspace, listener);
            }
            catch (StopTestProcessingException e) {
                build.setResult(Result.FAILURE);
                xUnitLog.infoConsoleLogger("There are errors when processing test results.");
                xUnitLog.infoConsoleLogger("Skipping tests recording.");
                xUnitLog.infoConsoleLogger("Stop build.");
                return true;
            }
            if (!continueTestProcessing) {
                xUnitLog.infoConsoleLogger("There are errors when processing test results.");
                xUnitLog.infoConsoleLogger("Skipping tests recording.");
                return true;
            }
            this.recordTestResult(build, workspace, listener, xUnitLog);
            this.processDeletion(dryRun, workspace, xUnitLog);
            Result result = this.getBuildStatus(build, xUnitLog);
            if (result != null) {
                if (!dryRun) {
                    xUnitLog.infoConsoleLogger("Setting the build status to " + result);
                    build.setResult(result);
                } else {
                    xUnitLog.infoConsoleLogger("Through the xUnit plugin, the build status will be set to " + result.toString());
                }
            }
            xUnitLog.infoConsoleLogger("Stopping recording.");
            return true;
        }
        catch (XUnitException xe) {
            xUnitLog.errorConsoleLogger("The plugin hasn't been performed correctly: " + xe.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    private XUnitLog getXUnitLogObject(final TaskListener listener) {
        return (XUnitLog)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(TaskListener.class).toInstance((Object)listener);
            }
        }}).getInstance(XUnitLog.class);
    }

    private boolean performTests(XUnitLog xUnitLog, Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException, StopTestProcessingException {
        XUnitReportProcessorService xUnitReportService = this.getXUnitReportProcessorServiceObject(listener);
        boolean findTest = false;
        for (TestType tool : this.types) {
            xUnitLog.infoConsoleLogger("Processing " + tool.getDescriptor().getDisplayName());
            if (this.isEmptyGivenPattern(xUnitReportService, tool)) continue;
            String expandedPattern = this.getExpandedResolvedPattern(tool, build, listener);
            XUnitToolInfo xUnitToolInfo = this.getXUnitToolInfoObject(tool, expandedPattern, build, workspace, listener);
            XUnitTransformer xUnitTransformer = this.getXUnitTransformerObject(xUnitToolInfo, listener);
            boolean result = false;
            try {
                result = (Boolean)workspace.act((FilePath.FileCallable)xUnitTransformer);
                findTest = true;
            }
            catch (InterruptedException ie) {
                Throwable originalException = null;
                for (Throwable cause = ie.getCause(); cause != null; cause = cause.getCause()) {
                    originalException = cause;
                }
                if (originalException instanceof InterruptedException) {
                    ie = (InterruptedException)originalException;
                }
                if (ie instanceof NoFoundTestException) {
                    xUnitLog.infoConsoleLogger("Failing BUILD.");
                    throw new StopTestProcessingException();
                }
                if (ie instanceof SkipTestException) {
                    xUnitLog.infoConsoleLogger("Skipping the metric tool processing.");
                    continue;
                }
                if (ie instanceof OldTestReportException) {
                    xUnitLog.infoConsoleLogger("Failing BUILD.");
                    throw new StopTestProcessingException();
                }
                xUnitLog.warningConsoleLogger("Caught exception of unexpected type " + ie.getClass() + ", rethrowing");
                throw ie;
            }
            if (result || !xUnitToolInfo.isStopProcessingIfError()) continue;
            xUnitLog.infoConsoleLogger("Failing BUILD because 'set build failed if errors' option is activated.");
            throw new StopTestProcessingException();
        }
        return findTest;
    }

    private XUnitReportProcessorService getXUnitReportProcessorServiceObject(final TaskListener listener) {
        return (XUnitReportProcessorService)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(TaskListener.class).toInstance((Object)listener);
            }
        }}).getInstance(XUnitReportProcessorService.class);
    }

    private boolean isEmptyGivenPattern(XUnitReportProcessorService xUnitReportService, TestType tool) {
        return xUnitReportService.isEmptyPattern(tool.getPattern());
    }

    private String getExpandedResolvedPattern(TestType tool, Run build, TaskListener listener) throws IOException, InterruptedException {
        String newExpandedPattern = tool.getPattern();
        newExpandedPattern = newExpandedPattern.replaceAll("[\t\r\n]+", " ");
        return Util.replaceMacro((String)newExpandedPattern, (Map)build.getEnvironment(listener));
    }

    private XUnitToolInfo getXUnitToolInfoObject(TestType tool, String expandedPattern, Run build, FilePath workspace, final TaskListener listener) throws IOException, InterruptedException {
        InputMetric inputMetric = tool.getInputMetric();
        inputMetric = (InputMetric)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(TaskListener.class).toInstance((Object)listener);
                this.bind(XUnitLog.class).in(Singleton.class);
                this.bind(XUnitValidationService.class).in(Singleton.class);
                this.bind(XUnitConversionService.class).in(Singleton.class);
            }
        }}).getInstance(inputMetric.getClass());
        return new XUnitToolInfo(new FilePath(new File(Hudson.getInstance().getRootDir(), "userContent")), inputMetric, expandedPattern, tool.isSkipNoTestFiles(), tool.isFailIfNotNew(), tool.isDeleteOutputFiles(), tool.isStopProcessingIfError(), build.getTimeInMillis(), this.extraConfiguration.getTestTimeMargin(), tool instanceof CustomType ? this.getCustomStylesheet(tool, build, workspace, listener) : null);
    }

    private FilePath getCustomStylesheet(TestType tool, Run build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        String customXSLPath = Util.replaceMacro((String)((CustomType)tool).getCustomXSL(), (Map)build.getEnvironment(listener));
        FilePath customXSLFilePath = new FilePath(new File(customXSLPath));
        if (!customXSLFilePath.exists()) {
            customXSLFilePath = workspace.child(customXSLPath);
        }
        if (!customXSLFilePath.exists()) {
            throw new XUnitException("The given xsl '" + customXSLPath + "'doesn't exist.");
        }
        return customXSLFilePath;
    }

    private XUnitTransformer getXUnitTransformerObject(final XUnitToolInfo xUnitToolInfo, final TaskListener listener) {
        return (XUnitTransformer)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(TaskListener.class).toInstance((Object)listener);
                this.bind(XUnitToolInfo.class).toInstance((Object)xUnitToolInfo);
                this.bind(XUnitValidationService.class).in(Singleton.class);
                this.bind(XUnitConversionService.class).in(Singleton.class);
                this.bind(XUnitLog.class).in(Singleton.class);
                this.bind(XUnitReportProcessorService.class).in(Singleton.class);
            }
        }}).getInstance(XUnitTransformer.class);
    }

    private TestResultAction getTestResultAction(Run<?, ?> build) {
        return (TestResultAction)build.getAction(TestResultAction.class);
    }

    private TestResultAction getPreviousTestResultAction(Run<?, ?> build) {
        Run previousBuild = build.getPreviousBuild();
        if (previousBuild == null) {
            return null;
        }
        return this.getTestResultAction(previousBuild);
    }

    private void recordTestResult(Run<?, ?> build, FilePath workspace, TaskListener listener, XUnitLog xUnitLog) throws XUnitException {
        TestResult result;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        long buildTime = build.getTimestamp().getTimeInMillis();
        long nowMaster = System.currentTimeMillis();
        TestResult existingTestResults = null;
        if (existingAction != null) {
            existingTestResults = existingAction.getResult();
        }
        if ((result = this.getTestResult(workspace, "**/TEST-*.xml", existingTestResults, buildTime, nowMaster)) != null) {
            TestResultAction action;
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                xUnitLog.warningConsoleLogger("All test reports are empty.");
            }
            if (existingAction == null) {
                build.getActions().add(action);
            }
        }
    }

    private TestResult getTestResult(FilePath workspace, final String junitFilePattern, final TestResult existingTestResults, final long buildTime, final long nowMaster) throws XUnitException {
        try {
            return (TestResult)workspace.act((FilePath.FileCallable)new SlaveToMasterFileCallable<TestResult>(){

                public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
                    long nowSlave = System.currentTimeMillis();
                    File generatedJunitDir = new File(ws, "generatedJUnitFiles");
                    generatedJunitDir.mkdirs();
                    FileSet fs = Util.createFileSet((File)generatedJunitDir, (String)junitFilePattern);
                    DirectoryScanner ds = fs.getDirectoryScanner();
                    String[] files = ds.getIncludedFiles();
                    if (files.length == 0) {
                        return null;
                    }
                    try {
                        if (existingTestResults == null) {
                            return new TestResult(buildTime + (nowSlave - nowMaster), ds, true);
                        }
                        existingTestResults.parse(buildTime + (nowSlave - nowMaster), ds);
                        return existingTestResults;
                    }
                    catch (IOException ioe) {
                        throw new IOException(ioe);
                    }
                }
            });
        }
        catch (IOException ioe) {
            throw new XUnitException(ioe.getMessage(), ioe);
        }
        catch (InterruptedException ie) {
            throw new XUnitException(ie.getMessage(), ie);
        }
    }

    private Result getBuildStatus(Run<?, ?> build, XUnitLog xUnitLog) {
        Result curResult = this.getResultWithThreshold(xUnitLog, build);
        Result previousResultStep = build.getResult();
        if (curResult != null) {
            if (previousResultStep == null) {
                return curResult;
            }
            if (previousResultStep != Result.NOT_BUILT && previousResultStep.isWorseOrEqualTo(curResult)) {
                curResult = previousResultStep;
            }
            return curResult;
        }
        return null;
    }

    private Result getResultWithThreshold(XUnitLog log, Run<?, ?> build) {
        TestResultAction testResultAction = this.getTestResultAction(build);
        TestResultAction previousTestResultAction = this.getPreviousTestResultAction(build);
        if (testResultAction == null) {
            return Result.FAILURE;
        }
        return this.processResultThreshold(log, build, testResultAction, previousTestResultAction);
    }

    private Result processResultThreshold(XUnitLog log, Run<?, ?> build, TestResultAction testResultAction, TestResultAction previousTestResultAction) {
        if (this.thresholds != null) {
            for (XUnitThreshold threshold : this.thresholds) {
                log.infoConsoleLogger(String.format("Check '%s' threshold.", threshold.getDescriptor().getDisplayName()));
                Result result = 2 == this.thresholdMode ? threshold.getResultThresholdPercent(log, build, testResultAction, previousTestResultAction) : threshold.getResultThresholdNumber(log, build, testResultAction, previousTestResultAction);
                if (!result.isWorseThan(Result.SUCCESS)) continue;
                return result;
            }
        }
        return Result.SUCCESS;
    }

    private void processDeletion(boolean dryRun, FilePath workspace, XUnitLog xUnitLog) throws XUnitException {
        try {
            boolean keepJUnitDirectory = false;
            for (TestType tool : this.types) {
                InputMetric inputMetric = tool.getInputMetric();
                if (dryRun || tool.isDeleteOutputFiles()) {
                    workspace.child("generatedJUnitFiles/" + inputMetric.getToolName()).deleteRecursive();
                    continue;
                }
                keepJUnitDirectory = true;
            }
            if (!keepJUnitDirectory) {
                workspace.child("generatedJUnitFiles").deleteRecursive();
            }
        }
        catch (IOException ioe) {
            throw new XUnitException("Problem on deletion", ioe);
        }
        catch (InterruptedException ie) {
            throw new XUnitException("Problem on deletion", ie);
        }
    }

    private static class StopTestProcessingException
    extends Exception {
        private StopTestProcessingException() {
        }
    }
}

