/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.viewer;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.json.JSONObject;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.viewer.XPathConfig;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class XPathConfigViewerPlugin
extends ManagementLink {
    private static final Logger LOG = Logger.getLogger(XPathConfigViewerPlugin.class.getName());
    private ConfigProvider xPathConfigProvider;

    public XPathConfigViewerPlugin() {
        for (ConfigProvider provider : ConfigProvider.all()) {
            if (!provider.getProviderId().equals("XPathConfigProvider.")) continue;
            this.xPathConfigProvider = provider;
            break;
        }
    }

    public String getDescription() {
        return "View configurations across all jobs selected by xpath";
    }

    public String getIconFileName() {
        return "orange-square.gif";
    }

    public String getUrlName() {
        return "xpathviewer";
    }

    public String getDisplayName() {
        return "XPath Configuration Viewer";
    }

    public List<ConfigProvider> getProviders() {
        return ConfigProvider.all();
    }

    public void doAddXPath(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkAdminPermission();
        req.setAttribute("contentType", (Object)this.xPathConfigProvider.getContentType());
        req.setAttribute("provider", (Object)this.xPathConfigProvider);
        XPathConfig config = (XPathConfig)this.xPathConfigProvider.newConfig();
        req.setAttribute("config", (Object)config);
        req.getView((Object)this, "edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public void doEditConfig(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String confgiId) throws IOException, ServletException {
        this.checkAdminPermission();
        Config config = this.xPathConfigProvider.getConfigById(confgiId);
        if (config != null) {
            req.setAttribute("config", (Object)config);
            req.setAttribute("contentType", (Object)this.xPathConfigProvider.getContentType());
            req.setAttribute("provider", (Object)this.xPathConfigProvider);
            req.getView((Object)this, "edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
        } else {
            req.getView((Object)this, "index").forward((ServletRequest)req, (ServletResponse)rsp);
        }
    }

    public HttpResponse doSaveXPath(StaplerRequest req) {
        try {
            JSONObject json = req.getSubmittedForm().getJSONObject("xpathconfig");
            XPathConfig config = (XPathConfig)((Object)req.bindJSON(XPathConfig.class, json));
            this.xPathConfigProvider.save((Config)config);
        }
        catch (ServletException e) {
            LOG.log(Level.SEVERE, "Exception saving xpath config viewer: " + e.getMessage());
        }
        return new HttpRedirect("index");
    }

    public HttpResponse doDelConfig(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="id") String configId) throws IOException {
        this.checkAdminPermission();
        this.xPathConfigProvider.remove(configId);
        return new HttpRedirect("index");
    }

    private void checkAdminPermission() {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
    }
}

