/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.viewer;

import hudson.Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jenkinsci.lib.configprovider.AbstractConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ConfigDescription;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.viewer.ProjectCollector;
import org.jenkinsci.plugins.viewer.XPathConfig;
import org.jenkinsci.plugins.viewer.XPathConfigComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class XPathConfigProvider
extends AbstractConfigProvider {
    public ConfigDescription getConfigDescription() {
        return new ConfigDescription("xpath config selector", "select xml block using an xpath expression.");
    }

    protected String getXmlFileName() {
        return "xpath-config-selectors.xml";
    }

    public ContentType getContentType() {
        return ContentType.DefinedType.XML;
    }

    public Config newConfig() {
        String id = this.getProviderId() + System.currentTimeMillis();
        return new XPathConfig(id, "config.xml block", "", "/project");
    }

    public Collection<Config> getAllConfigs() {
        ProjectCollector.init();
        Collection allConfigs = super.getAllConfigs();
        ArrayList<Config> configsList = new ArrayList<Config>();
        configsList.addAll(allConfigs);
        Collections.sort(configsList, new XPathConfigComparator());
        return configsList;
    }
}

