/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.viewer;

import hudson.model.AbstractProject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.viewer.ProjectCollector;
import org.jenkinsci.plugins.viewer.XmlBlock;
import org.jfree.util.Log;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathConfig
extends Config {
    public static final String NOT_ASSIGNED = "<!-- not assigned -->";
    private static final long serialVersionUID = -6773980474331173914L;
    private String xpath;
    private Pattern jobNameFilterPattern;

    @DataBoundConstructor
    public XPathConfig(String id, String name, String comment, String content) {
        super(id, name, comment, content);
        this.xpath = content;
        this.jobNameFilterPattern = StringUtils.isBlank((String)comment) ? null : Pattern.compile(comment);
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public List<XmlBlock> getDistinctXmlBlocks() {
        if (StringUtils.isBlank((String)this.getXpath()) || ProjectCollector.getProjectsList() == null) {
            return Collections.emptyList();
        }
        ArrayList<XmlBlock> xmlBlocks = new ArrayList<XmlBlock>();
        ArrayList<AbstractProject> notAssignedList = new ArrayList<AbstractProject>();
        notAssignedList.addAll(ProjectCollector.getProjectsList());
        for (AbstractProject project : ProjectCollector.getProjectsList()) {
            Matcher m;
            if (this.jobNameFilterPattern != null && !(m = this.jobNameFilterPattern.matcher(project.getName())).find()) {
                notAssignedList.remove(project);
                continue;
            }
            List<Element> xmlBlockElements = this.getXmlBlock(project.getConfigFile().getFile());
            if (xmlBlockElements == null || xmlBlockElements.size() <= 0) continue;
            if (notAssignedList.contains(project)) {
                notAssignedList.remove(project);
            }
            for (Element xmlBlockElement : xmlBlockElements) {
                XmlBlock xmlBlock;
                String xmlBlockStr = xmlBlockElement.asXML();
                XmlBlock testBlock = new XmlBlock();
                testBlock.setXmlblock(xmlBlockStr);
                if (xmlBlocks.contains(testBlock)) {
                    xmlBlock = (XmlBlock)xmlBlocks.get(xmlBlocks.indexOf(testBlock));
                    xmlBlock.getProjects().add(project);
                    continue;
                }
                xmlBlock = new XmlBlock();
                xmlBlock.setXmlblock(xmlBlockStr);
                ArrayList<AbstractProject> projects = new ArrayList<AbstractProject>();
                projects.add(project);
                xmlBlock.setProjects(projects);
                xmlBlocks.add(xmlBlock);
            }
        }
        if (notAssignedList.size() > 0) {
            XmlBlock notAssignedBlock = new XmlBlock();
            notAssignedBlock.setXmlblock(NOT_ASSIGNED);
            notAssignedBlock.setProjects(notAssignedList);
            xmlBlocks.add(notAssignedBlock);
        }
        return xmlBlocks;
    }

    public List<Element> getXmlBlock(File xmlFile) {
        if (StringUtils.isEmpty((String)this.getXpath())) {
            return null;
        }
        try {
            Document dom = new SAXReader().read(xmlFile);
            List nodes = dom.selectNodes(this.xpath);
            if (nodes.size() > 0) {
                ArrayList<Element> elements = new ArrayList<Element>(nodes.size());
                elements.addAll(nodes);
                return elements;
            }
        }
        catch (Exception e) {
            Log.error((Object)"Exception getting xml block from config.xml: ", (Exception)e);
        }
        return null;
    }

    public String getId() {
        return this.id;
    }
}

