/*
 * Decompiled with CFR 0.152.
 */
package maps.hudson.plugin.xfpanel;

import hudson.Functions;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.claim.ClaimBuildAction;
import hudson.plugins.claim.ClaimTestAction;
import hudson.scm.ChangeLogSet;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AbstractTestResultAction;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import maps.hudson.plugin.xfpanel.XFPanelView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XFPanelEntry
extends XFPanelView {
    private Job<?, ?> job;
    private String backgroundColor;
    private String color;
    private String colorFade = "";
    private Boolean broken;
    private Boolean building = false;
    private String completionTimestampString = "";
    private Calendar completionTimestamp;

    public XFPanelEntry(XFPanelView view, Job<?, ?> job) {
        super(view.getDisplayName(), view.getNumColumns());
        this.job = job;
        this.findStatus();
        this.setTimes();
    }

    public Job<?, ?> getJob() {
        return this.job;
    }

    public String getName() {
        String label = this.job.getDisplayName().toUpperCase();
        if (this.getShowDescription().booleanValue() && !this.job.getDescription().isEmpty()) {
            label = label + ": " + this.job.getDescription();
        }
        return label;
    }

    public Boolean getQueued() {
        return this.job.isInQueue();
    }

    public Integer getQueueNumber() {
        return this.placeInQueue == null ? null : (Integer)this.placeInQueue.get(this.job.getQueueItem());
    }

    public AbstractBuild<?, ?> getLastBuild() {
        Run run = this.job.getLastBuild();
        if (run instanceof AbstractBuild) {
            AbstractBuild lastBuild = (AbstractBuild)run;
            return lastBuild;
        }
        return null;
    }

    private void setTimes() {
        AbstractBuild lastBuild;
        Run run = this.job.getLastCompletedBuild();
        if (run instanceof AbstractBuild && (lastBuild = (AbstractBuild)run) != null) {
            this.completionTimestamp = lastBuild.getTimestamp();
            this.completionTimestampString = lastBuild.getTimestampString();
        }
    }

    public void setCompletionTimestamp(Calendar completionTimestamp) {
        this.completionTimestamp = completionTimestamp;
    }

    public Calendar getCompletionTimestamp() {
        return this.completionTimestamp;
    }

    public void setCompletionTimestampString(String completionTimestampString) {
        this.completionTimestampString = completionTimestampString;
    }

    public String getCompletionTimestampString() {
        return this.completionTimestampString;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getColor() {
        return this.color;
    }

    public String getColorFade() {
        return this.colorFade;
    }

    public Boolean getBroken() {
        return this.broken;
    }

    public Boolean getShowResponsibles() {
        if (this.BlameState == XFPanelView.Blame.NOTATALL) {
            return false;
        }
        return true;
    }

    public Boolean getBuilding() {
        return this.building;
    }

    public String getUrl() {
        return this.job.getUrl() + "lastBuild";
    }

    public List<Run<?, ?>> getBuildsInProgress() {
        ArrayList runs = new ArrayList();
        Run run = this.job.getLastBuild();
        if (run.isBuilding()) {
            runs.add(run);
        }
        for (Run prev = run.getPreviousBuildInProgress(); prev != null; prev = prev.getPreviousBuildInProgress()) {
            runs.add(prev);
        }
        return runs;
    }

    public int getTestCount() {
        Run run = this.job.getLastSuccessfulBuild();
        if (run != null) {
            AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
            return tests != null ? tests.getTotalCount() : 0;
        }
        return 0;
    }

    public int getFailCount() {
        Run run = this.job.getLastSuccessfulBuild();
        if (run != null) {
            AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
            return tests != null ? tests.getFailCount() : 0;
        }
        return 0;
    }

    public int getSuccessCount() {
        return this.getTestCount() - this.getFailCount();
    }

    public int getLastCompletedBuildNumber() {
        return this.job.getLastCompletedBuild().getNumber();
    }

    public String getLastCompletedBuildTimestampString() {
        return this.job.getLastCompletedBuild().getTimestampString();
    }

    public int getNumberOfFailedBuilds() {
        Run lastSuccess = this.job.getLastSuccessfulBuild();
        Run lastCompiled = this.job.getLastCompletedBuild();
        if (lastSuccess == null || lastCompiled == null) {
            return 0;
        }
        int numberOfFailedBuilds = lastCompiled.getNumber() - lastSuccess.getNumber();
        return numberOfFailedBuilds;
    }

    public String getDiff() {
        Run<?, ?> previous;
        Run run = this.job.getLastSuccessfulBuild();
        if (run != null && (previous = this.getLastSuccessfulFrom(run)) != null) {
            AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
            AbstractTestResultAction prevTests = (AbstractTestResultAction)previous.getAction(AbstractTestResultAction.class);
            if (tests != null && prevTests != null) {
                int currentSuccess = tests.getTotalCount() - tests.getFailCount();
                int prevSuccess = prevTests.getTotalCount() - prevTests.getFailCount();
                return Functions.getDiffString((int)(currentSuccess - prevSuccess));
            }
        }
        return "";
    }

    private Run<?, ?> getLastSuccessfulFrom(Run<?, ?> run) {
        Run r;
        for (r = run.getPreviousBuild(); r != null && (r.isBuilding() || r.getResult() == null || r.getResult().isWorseThan(Result.UNSTABLE)); r = r.getPreviousBuild()) {
        }
        return r;
    }

    public HashSet<User> getCulpritFromBuild(AbstractBuild<?, ?> build) {
        HashSet<User> r = new HashSet<User>();
        for (ChangeLogSet.Entry e : build.getChangeSet()) {
            r.add(e.getAuthor());
        }
        return r;
    }

    public String convertCulpritsToString(HashSet<User> input) {
        String output = "";
        Iterator<User> it = input.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (i < this.getMaxAmmountOfResponsibles()) {
                output = output + it.next().getFullName() + (it.hasNext() ? ", " : "");
            } else {
                it.next();
            }
            ++i;
        }
        if (i > this.getMaxAmmountOfResponsibles()) {
            output = output + "... <" + (i - this.getMaxAmmountOfResponsibles()) + " more>";
        }
        if (!output.isEmpty()) {
            return output;
        }
        return " - ";
    }

    public String getCulprits() {
        if (this.BlameState == XFPanelView.Blame.ONLYFIRSTFAILEDBUILD) {
            Run run = this.job.getLastStableBuild();
            run = run == null ? this.job.getFirstBuild() : run.getNextBuild();
            if (run instanceof AbstractBuild) {
                AbstractBuild firstFailedBuild = (AbstractBuild)run;
                return this.convertCulpritsToString(this.getCulpritFromBuild(firstFailedBuild));
            }
        } else if (this.BlameState == XFPanelView.Blame.ONLYLASTFAILEDBUILD) {
            Run run = this.job.getLastFailedBuild();
            if (run instanceof AbstractBuild) {
                AbstractBuild lastFailedBuild = (AbstractBuild)run;
                return this.convertCulpritsToString(this.getCulpritFromBuild(lastFailedBuild));
            }
        } else if (this.BlameState == XFPanelView.Blame.EVERYINVOLVED) {
            AbstractBuild<?, ?> build = this.getLastBuild();
            HashSet<User> BlameList = new HashSet<User>(build.getCulprits());
            return this.convertCulpritsToString(BlameList);
        }
        return " -";
    }

    private ClaimBuildAction getClaimAction() {
        ClaimBuildAction claimAction = null;
        if (Hudson.getInstance().getPlugin("claim") != null) {
            List claimActionList;
            Run lastBuild = this.job.getLastBuild();
            if (lastBuild != null && lastBuild.isBuilding()) {
                lastBuild = lastBuild.getPreviousBuild();
            }
            if (lastBuild != null && lastBuild instanceof AbstractBuild && (claimActionList = lastBuild.getActions(ClaimBuildAction.class)).size() == 1) {
                claimAction = (ClaimBuildAction)claimActionList.get(0);
            }
        }
        return claimAction;
    }

    public boolean isClaimed() {
        boolean result = false;
        if (this.getIsClaimPluginInstalled().booleanValue()) {
            ClaimBuildAction cba = this.getClaimAction();
            if (cba != null) {
                result = cba.isClaimed();
            }
            if (!result) {
                int claimedTests = this.getNumClaimedTests();
                int totalTests = this.getFailCount();
                if (totalTests > 0 && claimedTests == totalTests) {
                    result = true;
                }
            }
        }
        return result;
    }

    public String getClaimInfo() {
        String name;
        ClaimBuildAction claimAction = this.getClaimAction();
        if (claimAction != null && claimAction.isClaimed() && (name = claimAction.getClaimedByName()) != null) {
            return name;
        }
        return "";
    }

    public TestResult getClaimedTestCases() {
        if (Hudson.getInstance().getPlugin("claim") != null) {
            Run lastBuild = this.job.getLastBuild();
            if (lastBuild == null) {
                return null;
            }
            if (lastBuild.isBuilding() && (lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) == null) {
                return null;
            }
            List claimTestActionList = lastBuild.getActions();
            List results = lastBuild.getActions(TestResultAction.class);
            if (results == null || claimTestActionList == null || results.size() == 0) {
                return null;
            }
            return ((TestResultAction)results.get(0)).getResult();
        }
        return null;
    }

    public String getClaimInfoByTestCases() {
        TestResult testResult = this.getClaimedTestCases();
        if (testResult == null) {
            return "";
        }
        String claimers = "";
        HashSet<String> claimerNames = new HashSet<String>();
        for (CaseResult result : testResult.getFailedTests()) {
            String claimer;
            ClaimTestAction claimTestAction = (ClaimTestAction)result.getTestAction(ClaimTestAction.class);
            if (claimTestAction == null || !claimTestAction.isClaimed() || (claimer = claimTestAction.getClaimedBy()) == null || claimer == "" || claimerNames.contains(claimer)) continue;
            claimerNames.add(claimer);
            if (claimers != "") {
                claimers = claimers + ", ";
            }
            claimers = claimers + claimer;
        }
        if (claimers == null || claimers == "") {
            String buildClaimer = "";
            buildClaimer = this.getClaimInfo();
            if (buildClaimer == null || buildClaimer == "") {
                return "";
            }
            return "Build claimed by: " + buildClaimer;
        }
        return "Claimed by: " + claimers;
    }

    public int getNumClaimedTests() {
        TestResult testResult = this.getClaimedTestCases();
        if (testResult != null) {
            int numClaimedTests = 0;
            for (CaseResult result : testResult.getFailedTests()) {
                ClaimTestAction claimTestAction = (ClaimTestAction)result.getTestAction(ClaimTestAction.class);
                if (claimTestAction == null || !claimTestAction.isClaimed()) continue;
                ++numClaimedTests;
            }
            return numClaimedTests;
        }
        return -1;
    }

    public String getNumberOfTests() {
        int claimedTests;
        int failedTests = this.getFailCount();
        if (failedTests == 0 && !this.getShowZeroTestCounts().booleanValue()) {
            return "";
        }
        if (this.getReplaceNumberOfTestCases().booleanValue() && (claimedTests = this.getNumClaimedTests()) >= 0) {
            return Integer.toString(failedTests - claimedTests);
        }
        return Integer.toString(failedTests);
    }

    public String getDiffColor() {
        String diff = this.getDiff().trim();
        if (diff.length() > 0) {
            if (diff.startsWith("-")) {
                return "#FF0000";
            }
            return "#00FF00";
        }
        return "#" + this.getBuildFontColor();
    }

    public String getSuccessPercentage() {
        if (this.getTestCount() > 0) {
            Double perc = (double)this.getSuccessCount() / ((double)this.getTestCount() * 1.0);
            return NumberFormat.getPercentInstance().format(perc);
        }
        return "";
    }

    public String getBuildStatus(AbstractBuild<?, ?> build) {
        if (build == null) {
            return "UNBUILT";
        }
        if (build.isBuilding()) {
            build = (AbstractBuild)build.getPreviousBuild();
            return this.getBuildStatus(build);
        }
        Result result = build.getResult();
        if (result != null) {
            return result.toString();
        }
        return "UNKNOWN";
    }

    public boolean isBuildSuccessful() {
        AbstractBuild<?, ?> build = this.getLastBuild();
        if (build != null) {
            String buildStatus = this.getBuildStatus(build);
            return buildStatus.equals("SUCCESS");
        }
        return false;
    }

    public boolean isBuildUnstable() {
        AbstractBuild<?, ?> build = this.getLastBuild();
        if (build != null) {
            String buildStatus = this.getBuildStatus(build);
            return buildStatus.equals("UNSTABLE");
        }
        return false;
    }

    private void findStatus() {
        switch (this.job.getIconColor()) {
            case BLUE_ANIME: {
                this.building = true;
            }
            case BLUE: {
                this.backgroundColor = this.getColors().getOkBG();
                this.color = this.colors.getOkFG();
                this.colorFade = "build-fade-ok.png";
                this.broken = false;
                break;
            }
            case YELLOW_ANIME: {
                this.building = true;
            }
            case YELLOW: {
                this.backgroundColor = this.getColors().getFailedBG();
                this.color = this.colors.getFailedFG();
                this.colorFade = "build-fade-fail.png";
                this.broken = false;
                break;
            }
            case RED_ANIME: {
                this.building = true;
            }
            case RED: {
                this.backgroundColor = this.getColors().getBrokenBG();
                this.color = this.colors.getBrokenFG();
                this.colorFade = "build-fade-broken.png";
                this.broken = true;
                break;
            }
            case GREY_ANIME: 
            case DISABLED_ANIME: 
            case ABORTED_ANIME: {
                this.building = true;
            }
            default: {
                this.backgroundColor = this.getColors().getOtherBG();
                this.color = this.colors.getOtherFG();
                this.colorFade = "build-fade-other.png";
                this.broken = true;
            }
        }
    }
}

