/*
 * Decompiled with CFR 0.152.
 */
package au.com.rayh;

import au.com.rayh.report.TestCase;
import au.com.rayh.report.TestFailure;
import au.com.rayh.report.TestSuite;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class XcodeTestSummariesParser {
    private FilePath testReportsDir;
    private static Pattern FAILED_MESSAGE = Pattern.compile("(failed: .*?)\\n\\((.*?)\\n\\)", 32);

    public XcodeTestSummariesParser(FilePath workspace) throws IOException, InterruptedException {
        this.testReportsDir = workspace.child("test-reports");
        this.testReportsDir.mkdirs();
    }

    private void writeTestReport(TestSuite currentTestSuite) throws IOException, InterruptedException, JAXBException {
        try (OutputStream testReportOutputStream = this.outputForSuite(currentTestSuite);){
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TestSuite.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal((Object)currentTestSuite, testReportOutputStream);
        }
    }

    protected OutputStream outputForSuite(TestSuite currentTestSuite) throws IOException, InterruptedException {
        return this.testReportsDir.child("TEST-" + currentTestSuite.getName() + ".xml").write();
    }

    private static void addFailureSummaries(NSObject[] failureSummaries, TestCase currentTestCase) {
        for (NSObject object : failureSummaries) {
            TestFailure failure;
            NSDictionary failureSummarie = (NSDictionary)object;
            boolean performanceFailure = ((NSNumber)failureSummarie.objectForKey("PerformanceFailure")).boolValue();
            if (performanceFailure) continue;
            String message = failureSummarie.objectForKey("Message").toString();
            Matcher m = FAILED_MESSAGE.matcher(message);
            if (m.matches()) {
                String errorMessage = m.group(1);
                String stackTrace = m.group(2);
                failure = new TestFailure(errorMessage, stackTrace);
            } else {
                String fileName = failureSummarie.objectForKey("FileName").toString();
                String lineNumber = failureSummarie.objectForKey("LineNumber").toString();
                failure = new TestFailure(message + "\n at File: " + fileName + "\n Line number: " + lineNumber, "No stacktrace here.");
            }
            currentTestCase.getFailures().add(failure);
        }
    }

    public void parseSubTests(NSObject[] tests, TestSuite parentTestSuite) throws ParseException, IOException, InterruptedException, JAXBException {
        for (NSObject object : tests) {
            NSDictionary test = (NSDictionary)object;
            Float duration = Float.valueOf(((NSNumber)test.objectForKey("Duration")).floatValue());
            String testName = test.objectForKey("TestName").toString();
            String testIdentifier = test.objectForKey("TestIdentifier").toString();
            String testObjectClass = test.objectForKey("TestObjectClass").toString();
            NSObject value = test.objectForKey("Subtests");
            if (value == null) {
                TestCase currentTestCase = new TestCase(parentTestSuite.getName(), testName);
                String testStatus = test.objectForKey("TestStatus").toString();
                if (testStatus.equals("Failure")) {
                    value = test.objectForKey("FailureSummaries");
                    if (value != null) {
                        NSObject[] failureSummaries = ((NSArray)value).getArray();
                        XcodeTestSummariesParser.addFailureSummaries(failureSummaries, currentTestCase);
                    }
                    currentTestCase.setTime(duration.floatValue());
                    parentTestSuite.getTestCases().add(currentTestCase);
                    parentTestSuite.addFailure();
                } else if (testStatus.equals("Success")) {
                    currentTestCase.setTime(duration.floatValue());
                    parentTestSuite.getTestCases().add(currentTestCase);
                    parentTestSuite.addTest();
                }
                this.writeTestReport(parentTestSuite);
                continue;
            }
            TestSuite currentTestSuite = new TestSuite(InetAddress.getLocalHost().getHostName(), testName, null);
            currentTestSuite.setDuration(duration);
            NSObject[] subTests = ((NSArray)value).getArray();
            this.parseSubTests(subTests, currentTestSuite);
        }
    }

    public void parseTestSummariesPlist(FilePath testSummariesPlistFile) {
        try {
            NSObject[] testableSummaries;
            NSDictionary rootDict = (NSDictionary)PropertyListParser.parse((InputStream)testSummariesPlistFile.read());
            for (NSObject object : testableSummaries = ((NSArray)rootDict.objectForKey("TestableSummaries")).getArray()) {
                NSDictionary testSummarie = (NSDictionary)object;
                String diagnosticsDirectory = testSummarie.objectForKey("DiagnosticsDirectory").toString();
                String testName = testSummarie.objectForKey("TestName").toString();
                String projectPath = testSummarie.objectForKey("ProjectPath").toString();
                String targetName = testSummarie.objectForKey("TargetName").toString();
                TestSuite currentTestSuite = new TestSuite(InetAddress.getLocalHost().getHostName(), testName, null);
                NSObject[] tests = ((NSArray)testSummarie.objectForKey("Tests")).getArray();
                if (tests == null) continue;
                this.parseSubTests(tests, currentTestSuite);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

