/*
 * Decompiled with CFR 0.152.
 */
package au.com.rayh;

import au.com.rayh.report.TestCase;
import au.com.rayh.report.TestError;
import au.com.rayh.report.TestFailure;
import au.com.rayh.report.TestSuite;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class XCodeBuildOutputParser {
    private static DateFormat[] dateFormats = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS")};
    private static Pattern START_SUITE = Pattern.compile("Test Suite '([^\\/](?:\\.|[^'\\\\])*)'\\s+started at\\s+(.*)");
    private static Pattern END_SUITE = Pattern.compile("Test Suite '([^\\/](?:\\.|[^'\\\\])*)'\\s+\\S+\\s+at\\s+(.*).");
    private static Pattern START_TESTCASE = Pattern.compile("Test Case '-\\[(\\S+)\\s+(\\S+)\\]' started.");
    private static Pattern END_TESTCASE = Pattern.compile("Test Case '-\\[(\\S+)\\s+(\\S+)\\]' passed \\((.*) seconds\\).");
    private static Pattern ERROR_TESTCASE = Pattern.compile("(.*): error: -\\[(\\S+)\\s+(\\S+)\\] : (.*)");
    private static Pattern ERROR_UI_TESTCASE = Pattern.compile(".*?Assertion Failure: (.+:\\d+): (.*)");
    private static Pattern FAILED_TESTCASE = Pattern.compile("Test Case '-\\[(\\S+)\\s+(\\S+)\\]' failed \\((\\S+) seconds\\).");
    private static Pattern FAILED_WITH_EXIT_CODE = Pattern.compile("failed with exit code (\\d+)");
    private static Pattern TERMINATING_EXCEPTION = Pattern.compile(".*\\*\\*\\* Terminating app due to uncaught exception '(\\S+)', reason: '(.+[^\\\\])'.*");
    private File testReportsDir;
    protected OutputStream captureOutputStream;
    protected int exitCode;
    protected HashMap<String, TestSuite> testSuitesHash = new HashMap();
    protected TestSuite currentTestSuite = null;
    protected TestCase currentTestCase = null;
    protected boolean consoleLog;

    protected XCodeBuildOutputParser() {
    }

    public XCodeBuildOutputParser(File workspace, OutputStream log) {
        this();
        this.captureOutputStream = new LineBasedFilterOutputStream(log);
        this.testReportsDir = workspace;
        this.consoleLog = true;
    }

    private Date parseDate(String text) throws ParseException {
        Date date = null;
        ParseException parseException = null;
        for (DateFormat dateFormat : dateFormats) {
            try {
                date = dateFormat.parse(text);
                break;
            }
            catch (ParseException exception) {
                parseException = exception;
            }
        }
        if (date == null && parseException != null) {
            throw parseException;
        }
        return date;
    }

    private void requireTestSuite() {
        if (this.testSuitesHash.size() == 0) {
            throw new RuntimeException("Log statements out of sync: current test suite was empty");
        }
        if (this.currentTestSuite == null) {
            throw new RuntimeException("Log statements out of sync: current test suite was null");
        }
    }

    private void requireTestSuite(String name) {
        String[] testSuites;
        this.currentTestSuite = this.testSuitesHash.get(name);
        if (this.currentTestSuite == null && (testSuites = name.split(Pattern.quote("."))).length == 2) {
            String xctestName = testSuites[0] + ".xctest";
            String testSuite = testSuites[1];
            if (!this.testSuitesHash.containsKey(xctestName)) {
                throw new RuntimeException("Log statements out of sync: current test suite '" + xctestName + "' not exists");
            }
            this.currentTestSuite = this.testSuitesHash.get(testSuite);
            if (this.currentTestSuite == null) {
                throw new RuntimeException("Log statements out of sync: current test suite '" + testSuite + "' not exists");
            }
        }
    }

    private void requireTestCase(String name) {
        this.currentTestCase = this.currentTestSuite.getTestCasesHash().get(name);
        if (this.currentTestCase == null) {
            throw new RuntimeException("Log statements out of sync: current test case '" + this.currentTestSuite.getName() + "." + name + "' not exists");
        }
    }

    private void writeTestReport() throws IOException, InterruptedException, JAXBException {
        try (OutputStream testReportOutputStream = this.outputForSuite();){
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TestSuite.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal((Object)this.currentTestSuite, testReportOutputStream);
        }
    }

    protected OutputStream outputForSuite() throws IOException, InterruptedException {
        return new FileOutputStream(new File(this.testReportsDir, "TEST-" + this.currentTestSuite.getName() + ".xml"));
    }

    protected void handleLine(String line) throws ParseException, IOException, InterruptedException, JAXBException {
        Matcher m = START_SUITE.matcher(line);
        if (m.matches()) {
            if (this.testSuitesHash.isEmpty()) {
                this.consoleLog = true;
            }
            String suite_name = m.group(1);
            if (m.group(1).endsWith(".xctest")) {
                suite_name = suite_name.replaceAll("-", "_");
            }
            this.currentTestSuite = new TestSuite(InetAddress.getLocalHost().getHostName(), m.group(1), this.parseDate(m.group(2)));
            this.testSuitesHash.put(suite_name, this.currentTestSuite);
            return;
        }
        m = END_SUITE.matcher(line);
        if (m.matches()) {
            String suite_name = m.group(1);
            if (m.group(1).endsWith(".xctest")) {
                suite_name = suite_name.replaceAll("-", "_");
            }
            this.requireTestSuite(suite_name);
            this.currentTestSuite.setEndTime(this.parseDate(m.group(2)));
            this.writeTestReport();
            this.testSuitesHash.remove(suite_name);
            this.currentTestSuite = null;
            if (this.testSuitesHash.size() == 1) {
                this.currentTestSuite = this.testSuitesHash.get("UnknownSuite");
                if (this.currentTestSuite != null) {
                    this.currentTestSuite.setEndTime(this.parseDate(m.group(2)));
                    this.writeTestReport();
                    this.testSuitesHash.remove(suite_name);
                    this.currentTestSuite = null;
                }
            }
            if (this.testSuitesHash.isEmpty()) {
                this.consoleLog = false;
            }
            return;
        }
        m = START_TESTCASE.matcher(line);
        if (m.matches()) {
            this.requireTestSuite(m.group(1));
            this.currentTestCase = new TestCase(m.group(1), m.group(2));
            this.currentTestSuite.getTestCasesHash().put(m.group(2), this.currentTestCase);
            return;
        }
        m = END_TESTCASE.matcher(line);
        if (m.matches()) {
            this.requireTestSuite(m.group(1));
            this.requireTestCase(m.group(2));
            this.currentTestCase.setTime(Float.valueOf(m.group(3)).floatValue());
            this.currentTestSuite.getTestCases().add(this.currentTestCase);
            this.currentTestSuite.addTest();
            this.currentTestCase = null;
            return;
        }
        m = ERROR_TESTCASE.matcher(line);
        if (m.matches()) {
            String errorLocation = m.group(1);
            String testSuite = m.group(2);
            String testCase = m.group(3);
            String errorMessage = m.group(4);
            this.requireTestSuite(testSuite);
            this.requireTestCase(testCase);
            TestFailure failure = new TestFailure(errorMessage, errorLocation);
            this.currentTestCase.getFailures().add(failure);
            return;
        }
        m = ERROR_UI_TESTCASE.matcher(line);
        if (m.matches()) {
            String errorLocation = m.group(1);
            String errorMessage = m.group(2);
            TestFailure failure = new TestFailure(errorMessage, errorLocation);
            if (this.currentTestSuite == null) {
                this.currentTestSuite = this.testSuitesHash.get("UnknownSuite");
                if (this.currentTestSuite == null) {
                    this.currentTestSuite = new TestSuite(InetAddress.getLocalHost().getHostName(), "UnknownSuite", new Date());
                    this.testSuitesHash.put("UnknownSuite", this.currentTestSuite);
                }
            }
            if (this.currentTestCase == null) {
                this.currentTestCase = this.currentTestSuite.getTestCasesHash().get("UnknownTestCase");
                if (this.currentTestCase == null) {
                    this.currentTestCase = new TestCase(this.currentTestSuite.getName(), "UnknownTestCase");
                    this.currentTestSuite.getTestCasesHash().put("UnknownTestCase", this.currentTestCase);
                    this.currentTestSuite.getTestCases().add(this.currentTestCase);
                    this.currentTestSuite.addTest();
                }
            }
            this.currentTestCase.getFailures().add(failure);
            return;
        }
        m = FAILED_TESTCASE.matcher(line);
        if (m.matches()) {
            this.requireTestSuite(m.group(1));
            this.requireTestCase(m.group(2));
            this.currentTestSuite.addTest();
            this.currentTestSuite.addFailure();
            this.currentTestCase.setTime(Float.valueOf(m.group(3)).floatValue());
            this.currentTestSuite.getTestCases().add(this.currentTestCase);
            this.currentTestCase = null;
            return;
        }
        m = FAILED_WITH_EXIT_CODE.matcher(line);
        if (m.matches()) {
            this.exitCode = Integer.parseInt(m.group(1));
            return;
        }
        if (line.matches("BUILD FAILED") || line.matches("\\*\\* TEST FAILED \\*\\*")) {
            this.exitCode = -1;
        }
        if ((m = TERMINATING_EXCEPTION.matcher(line)).matches()) {
            this.exitCode = -1;
            this.requireTestSuite();
            if (this.currentTestCase != null) {
                TestError error = new TestError(m.group(2), m.group(1));
                this.currentTestCase.getErrors().add(error);
                this.currentTestSuite.getTestCases().add(this.currentTestCase);
                this.currentTestSuite.addTest();
                this.currentTestSuite.addError();
                this.currentTestCase = null;
            }
            this.writeTestReport();
            this.currentTestSuite = null;
        }
    }

    public OutputStream getOutputStream() {
        return this.captureOutputStream;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public class LineBasedFilterOutputStream
    extends FilterOutputStream {
        StringBuilder buffer;

        public LineBasedFilterOutputStream(OutputStream log) {
            super(log);
            this.buffer = new StringBuilder();
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            if ((char)b == '\n') {
                try {
                    XCodeBuildOutputParser.this.handleLine(this.buffer.toString());
                    this.buffer = new StringBuilder();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            } else {
                this.buffer.append((char)b);
            }
        }
    }
}

