/*
 * Decompiled with CFR 0.152.
 */
package au.com.rayh;

import au.com.rayh.GlobalConfigurationImpl;
import au.com.rayh.Keychain;
import au.com.rayh.KeychainPasswordAndPath;
import au.com.rayh.Messages;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
public class KeychainUnlockStep
extends Builder
implements SimpleBuildStep {
    @Deprecated
    @CheckForNull
    private String keychainName;
    @CheckForNull
    private String keychainId;
    @CheckForNull
    private String keychainPath;
    @CheckForNull
    private Secret keychainPwd;

    @Deprecated
    @CheckForNull
    public String getKeychainName() {
        return this.keychainName;
    }

    @CheckForNull
    public String getKeychainId() {
        return this.keychainId;
    }

    @Deprecated
    @DataBoundSetter
    public void setKeychainName(String keychainName) {
        this.keychainName = keychainName;
    }

    @DataBoundSetter
    public void setKeychainId(String keychainId) {
        this.keychainId = keychainId;
    }

    @CheckForNull
    public String getKeychainPath() {
        return this.keychainPath;
    }

    @DataBoundSetter
    public void setKeychainPath(String keychainPath) {
        this.keychainPath = keychainPath;
    }

    @CheckForNull
    public Secret getKeychainPwd() {
        return this.keychainPwd;
    }

    @DataBoundSetter
    public void setKeychainPwd(Secret keychainPwd) {
        this.keychainPwd = keychainPwd;
    }

    @DataBoundConstructor
    public KeychainUnlockStep() {
    }

    @Deprecated
    public KeychainUnlockStep(String keychainName) {
        this();
        this.keychainName = keychainName;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        String _keychainPwd;
        String _keychainPath;
        Object keychain;
        EnvVars envs = run.getEnvironment(listener);
        String _keychainId = envs.expand(this.keychainId);
        String _keychainName = envs.expand(this.keychainName);
        if (StringUtils.isNotEmpty((String)_keychainName)) {
            listener.getLogger().println(Messages.XCodeBuilder_UseDeprecatedKeychainInfo());
            keychain = this.getKeychain(_keychainName);
            if (keychain == null) {
                throw new AbortException(Messages.DeveloperProfileLoader_NoKeychainInfoConfigured());
            }
            _keychainPath = envs.expand(((Keychain)keychain).getKeychainPath());
            _keychainPwd = envs.expand(Secret.toString((Secret)((Keychain)keychain).getKeychainPassword()));
        } else if (StringUtils.isNotEmpty((String)_keychainId)) {
            keychain = this.getKeychainPasswordAndPath((Item)run.getParent(), _keychainId);
            if (keychain == null) {
                throw new AbortException(Messages.DeveloperProfileLoader_NoKeychainInfoConfigured());
            }
            _keychainPath = envs.expand(keychain.getKeychainPath());
            _keychainPwd = envs.expand(keychain.getPassword().getPlainText());
        } else {
            _keychainPath = envs.expand(this.keychainPath);
            _keychainPwd = envs.expand(Secret.toString((Secret)this.keychainPwd));
        }
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"security", "unlock-keychain"});
        args.add("-p").addMasked(_keychainPwd);
        args.add(_keychainPath);
        this.invoke(launcher, listener, args, "Failed to unlock keychain");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.perform((Run<?, ?>)build, build.getWorkspace(), launcher, (TaskListener)listener);
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public GlobalConfigurationImpl getGlobalConfiguration() {
        return this.getDescriptor().getGlobalConfiguration();
    }

    public Keychain getKeychain(String keychainName) {
        if (!StringUtils.isEmpty((String)keychainName)) {
            for (Keychain keychain : this.getGlobalConfiguration().getKeychains()) {
                if (!keychain.getKeychainName().equals(keychainName)) continue;
                return keychain;
            }
        }
        if (!StringUtils.isEmpty((String)this.keychainPath)) {
            Keychain newKeychain = new Keychain();
            newKeychain.setKeychainPath(this.keychainPath);
            newKeychain.setKeychainPassword(this.keychainPwd);
            return newKeychain;
        }
        return null;
    }

    public KeychainPasswordAndPath getKeychainPasswordAndPath(Item context, String keychainId) {
        return (KeychainPasswordAndPath)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(KeychainPasswordAndPath.class, (Item)context, (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST), (CredentialsMatcher)CredentialsMatchers.withId((String)keychainId));
    }

    private ByteArrayOutputStream invoke(Launcher launcher, TaskListener listener, ArgumentListBuilder args, String errorMessage) throws IOException, InterruptedException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        if (launcher.launch().cmds(args).stdout((OutputStream)output).join() != 0) {
            listener.getLogger().write(output.toByteArray());
            throw new AbortException(errorMessage);
        }
        return output;
    }

    @Extension
    @Symbol(value={"unlockMacOSKeychain"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        GlobalConfigurationImpl globalConfiguration;

        @Inject
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
        void setGlobalConfiguration(GlobalConfigurationImpl c) {
            this.globalConfiguration = c;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.OSXKeychainUnclockStep_DisplayName();
        }

        public GlobalConfigurationImpl getGlobalConfiguration() {
            return this.globalConfiguration;
        }

        public String getUUID() {
            return "" + UUID.randomUUID().getMostSignificantBits();
        }

        public FormValidation doCheckKeychainPath(@QueryParameter String value, @QueryParameter String keychainName) {
            if (StringUtils.isEmpty((String)keychainName) && StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)Messages.DeveloperProfileLoader_MustSpecifyKeychainPath());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckKeychainPwd(@QueryParameter Secret value, @QueryParameter String keychainName) {
            if (StringUtils.isEmpty((String)keychainName) && StringUtils.isEmpty((String)Secret.toString((Secret)value))) {
                return FormValidation.error((String)Messages.DeveloperProfileLoader_MustSpecifyKeychainPwd());
            }
            return FormValidation.ok();
        }
    }
}

