/*
 * Decompiled with CFR 0.152.
 */
package au.com.rayh;

import au.com.rayh.DeveloperProfile;
import au.com.rayh.GlobalConfigurationImpl;
import au.com.rayh.Keychain;
import au.com.rayh.KeychainPasswordAndPath;
import au.com.rayh.Messages;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.security.MasterToSlaveCallable;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
public class DeveloperProfileLoader
extends Builder
implements SimpleBuildStep {
    @CheckForNull
    private String profileId;
    @CheckForNull
    private Boolean importIntoExistingKeychain;
    @CheckForNull
    private String keychainId;
    @Deprecated
    @CheckForNull
    private String keychainName;
    @CheckForNull
    private String keychainPath;
    @CheckForNull
    private Secret keychainPwd;

    @CheckForNull
    public String getProfileId() {
        return this.profileId;
    }

    @DataBoundSetter
    public void setProfileId(String developerProfileId) {
        this.profileId = developerProfileId;
    }

    public Boolean getImportIntoExistingKeychain() {
        return this.importIntoExistingKeychain == null ? Boolean.valueOf(false) : this.importIntoExistingKeychain;
    }

    @DataBoundSetter
    public void setImportIntoExistingKeychain(Boolean importIntoExistingKeychain) {
        this.importIntoExistingKeychain = importIntoExistingKeychain;
    }

    @CheckForNull
    public String getKeychainId() {
        return this.keychainId;
    }

    @Deprecated
    @CheckForNull
    public String getKeychainName() {
        return this.keychainName;
    }

    @DataBoundSetter
    public void setKeychainId(String keychainId) {
        this.keychainId = keychainId;
    }

    @Deprecated
    @DataBoundSetter
    public void setKeychainName(String keychainName) {
        this.keychainName = keychainName;
    }

    @CheckForNull
    public String getKeychainPath() {
        return this.keychainPath;
    }

    @DataBoundSetter
    public void setKeychainPath(String keychainPath) {
        this.keychainPath = keychainPath;
    }

    @CheckForNull
    public Secret getKeychainPwd() {
        return this.keychainPwd;
    }

    @DataBoundSetter
    public void setKeychainPwd(Secret keychainPwd) {
        this.keychainPwd = keychainPwd;
    }

    @DataBoundConstructor
    public DeveloperProfileLoader() {
    }

    @Deprecated
    public DeveloperProfileLoader(String profileId) {
        this();
        this.profileId = profileId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args;
        String _keychainPwd;
        String _keychainPath;
        EnvVars envs = run.getEnvironment(listener);
        String _profileId = envs.expand(this.profileId);
        String _keychainId = envs.expand(this.keychainId);
        String _keychainName = envs.expand(this.keychainName);
        Boolean _importIntoExistingKeychain = this.importIntoExistingKeychain;
        DeveloperProfile dp = this.getProfile((Item)run.getParent(), _profileId);
        if (dp == null) {
            throw new AbortException(Messages.DeveloperProfile_NoDeveloperProfileConfigured());
        }
        if (BooleanUtils.isTrue((Boolean)_importIntoExistingKeychain)) {
            Object keychain;
            if (StringUtils.isNotEmpty((String)_keychainName)) {
                listener.getLogger().println(Messages.XCodeBuilder_UseDeprecatedKeychainInfo());
                keychain = this.getKeychain(_keychainName);
                if (keychain == null) {
                    throw new AbortException(Messages.DeveloperProfileLoader_NoKeychainInfoConfigured());
                }
                _keychainPath = envs.expand(((Keychain)keychain).getKeychainPath());
                _keychainPwd = envs.expand(Secret.toString((Secret)((Keychain)keychain).getKeychainPassword()));
                _importIntoExistingKeychain = true;
            } else if (StringUtils.isNotEmpty((String)_keychainId)) {
                keychain = this.getKeychainPasswordAndPath((Item)run.getParent(), _keychainId);
                if (keychain == null) {
                    throw new AbortException(Messages.DeveloperProfileLoader_NoKeychainInfoConfigured());
                }
                _keychainPath = envs.expand(keychain.getKeychainPath());
                _keychainPwd = envs.expand(keychain.getPassword().getPlainText());
                _importIntoExistingKeychain = true;
            } else {
                if (!StringUtils.isNotEmpty((String)this.keychainPath) || !StringUtils.isNotEmpty((String)Secret.toString((Secret)this.keychainPwd))) throw new AbortException(Messages.DeveloperProfileLoader_KeychainPathOrPasswordIsBlank());
                _keychainPath = envs.expand(this.keychainPath);
                _keychainPwd = envs.expand(Secret.toString((Secret)this.keychainPwd));
            }
        } else {
            _keychainPath = "jenkins-" + run.getParent().getFullName().replace('/', '-');
            _keychainPwd = UUID.randomUUID().toString();
            _importIntoExistingKeychain = false;
        }
        if (BooleanUtils.isNotTrue((Boolean)_importIntoExistingKeychain)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            args = new ArgumentListBuilder(new String[]{"security", "delete-keychain", _keychainPath});
            launcher.launch().cmds(args).stdout((OutputStream)out).join();
            args = new ArgumentListBuilder(new String[]{"security", "create-keychain"});
            args.add("-p").addMasked(_keychainPwd);
            args.add(_keychainPath);
            this.invoke(launcher, listener, args, "Failed to create a keychain");
        }
        args = new ArgumentListBuilder(new String[]{"security", "unlock-keychain"});
        args.add("-p").addMasked(_keychainPwd);
        args.add(_keychainPath);
        this.invoke(launcher, listener, args, "Failed to unlock keychain");
        if (BooleanUtils.isNotTrue((Boolean)_importIntoExistingKeychain)) {
            args = new ArgumentListBuilder(new String[]{"security", "list-keychains"});
            args.add("-d").add("user");
            args.add("-s").add("login.keychain");
            args.add(_keychainPath);
            this.invoke(launcher, listener, args, "Failed to set keychain search path");
        }
        FilePath secret = this.getSecretDir(workspace, _keychainPwd);
        byte[] dpImage = dp.getImage();
        if (dpImage == null) {
            throw new AbortException(Messages.DeveloperProfile_NoDeveloperProfileConfigured());
        }
        secret.unzipFrom((InputStream)new ByteArrayInputStream(dpImage));
        for (FilePath id : secret.list("**/*.p12")) {
            args = new ArgumentListBuilder(new String[]{"security", "import"});
            args.add((Object)id).add(new String[]{"-k", _keychainPath});
            args.add("-P").addMasked(dp.getPassword().getPlainText());
            args.add(new String[]{"-T", "/usr/bin/codesign"});
            args.add(new String[]{"-T", "/usr/bin/productsign"});
            args.add(_keychainPath);
            this.invoke(launcher, listener, args, "Failed to import identity " + id);
        }
        args = new ArgumentListBuilder(new String[]{"security", "show-keychain-info"});
        args.add(_keychainPath);
        ByteArrayOutputStream output = this.invoke(launcher, listener, args, "Failed to show keychain info");
        listener.getLogger().write(output.toByteArray());
        if (BooleanUtils.isNotTrue((Boolean)_importIntoExistingKeychain)) {
            args = new ArgumentListBuilder(new String[]{"security", "set-key-partition-list"});
            args.add("-S").add("apple-tool:,apple:");
            args.add("-s").add("-k").addMasked(_keychainPwd);
            args.add(_keychainPath);
            this.invoke(launcher, listener, args, "Failed to set key partition list to keychain");
        }
        args = new ArgumentListBuilder(new String[]{"security", "default-keychain"});
        output = new ByteArrayOutputStream();
        if (launcher.launch().cmds(args).stdout((OutputStream)output).join() != 0) {
            listener.getLogger().write(output.toByteArray());
            String strResult = new String(output.toByteArray(), "UTF-8");
            if (strResult.contains("A default keychain could not be found.")) {
                args = new ArgumentListBuilder(new String[]{"security", "default-keychain"});
                args.add("-d").add("user");
                args.add("-s").add(_keychainPath);
                this.invoke(launcher, listener, args, "Failed to set default keychain");
            }
        }
        if (BooleanUtils.isNotTrue((Boolean)_importIntoExistingKeychain)) {
            this.importAppleCert(launcher, listener, workspace, _keychainPath);
        }
        VirtualChannel ch = launcher.getChannel();
        FilePath home = (FilePath)ch.call((Callable)new GetHomeDirectory());
        FilePath profiles = home.child("Library/MobileDevice/Provisioning Profiles");
        profiles.mkdirs();
        for (FilePath mp : secret.list("**/*.mobileprovision")) {
            listener.getLogger().println(Messages.DeveloperProfile_Installing(mp.getName()));
            mp.copyTo(profiles.child(mp.getName()));
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.perform((Run<?, ?>)build, build.getWorkspace(), launcher, (TaskListener)listener);
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public GlobalConfigurationImpl getGlobalConfiguration() {
        return this.getDescriptor().getGlobalConfiguration();
    }

    public Keychain getKeychain(String keychainName) {
        if (!StringUtils.isEmpty((String)keychainName)) {
            for (Keychain keychain : this.getGlobalConfiguration().getKeychains()) {
                if (!keychain.getKeychainName().equals(keychainName)) continue;
                return keychain;
            }
        }
        if (!StringUtils.isEmpty((String)this.keychainPath)) {
            Keychain newKeychain = new Keychain();
            newKeychain.setKeychainPath(this.keychainPath);
            newKeychain.setKeychainPassword(this.keychainPwd);
            return newKeychain;
        }
        return null;
    }

    public KeychainPasswordAndPath getKeychainPasswordAndPath(Item context, String keychainId) {
        return (KeychainPasswordAndPath)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(KeychainPasswordAndPath.class, (Item)context, (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST), (CredentialsMatcher)CredentialsMatchers.withId((String)keychainId));
    }

    public void importAppleCert(Launcher launcher, TaskListener listener, FilePath workspace, String keychainPath) throws IOException, InterruptedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FilePath homeFolder = FilePath.getHomeDirectory((VirtualChannel)workspace.getChannel());
        String homePath = homeFolder.getRemote();
        String cert = homePath + "/AppleWWDRCA.cer";
        launcher.launch().cmds(new String[]{"security", "import", cert, "-k", keychainPath}).stdout((OutputStream)out).join();
        listener.getLogger().write(out.toByteArray());
    }

    private ByteArrayOutputStream invoke(Launcher launcher, TaskListener listener, ArgumentListBuilder args, String errorMessage) throws IOException, InterruptedException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        if (launcher.launch().cmds(args).stdout((OutputStream)output).join() != 0) {
            listener.getLogger().write(output.toByteArray());
            throw new AbortException(errorMessage);
        }
        return output;
    }

    private FilePath getSecretDir(FilePath workspace, String keychainPwd) throws IOException, InterruptedException {
        FilePath secrets = workspace.child("jenkins").child("developer-profiles");
        secrets.mkdirs();
        secrets.chmod(448);
        return secrets.child(keychainPwd);
    }

    public DeveloperProfile getProfile(Item context, String profileId) {
        return (DeveloperProfile)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(DeveloperProfile.class, (Item)context, (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST), (CredentialsMatcher)CredentialsMatchers.withId((String)profileId));
    }

    private static final class GetHomeDirectory
    extends MasterToSlaveCallable<FilePath, IOException> {
        private GetHomeDirectory() {
        }

        public FilePath call() throws IOException {
            return new FilePath(new File(System.getProperty("user.home")));
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
        }
    }

    @Extension
    @Symbol(value={"importDeveloperProfile"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        GlobalConfigurationImpl globalConfiguration;

        @Inject
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
        void setGlobalConfiguration(GlobalConfigurationImpl c) {
            this.globalConfiguration = c;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.DeveloperProfile_ImportDeveloperProfile();
        }

        public ListBoxModel doFillProfileIdItems(@AncestorInPath Item context) {
            List profiles = CredentialsProvider.lookupCredentials(DeveloperProfile.class, (Item)context, null);
            ListBoxModel r = new ListBoxModel();
            for (DeveloperProfile p : profiles) {
                r.add(p.getDescription(), p.getId());
            }
            return r;
        }

        public GlobalConfigurationImpl getGlobalConfiguration() {
            return this.globalConfiguration;
        }

        public String getUUID() {
            return "" + UUID.randomUUID().getMostSignificantBits();
        }

        public FormValidation doCheckDeveloperProfileId(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)Messages.DeveloperProfileLoader_MustSelectDeveloperProfile());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckKeychainPath(@QueryParameter String value, @QueryParameter String keychainName, @QueryParameter Boolean importIntoExistingKeychain) {
            if (BooleanUtils.isTrue((Boolean)importIntoExistingKeychain) && StringUtils.isEmpty((String)keychainName) && StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)Messages.DeveloperProfileLoader_MustSpecifyKeychainPath());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckKeychainPwd(@QueryParameter Secret value, @QueryParameter String keychainName, @QueryParameter Boolean importIntoExistingKeychain) {
            if (BooleanUtils.isTrue((Boolean)importIntoExistingKeychain) && StringUtils.isEmpty((String)keychainName) && StringUtils.isEmpty((String)Secret.toString((Secret)value))) {
                return FormValidation.error((String)Messages.DeveloperProfileLoader_MustSpecifyKeychainPwd());
            }
            return FormValidation.ok();
        }
    }
}

