/*
 * Decompiled with CFR 0.152.
 */
package au.com.rayh;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.IOUtils;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import jenkins.security.ConfidentialKey;
import org.acegisecurity.Authentication;
import org.apache.commons.fileupload.FileItem;
import org.kohsuke.stapler.DataBoundConstructor;

public class DeveloperProfile
extends BaseStandardCredentials {
    private Secret password;

    @DataBoundConstructor
    public DeveloperProfile(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, Secret password, FileItem image) throws IOException {
        super(scope, id, description);
        this.password = password;
        if (image != null) {
            new ConfidentialKeyImpl(id).store(image);
        }
    }

    @Deprecated
    public DeveloperProfile(String id, String description, Secret password, FileItem image) throws IOException {
        this(CredentialsScope.GLOBAL, id, description, password, image);
    }

    public Secret getPassword() {
        return this.password;
    }

    public byte[] getImage() throws IOException {
        return new ConfidentialKeyImpl(this.getId()).load();
    }

    @Nonnull
    public List<X509Certificate> getCertificates() throws IOException, GeneralSecurityException {
        try (ZipInputStream zip = new ZipInputStream(new ByteArrayInputStream(this.getImage()));){
            ZipEntry ze;
            ArrayList<X509Certificate> r = new ArrayList<X509Certificate>();
            while ((ze = zip.getNextEntry()) != null) {
                if (!ze.getName().endsWith(".p12")) continue;
                KeyStore ks = KeyStore.getInstance("pkcs12");
                ks.load(zip, this.password.getPlainText().toCharArray());
                Enumeration<String> en = ks.aliases();
                while (en.hasMoreElements()) {
                    String s = en.nextElement();
                    Certificate c = ks.getCertificate(s);
                    if (!(c instanceof X509Certificate)) continue;
                    r.add((X509Certificate)c);
                }
            }
            ArrayList<X509Certificate> arrayList = r;
            return arrayList;
        }
    }

    public String getDisplayNameOf(X509Certificate p) {
        String name = p.getSubjectDN().getName();
        try {
            LdapName n = new LdapName(name);
            for (Rdn rdn : n.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                return rdn.getValue().toString();
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return name;
    }

    public static List<DeveloperProfile> getAllProfiles() {
        return CredentialsProvider.lookupCredentials(DeveloperProfile.class, (Item)null, (Authentication)ACL.SYSTEM, Collections.emptyList());
    }

    static class ConfidentialKeyImpl
    extends ConfidentialKey {
        ConfidentialKeyImpl(String id) {
            super(DeveloperProfile.class.getName() + "." + id);
        }

        public void store(FileItem submitted) throws IOException {
            super.store(IOUtils.toByteArray((InputStream)submitted.getInputStream()));
        }

        @CheckForNull
        public byte[] load() throws IOException {
            return super.load();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Apple Developer Profile";
        }
    }
}

