/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.jenkins.extractor.maven;

import hudson.Extension;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.model.BuildListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.whitesource.agent.hash.ChecksumUtils;
import org.whitesource.jenkins.extractor.maven.MavenDependenciesRecord;
import org.whitesource.jenkins.model.RemoteDependency;

public class MavenDependenciesRecorder
extends MavenReporter {
    private static final long serialVersionUID = 9107918530513865446L;
    private transient Set<RemoteDependency> dependencies;

    public boolean preBuild(MavenBuildProxy build, MavenProject pom, BuildListener listener) {
        listener.getLogger().println("[Jenkins] Collecting dependencies info");
        this.dependencies = new HashSet<RemoteDependency>();
        return true;
    }

    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) {
        this.recordMavenDependencies(pom.getArtifacts());
        return true;
    }

    public boolean postBuild(MavenBuildProxy build, MavenProject pom, BuildListener listener) throws InterruptedException, IOException {
        build.executeAsync((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<Void, IOException>(){
            private static final long serialVersionUID = -3923086337535368565L;
            private final Set<RemoteDependency> d;
            {
                this.d = MavenDependenciesRecorder.this.dependencies;
            }

            public Void call(MavenBuild build) throws IOException, InterruptedException {
                build.getActions().add(new MavenDependenciesRecord(this.d));
                return null;
            }
        });
        return true;
    }

    private void recordMavenDependencies(Set<Artifact> artifacts) {
        if (artifacts != null) {
            for (Artifact dependency : artifacts) {
                File dependencyFile = dependency.getFile();
                if (!dependency.isResolved() || dependencyFile == null) continue;
                RemoteDependency info = new RemoteDependency();
                info.setGroupId(dependency.getGroupId());
                info.setArtifactId(dependency.getArtifactId());
                info.setVersion(dependency.getVersion());
                info.setType(dependency.getType());
                info.setClassifier(dependency.getClassifier());
                info.setScope(dependency.getScope());
                info.setSystemPath(dependencyFile.getName());
                if (dependencyFile.exists()) {
                    try {
                        info.setSha1(ChecksumUtils.calculateSHA1((File)dependencyFile));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.dependencies.add(info);
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return "Record Maven Dependencies";
        }

        public MavenReporter newAutoInstance(MavenModule module) {
            return new MavenDependenciesRecorder();
        }
    }
}

