/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.jenkins.extractor.generic;

import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.Coordinates;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.jenkins.extractor.BaseOssInfoExtractor;
import org.whitesource.jenkins.extractor.generic.LibFolderScanner;
import org.whitesource.jenkins.model.RemoteDependency;

public class GenericOssInfoExtractor
extends BaseOssInfoExtractor {
    public static final List<String> DEFAULT_SCAN_EXTENSIONS = Arrays.asList("jar", "war", "ear", "par", "rar", "dll", "exe", "ko", "so", "msi", "zip", "tar", "tar.gz", "swc", "swf");
    private final String projectToken;
    private final FilePath workspace;

    public GenericOssInfoExtractor(String includes, String excludes, Run<?, ?> run, TaskListener listener, String projectToken, FilePath workspace) {
        super(includes, excludes, run, listener);
        this.projectToken = projectToken;
        this.workspace = workspace;
    }

    @Override
    public Collection<AgentProjectInfo> extract() throws InterruptedException, IOException {
        ArrayList<AgentProjectInfo> projectInfos = new ArrayList<AgentProjectInfo>();
        if (CollectionUtils.isEmpty((Collection)this.includes)) {
            for (String extension : DEFAULT_SCAN_EXTENSIONS) {
                this.includes.add("**/*." + extension);
            }
        }
        LibFolderScanner libScanner = new LibFolderScanner(this.includes, this.excludes, this.listener);
        AgentProjectInfo projectInfo = new AgentProjectInfo();
        if (StringUtils.isBlank((String)this.projectToken)) {
            projectInfo.setCoordinates(new Coordinates(null, this.run.getParent().getName(), "build #" + this.run.getNumber()));
        } else {
            projectInfo.setProjectToken(this.projectToken);
        }
        if (this.workspace == null) {
            throw new RuntimeException("Failed to acquire the Build's workspace");
        }
        ArrayList<DependencyInfo> dependencies = projectInfo.getDependencies();
        if (dependencies == null) {
            dependencies = new ArrayList<DependencyInfo>();
            projectInfo.setDependencies((List)dependencies);
        }
        Collection remoteDependencies = (Collection)this.workspace.act((FilePath.FileCallable)libScanner);
        dependencies.addAll(RemoteDependency.convert(remoteDependencies));
        projectInfos.add(projectInfo);
        return projectInfos;
    }
}

