/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.jenkins;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.jenkins.WssUtils;
import org.whitesource.jenkins.model.WhiteSourceDescriptor;
import org.whitesource.jenkins.model.WhiteSourceStep;

public class WhiteSourcePublisher
extends Publisher
implements SimpleBuildStep {
    private String jobCheckPolicies;
    private String jobForceUpdate;
    private String jobApiToken;
    private String jobUserKey;
    private String product;
    private String productVersion;
    private String projectToken;
    private String libIncludes;
    private String libExcludes;
    private String mavenProjectToken;
    private String requesterEmail;
    private String moduleTokens;
    private String modulesToInclude;
    private String modulesToExclude;
    private boolean ignorePomModules;
    private static String ENV_REGEX = "(\\$\\{.*?})|(\\$[^\\s]+)";

    public WhiteSourcePublisher(WhiteSourcePublisher whiteSourcePublisher) {
        this.jobCheckPolicies = whiteSourcePublisher.jobCheckPolicies;
        this.jobForceUpdate = whiteSourcePublisher.jobForceUpdate;
        this.jobApiToken = whiteSourcePublisher.jobApiToken;
        this.jobUserKey = whiteSourcePublisher.jobUserKey;
        this.product = whiteSourcePublisher.product;
        this.productVersion = whiteSourcePublisher.productVersion;
        this.projectToken = whiteSourcePublisher.projectToken;
        this.libIncludes = whiteSourcePublisher.libIncludes;
        this.libExcludes = whiteSourcePublisher.libExcludes;
        this.mavenProjectToken = whiteSourcePublisher.mavenProjectToken;
        this.requesterEmail = whiteSourcePublisher.requesterEmail;
        this.moduleTokens = whiteSourcePublisher.moduleTokens;
        this.modulesToInclude = whiteSourcePublisher.modulesToInclude;
        this.modulesToExclude = whiteSourcePublisher.modulesToExclude;
        this.ignorePomModules = whiteSourcePublisher.ignorePomModules;
    }

    @DataBoundConstructor
    public WhiteSourcePublisher(String jobCheckPolicies, String jobForceUpdate, String jobApiToken, String jobUserKey, String product, String productVersion, String projectToken, String libIncludes, String libExcludes, String mavenProjectToken, String requesterEmail, String moduleTokens, String modulesToInclude, String modulesToExclude, boolean ignorePomModules) {
        this.jobCheckPolicies = jobCheckPolicies;
        this.jobForceUpdate = jobForceUpdate;
        this.jobApiToken = jobApiToken;
        this.jobUserKey = jobUserKey;
        this.product = product;
        this.productVersion = productVersion;
        this.projectToken = projectToken;
        this.libIncludes = libIncludes;
        this.libExcludes = libExcludes;
        this.mavenProjectToken = mavenProjectToken;
        this.requesterEmail = requesterEmail;
        this.moduleTokens = moduleTokens;
        this.modulesToInclude = modulesToInclude;
        this.modulesToExclude = modulesToExclude;
        this.ignorePomModules = ignorePomModules;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        WhiteSourcePublisher whiteSourcePublisher = this.checkEnvironmentVariables(run, listener);
        PrintStream logger = listener.getLogger();
        Result buildResult = run.getResult();
        if (buildResult == null) {
            throw new RuntimeException("Failed to acquire build result");
        }
        if (buildResult.isWorseThan(Result.SUCCESS)) {
            logger.println("Build failed. Skipping update.");
            return;
        }
        if (WssUtils.isFreeStyleMaven(run.getParent())) {
            logger.println("Free style maven jobs are not supported in this version. See plugin documentation.");
            return;
        }
        logger.println("Updating White Source.");
        WhiteSourceStep whiteSourceStep = new WhiteSourceStep(whiteSourcePublisher, new WhiteSourceDescriptor((DescriptorImpl)this.getDescriptor()));
        if (StringUtils.isBlank((String)whiteSourceStep.getJobApiToken())) {
            logger.println("No API token configured. Skipping update.");
            return;
        }
        Collection<AgentProjectInfo> projectInfos = whiteSourceStep.getProjectInfos(run, listener, workspace, false);
        if (projectInfos.isEmpty()) {
            logger.println("No open source information found.");
        } else {
            whiteSourceStep.update(run, listener, projectInfos);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private WhiteSourcePublisher checkEnvironmentVariables(@Nonnull Run<?, ?> run, @Nonnull TaskListener listener) {
        WhiteSourcePublisher whiteSourcePublisher = new WhiteSourcePublisher(this);
        whiteSourcePublisher.jobApiToken = this.extractEnvironmentVariables(run, listener, this.jobApiToken);
        whiteSourcePublisher.jobUserKey = this.extractEnvironmentVariables(run, listener, this.jobUserKey);
        whiteSourcePublisher.product = this.extractEnvironmentVariables(run, listener, this.product);
        whiteSourcePublisher.productVersion = this.extractEnvironmentVariables(run, listener, this.productVersion);
        whiteSourcePublisher.projectToken = this.extractEnvironmentVariables(run, listener, this.projectToken);
        whiteSourcePublisher.libIncludes = this.extractEnvironmentVariables(run, listener, this.libIncludes);
        whiteSourcePublisher.libExcludes = this.extractEnvironmentVariables(run, listener, this.libExcludes);
        whiteSourcePublisher.requesterEmail = this.extractEnvironmentVariables(run, listener, this.requesterEmail);
        return whiteSourcePublisher;
    }

    private String extractEnvironmentVariables(@Nonnull Run<?, ?> run, @Nonnull TaskListener listener, String variable) {
        if (StringUtils.isNotEmpty((String)variable)) {
            String result;
            block6: {
                String envMatch = variable;
                result = variable;
                try {
                    EnvVars envVars = run.getEnvironment(listener);
                    Pattern pattern = Pattern.compile(ENV_REGEX);
                    Matcher matcher = pattern.matcher(envMatch);
                    if (matcher.find()) {
                        envMatch = matcher.group(0);
                        envMatch = envMatch.startsWith("${") ? envMatch.substring(2, envMatch.length() - 1) : envMatch.substring(1, envMatch.length() - 1);
                        String envFound = (String)envVars.get((Object)envMatch);
                        if (envFound != null) {
                            result = result.replace(matcher.group(0), (CharSequence)envVars.get((Object)envMatch));
                        }
                        break block6;
                    }
                    return variable;
                }
                catch (IOException | InterruptedException e) {
                    listener.error(e.getMessage());
                }
            }
            if (result != null) {
                return result;
            }
        }
        return variable;
    }

    public String getJobCheckPolicies() {
        return this.jobCheckPolicies;
    }

    public String getJobForceUpdate() {
        return this.jobForceUpdate;
    }

    public String getJobApiToken() {
        return this.jobApiToken;
    }

    public String getJobUserKey() {
        return this.jobUserKey;
    }

    public String getProduct() {
        return this.product;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getProjectToken() {
        return this.projectToken;
    }

    public String getLibIncludes() {
        return this.libIncludes;
    }

    public String getLibExcludes() {
        return this.libExcludes;
    }

    public String getMavenProjectToken() {
        return this.mavenProjectToken;
    }

    public String getRequesterEmail() {
        return this.requesterEmail;
    }

    public String getModuleTokens() {
        return this.moduleTokens;
    }

    public String getModulesToInclude() {
        return this.modulesToInclude;
    }

    public String getModulesToExclude() {
        return this.modulesToExclude;
    }

    public boolean isIgnorePomModules() {
        return this.ignorePomModules;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String serviceUrl;
        private String apiToken;
        private String userKey;
        private String checkPolicies;
        private boolean globalForceUpdate;
        private boolean failOnError;
        private boolean overrideProxySettings;
        private String server;
        private String port;
        private String userName;
        private String password;
        private String connectionTimeout;
        private String connectionRetries;
        private String connectionRetriesInterval;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "White Source Publisher";
        }

        public String getHelpFile() {
            return "/plugin/whitesource/help/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.apiToken = json.getString("apiToken");
            this.userKey = json.getString("userKey");
            this.serviceUrl = json.getString("serviceUrl");
            this.checkPolicies = json.getString("checkPolicies");
            this.failOnError = json.getBoolean("failOnError");
            this.globalForceUpdate = json.getBoolean("globalForceUpdate");
            JSONObject proxySettings = (JSONObject)json.get("proxySettings");
            if (proxySettings == null) {
                this.overrideProxySettings = false;
            } else {
                this.overrideProxySettings = true;
                this.server = proxySettings.getString("server");
                this.port = proxySettings.getString("port");
                this.userName = proxySettings.getString("userName");
                this.password = proxySettings.getString("password");
            }
            this.connectionTimeout = json.getString("connectionTimeout");
            this.connectionRetries = json.getString("connectionRetries");
            this.connectionRetriesInterval = json.getString("connectionRetriesInterval");
            this.save();
            return super.configure(req, json);
        }

        public FormValidation doCheckApiToken(@QueryParameter String apiToken) {
            return FormValidation.validateRequired((String)apiToken);
        }

        public FormValidation doCheckConnectionTimeout(@QueryParameter String connectionTimeout) {
            FormValidation formValidation = FormValidation.validatePositiveInteger((String)connectionTimeout);
            return formValidation;
        }

        public FormValidation doCheckConnectionRetries(@QueryParameter String connectionRetries) {
            FormValidation formValidation = FormValidation.validateNonNegativeInteger((String)connectionRetries);
            return formValidation;
        }

        public FormValidation doCheckConnectionRetriesInterval(@QueryParameter String connectionRetriesInterval) {
            FormValidation formValidation = FormValidation.validateNonNegativeInteger((String)connectionRetriesInterval);
            return formValidation;
        }

        public String getServiceUrl() {
            return this.serviceUrl;
        }

        public void setServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        public String getApiToken() {
            return this.apiToken;
        }

        public void setApiToken(String apiToken) {
            this.apiToken = apiToken;
        }

        public String getUserKey() {
            return this.userKey;
        }

        public void setUserKey(String userKey) {
            this.userKey = userKey;
        }

        public String getCheckPolicies() {
            return this.checkPolicies;
        }

        public void setCheckPolicies(String checkPolicies) {
            this.checkPolicies = checkPolicies;
        }

        public boolean isFailOnError() {
            return this.failOnError;
        }

        public void setFailOnError(boolean failOnError) {
            this.failOnError = failOnError;
        }

        public boolean isOverrideProxySettings() {
            return this.overrideProxySettings;
        }

        public void setOverrideProxySettings(boolean overrideProxySettings) {
            this.overrideProxySettings = overrideProxySettings;
        }

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(String connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public boolean isGlobalForceUpdate() {
            return this.globalForceUpdate;
        }

        public void setGlobalForceUpdate(boolean globalForceUpdate) {
            this.globalForceUpdate = globalForceUpdate;
        }

        public String getConnectionRetries() {
            return this.connectionRetries;
        }

        public void setConnectionRetries(String connectionRetries) {
            this.connectionRetries = connectionRetries;
        }

        public String getConnectionRetriesInterval() {
            return this.connectionRetriesInterval;
        }

        public void setConnectionRetriesInterval(String connectionRetriesInterval) {
            this.connectionRetriesInterval = connectionRetriesInterval;
        }
    }
}

