/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic.util;

import com.google.common.collect.Lists;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class DeployerClassPathUtils {
    public static boolean checkDefaultPathToWebLogicJar() {
        return new File(DeployerClassPathUtils.getDefaultPathToWebLogicJar()).exists();
    }

    public static String getDefaultPathToWebLogicJar() {
        String envWlHome = System.getenv("WL_HOME");
        return FilenameUtils.normalize((String)(envWlHome + "/server/lib/" + "weblogic.jar"));
    }

    public static String formatAndCheckClasspath(String classpath, AbstractBuild<?, ?> build, BuildListener listener) {
        if (!"".equalsIgnoreCase(build.getBuiltOnStr())) {
            return DeployerClassPathUtils.formatAndCheckClasspathForNode(classpath, build, listener);
        }
        DeployerClassPathUtils.checkClasspath(classpath, build, listener);
        return classpath;
    }

    private static String formatAndCheckClasspathForNode(String classpath, AbstractBuild<?, ?> build, BuildListener listener) {
        ArrayList newPaths = Lists.newArrayList();
        try {
            VirtualChannel channel = build.getWorkspace().getChannel();
            String remotePathSeparator = DeployerClassPathUtils.isUnix(channel, new FilePath(channel, build.getWorkspace().getRemote())) ? ":" : ";";
            String remoteFileSeparator = DeployerClassPathUtils.isUnix(channel, new FilePath(channel, build.getWorkspace().getRemote())) ? "/" : "\\";
            for (String path : classpath.split(File.pathSeparator)) {
                FilePath srcFile = new FilePath(new File(path));
                FilePath fp = new FilePath(channel, build.getWorkspace().getRemote().concat(remoteFileSeparator).concat(srcFile.getName()));
                String remotePath = fp.getRemote();
                if (!fp.exists()) {
                    listener.error("[WeblogicDeploymentPlugin] - The following library '" + remotePath + "' declared on classpath is missing on node '" + build.getBuiltOnStr() + "'.");
                    throw new Run.RunnerAbortedException();
                }
                newPaths.add(remotePath);
            }
            return StringUtils.join((Collection)newPaths, (String)remotePathSeparator);
        }
        catch (IOException e) {
            listener.error("[WeblogicDeploymentPlugin] - Unable to compute classpath for remote invocation.", new Object[]{e});
            throw new Run.RunnerAbortedException();
        }
        catch (InterruptedException e) {
            listener.error("[WeblogicDeploymentPlugin] - Unable to compute classpath for remote invocation.", new Object[]{e});
            throw new Run.RunnerAbortedException();
        }
    }

    public static void checkClasspath(String classpath, AbstractBuild<?, ?> build, BuildListener listener) {
        try {
            for (String path : classpath.split(File.pathSeparator)) {
                FilePath srcFile = new FilePath(new File(path));
                if (srcFile.exists()) continue;
                listener.error("[WeblogicDeploymentPlugin] - The following library '" + srcFile.getName() + "' declared on classpath is missing");
                throw new Run.RunnerAbortedException();
            }
        }
        catch (IOException e) {
            listener.error("[WeblogicDeploymentPlugin] - Unable to check classpath for invocation.", new Object[]{e});
            throw new Run.RunnerAbortedException();
        }
        catch (InterruptedException e) {
            listener.error("[WeblogicDeploymentPlugin] - Unable to check classpath for invocation.", new Object[]{e});
            throw new Run.RunnerAbortedException();
        }
    }

    private static boolean isUnix(VirtualChannel channel, FilePath fp) {
        if (channel == null) {
            return File.pathSeparatorChar != ';';
        }
        String remote = fp.getRemote();
        if (remote.length() > 3 && remote.charAt(1) == ':' && remote.charAt(2) == '\\') {
            return false;
        }
        return remote.indexOf("\\") == -1;
    }
}

