/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic.jdk;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.util.NullStream;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class JdkToolService {
    public static final String EXTERNAL_ENV_JDK = "environment";
    public static final String SYSTEM_JDK = "system";
    public static final String JAVA_VERSION_COMMAND_VERSION_LINE_REGEX = ".*\\r*\\n*(java version )(\")(.+)(\").*\\r*\\n*.*\\r*\\n*.*\\r*\\n*";

    public static List<JDK> getJdkToolAvailables() throws IOException, InterruptedException {
        ArrayList<JDK> jdkToolAvailables = new ArrayList<JDK>();
        if (StringUtils.isNotBlank((String)SystemUtils.JAVA_HOME)) {
            jdkToolAvailables.add(new JDK(SYSTEM_JDK, System.getProperty("java.home")));
        }
        if (StringUtils.isNotBlank((String)System.getenv("JAVA_HOME"))) {
            jdkToolAvailables.add(new JDK(EXTERNAL_ENV_JDK, System.getenv("JAVA_HOME")));
        }
        for (JDK jdk : Jenkins.getInstance().getJDKs()) {
            Jenkins masterNode = Jenkins.getInstance();
            JDK jdkToolOnMasterNode = jdk.forNode((Node)masterNode, (TaskListener)new StreamTaskListener((OutputStream)new NullStream()));
            jdkToolAvailables.add(jdkToolOnMasterNode);
        }
        return jdkToolAvailables;
    }

    public static JDK getJDKByName(Node node, String name) throws IOException, InterruptedException {
        JDK out = null;
        for (JDK jdk : JdkToolService.getJdkToolAvailables()) {
            if (!name.equalsIgnoreCase(jdk.getName())) continue;
            return jdk.forNode(node, (TaskListener)new StreamTaskListener((OutputStream)new NullStream()));
        }
        return out;
    }

    public static boolean checkJdkVersion(Node node, JDK jdk, PrintStream logger) {
        if (jdk == null || !jdk.getExists()) {
            return false;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamTaskListener listener = new StreamTaskListener((OutputStream)out);
            Launcher launcher = node.createLauncher((TaskListener)listener);
            String cmd = new FilePath(node.getChannel(), jdk.getHome().concat("/bin/java")).getRemote();
            int result = launcher.launch().cmds(new String[]{cmd, "-version"}).stdout((OutputStream)out).join();
            if (result != 0) {
                logger.println("[WeblogicDeploymentPlugin] - Unable to detect JDK version");
                return false;
            }
            Pattern pattern = Pattern.compile(JAVA_VERSION_COMMAND_VERSION_LINE_REGEX);
            Matcher matcher = pattern.matcher(out.toString());
            if (matcher.matches()) {
                logger.println("[WeblogicDeploymentPlugin] - Pay attention to JDK version {selected version is " + matcher.group(3) + "} compatibility with WebLogic Deployer API (see Oracle documentation).");
            }
        }
        catch (IOException e) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (IllegalStateException ise) {
            return false;
        }
        catch (IndexOutOfBoundsException ioobe) {
            return false;
        }
        return true;
    }

    public static boolean isJDKValid(Node node, JDK jdk) {
        try {
            StreamTaskListener listener = new StreamTaskListener((OutputStream)new NullStream());
            Launcher launcher = node.createLauncher((TaskListener)listener);
            String cmd = new FilePath(node.getChannel(), jdk.getHome().concat("/bin/java")).getRemote();
            return launcher.launch().cmds(new String[]{cmd, "-fullversion"}).stdout((TaskListener)listener).join() == 0;
        }
        catch (IOException e) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

