/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic;

import com.google.inject.Inject;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.deploy.weblogic.Messages;
import org.jenkinsci.plugins.deploy.weblogic.PrintingWebLogicDeploymentLastSuccessResultAction;
import org.jenkinsci.plugins.deploy.weblogic.WatchingWeblogicDeploymentAction;
import org.jenkinsci.plugins.deploy.weblogic.configuration.WeblogicDeploymentConfiguration;
import org.jenkinsci.plugins.deploy.weblogic.data.DeploymentTask;
import org.jenkinsci.plugins.deploy.weblogic.data.DeploymentTaskResult;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicDeploymentStatus;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicOperationProcotol;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicPreRequisteStatus;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicStageMode;
import org.jenkinsci.plugins.deploy.weblogic.data.WeblogicEnvironment;
import org.jenkinsci.plugins.deploy.weblogic.data.policy.AbstractDeploymentPolicy;
import org.jenkinsci.plugins.deploy.weblogic.exception.DeploymentTaskException;
import org.jenkinsci.plugins.deploy.weblogic.exception.LoadingFileException;
import org.jenkinsci.plugins.deploy.weblogic.jdk.JdkToolService;
import org.jenkinsci.plugins.deploy.weblogic.task.DeploymentTaskService;
import org.jenkinsci.plugins.deploy.weblogic.task.PreRequisiteStatusUnSuccesfullPredicate;
import org.jenkinsci.plugins.deploy.weblogic.task.TaskStatusUnSuccesfullPredicate;
import org.jenkinsci.plugins.deploy.weblogic.util.BuildCauseUtils;
import org.jenkinsci.plugins.deploy.weblogic.util.DeployerClassPathUtils;
import org.jenkinsci.plugins.deploy.weblogic.util.URLUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

@Extension
public class WeblogicDeploymentPlugin
extends Recorder {
    public static final transient String DEFAULT_JAVA_OPTIONS_DEPLOYER = "-Xms256M -Xmx256M";
    @Inject
    private DeploymentTaskService deploymentTaskService;
    private boolean mustExitOnFailure = true;
    private boolean forceStopOnFirstFailure = false;
    private transient List<String> selectedDeploymentStrategyIds;
    private boolean isDeployingOnlyWhenUpdates;
    private boolean buildUnstableWhenDeploymentUnstable;
    private String deployedProjectsDependencies;
    private List<DeploymentTask> tasks = new ArrayList<DeploymentTask>();
    private DescribableList<AbstractDeploymentPolicy, Descriptor<AbstractDeploymentPolicy>> policies;

    public WeblogicDeploymentPlugin() {
    }

    @Initializer
    public static void load() {
        JdkToolService.loadJdkToolAvailables();
    }

    @DataBoundConstructor
    public WeblogicDeploymentPlugin(List<DeploymentTask> tasks, boolean mustExitOnFailure, List<String> selectedDeploymentStrategyIds, String deployedProjectsDependencies, boolean isDeployingOnlyWhenUpdates, boolean forceStopOnFirstFailure, boolean buildUnstableWhenDeploymentUnstable, String weblogicEnvironmentTargetedName, String deploymentName, String deploymentTargets, boolean isLibrary, String builtResourceRegexToDeploy, String baseResourcesGeneratedDirectory, String deploymentPlan, List<AbstractDeploymentPolicy> policies) {
        this.tasks = CollectionUtils.isNotEmpty(tasks) ? tasks : Arrays.asList(new DeploymentTask(null, null, weblogicEnvironmentTargetedName, deploymentName, deploymentTargets, isLibrary, builtResourceRegexToDeploy, baseResourcesGeneratedDirectory, null, null, null, null, deploymentPlan, null));
        this.mustExitOnFailure = mustExitOnFailure;
        this.selectedDeploymentStrategyIds = selectedDeploymentStrategyIds;
        this.deployedProjectsDependencies = deployedProjectsDependencies;
        this.isDeployingOnlyWhenUpdates = isDeployingOnlyWhenUpdates;
        this.forceStopOnFirstFailure = forceStopOnFirstFailure;
        this.buildUnstableWhenDeploymentUnstable = buildUnstableWhenDeploymentUnstable;
        this.policies = new DescribableList(Saveable.NOOP, (Collection)Util.fixNull(policies));
    }

    protected Object readResolve() {
        if (CollectionUtils.isNotEmpty(this.selectedDeploymentStrategyIds)) {
            this.policies = new DescribableList(Saveable.NOOP, (Collection)Util.fixNull(this.toDeploymentPolicyList(this.clearDeploymentStrategyIds(this.selectedDeploymentStrategyIds), this.isDeployingOnlyWhenUpdates)));
        }
        return this;
    }

    private List<AbstractDeploymentPolicy> toDeploymentPolicyList(List<String> deploymentStrategyIds, boolean deployingOnlyWhenUpdates) {
        ArrayList<AbstractDeploymentPolicy> policies = new ArrayList<AbstractDeploymentPolicy>();
        DescriptorExtensionList descriptors = Jenkins.getInstance().getDescriptorList(AbstractDeploymentPolicy.class);
        for (Descriptor descriptor : descriptors) {
            try {
                AbstractDeploymentPolicy policy = (AbstractDeploymentPolicy)descriptor.clazz.getConstructor(Boolean.TYPE).newInstance(deployingOnlyWhenUpdates);
                for (String deploymentStrategyId : deploymentStrategyIds) {
                    if (!policy.getCauseClass().getName().equals(deploymentStrategyId)) continue;
                    policies.add(policy);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return policies;
    }

    private List<String> clearDeploymentStrategyIds(List<String> deploymentStrategyIds) {
        ArrayList<String> cleared = new ArrayList<String>();
        for (String deploymentStrategyId : deploymentStrategyIds) {
            cleared.add(StringUtils.remove((String)deploymentStrategyId, (char)'\\'));
        }
        return cleared;
    }

    public boolean getMustExitOnFailure() {
        return this.mustExitOnFailure;
    }

    public List<String> getSelectedDeploymentStrategyIds() {
        return this.selectedDeploymentStrategyIds;
    }

    public String getDeployedProjectsDependencies() {
        return this.deployedProjectsDependencies;
    }

    public boolean getIsDeployingOnlyWhenUpdates() {
        return this.isDeployingOnlyWhenUpdates;
    }

    public void setDeployingOnlyWhenUpdates(boolean isDeployingOnlyWhenUpdates) {
        this.isDeployingOnlyWhenUpdates = isDeployingOnlyWhenUpdates;
    }

    public List<DeploymentTask> getTasks() {
        return this.tasks;
    }

    public List<AbstractDeploymentPolicy> getPolicies() {
        return this.policies;
    }

    public boolean getForceStopOnFirstFailure() {
        return this.forceStopOnFirstFailure;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PrintingWebLogicDeploymentLastSuccessResultAction(project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArrayList<DeploymentTaskResult> results = new ArrayList<DeploymentTaskResult>();
        WebLogicPreRequisteStatus check = this.checkPreRequisites(build, listener);
        if (check != WebLogicPreRequisteStatus.OK) {
            results.add(new DeploymentTaskResult(check, WebLogicDeploymentStatus.DISABLED, null, null));
            return this.exitPerformAction(build, listener, results);
        }
        if (this.deploymentTaskService == null) {
            this.deploymentTaskService = (DeploymentTaskService)Jenkins.getInstance().getInjector().getInstance(DeploymentTaskService.class);
        }
        for (DeploymentTask task : this.getTasks()) {
            try {
                results.add(this.deploymentTaskService.perform(task, this.getDescriptor().getJdkSelected(), build, listener, launcher));
            }
            catch (DeploymentTaskException dte) {
                results.add(dte.getResult());
                if (!this.getForceStopOnFirstFailure()) continue;
                break;
            }
        }
        return this.exitPerformAction(build, listener, results);
    }

    private WebLogicPreRequisteStatus checkPreRequisites(AbstractBuild<?, ?> build, BuildListener listener) {
        if (this.getDescriptor().isPluginDisabled()) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - The plugin execution is disabled.");
            return WebLogicPreRequisteStatus.PLUGIN_DISABLED;
        }
        if (this.policies != null && !this.policies.isEmpty() && !this.hasAtLeastOneBuildCauseChecked(build)) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - Current build cause(s) \"" + BuildCauseUtils.formatToString(build.getCauses()) + "\" do(es) not contain any of the configured \"Deployment Policies\". The plugin execution is disabled.");
            listener.getLogger().println("[WeblogicDeploymentPlugin] - Verify at \"Post-build Actions > Deploy the artifact to any Weblogic environments  > Deployment policies\" if all the appropriate policies are applied according to enabled build triggers.");
            return WebLogicPreRequisteStatus.OTHER_TRIGGER_CAUSE;
        }
        if (this.isDeployingOnlyWhenUpdates && build.getChangeSet().isEmptySet()) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - No changes. The plugin execution is disabled.");
            return WebLogicPreRequisteStatus.NO_CHANGES;
        }
        boolean satisfiedDependenciesDeployments = true;
        if (StringUtils.isNotBlank((String)this.deployedProjectsDependencies)) {
            String[] listeDependances = StringUtils.split((String)StringUtils.trim((String)this.deployedProjectsDependencies), (char)',');
            for (int i = 0; i < listeDependances.length; ++i) {
                TopLevelItem item = Hudson.getInstance().getItem(listeDependances[i]);
                if (!(item instanceof Job)) continue;
                WatchingWeblogicDeploymentAction deploymentAction = (WatchingWeblogicDeploymentAction)((Job)item).getLastBuild().getAction(WatchingWeblogicDeploymentAction.class);
                listener.getLogger().println("[WeblogicDeploymentPlugin] - Satisfying dependencies project involved: " + item.getName());
                if (deploymentAction == null || !CollectionUtils.exists(deploymentAction.getResults(), (Predicate)new TaskStatusUnSuccesfullPredicate())) continue;
                satisfiedDependenciesDeployments = false;
            }
            if (!satisfiedDependenciesDeployments) {
                listener.getLogger().println("[WeblogicDeploymentPlugin] - Not satisfied project dependencies deployment. The plugin execution is disabled.");
                return WebLogicPreRequisteStatus.UNSATISFIED_DEPENDENCIES;
            }
        }
        if (build.getResult().isWorseThan(Result.SUCCESS)) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - Build didn't finish successfully. The plugin execution is disabled.");
            return WebLogicPreRequisteStatus.BUILD_FAILED;
        }
        return WebLogicPreRequisteStatus.OK;
    }

    private boolean hasAtLeastOneBuildCauseChecked(AbstractBuild<?, ?> build) {
        for (Cause cause : build.getCauses()) {
            for (AbstractDeploymentPolicy policy : this.policies) {
                if (!policy.getCauseClass().getName().equals(cause.getClass().getName())) continue;
                if (!policy.isDeployingOnlyWhenUpdates()) {
                    return true;
                }
                if (build.getChangeSet().isEmptySet()) continue;
                return true;
            }
        }
        return false;
    }

    public WeblogicDeploymentPluginDescriptor getDescriptor() {
        return (WeblogicDeploymentPluginDescriptor)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private boolean exitPerformAction(AbstractBuild<?, ?> build, BuildListener listener, List<DeploymentTaskResult> results) {
        boolean hasUnsuccessfullPrerequisite = CollectionUtils.exists(results, (Predicate)new PreRequisiteStatusUnSuccesfullPredicate());
        boolean hasUnsuccessfullTask = CollectionUtils.exists(results, (Predicate)new TaskStatusUnSuccesfullPredicate());
        if (hasUnsuccessfullPrerequisite) {
            if (this.buildUnstableWhenDeploymentUnstable) {
                build.setResult(Result.UNSTABLE);
            }
        } else if (this.mustExitOnFailure && hasUnsuccessfullTask) {
            build.setResult(Result.FAILURE);
        }
        build.addAction((Action)new WatchingWeblogicDeploymentAction(results, build));
        listener.getLogger().println("[INFO] ------------------------------------------------------------------------");
        listener.getLogger().println("[INFO] DEPLOYMENT " + (hasUnsuccessfullPrerequisite ? Result.UNSTABLE : (hasUnsuccessfullTask ? Result.FAILURE : Result.SUCCESS)));
        listener.getLogger().println("[INFO] ------------------------------------------------------------------------");
        return true;
    }

    public boolean isBuildUnstableWhenDeploymentUnstable() {
        return this.buildUnstableWhenDeploymentUnstable;
    }

    public void setBuildUnstableWhenDeploymentUnstable(boolean buildUnstableWhenDeploymentUnstable) {
        this.buildUnstableWhenDeploymentUnstable = buildUnstableWhenDeploymentUnstable;
    }

    @Extension
    public static final class WeblogicDeploymentPluginDescriptor
    extends BuildStepDescriptor<Publisher> {
        private final transient Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        public static final transient String PLUGIN_XSD_SCHEMA_CONFIG_FILE_PATH = "/plugin/weblogic-deployer-plugin/defaultConfig/plugin-configuration.xsd";
        private String configurationFilePath;
        private boolean pluginDisabled;
        private transient WeblogicEnvironment[] weblogicEnvironments;
        private String excludedArtifactNamePattern;
        private String jdkSelected;
        private String extraClasspath;
        private String javaOpts;

        public WeblogicDeploymentPluginDescriptor() {
            super(WeblogicDeploymentPlugin.class);
            Jenkins.XSTREAM2.processAnnotations(new Class[]{WeblogicDeploymentConfiguration.class, WeblogicEnvironment.class});
            this.load();
            this.init();
        }

        private void init() {
            if (StringUtils.isBlank((String)this.javaOpts)) {
                this.javaOpts = WeblogicDeploymentPlugin.DEFAULT_JAVA_OPTIONS_DEPLOYER;
            }
        }

        public WeblogicEnvironment[] getWeblogicEnvironments() {
            if (this.weblogicEnvironments == null) {
                this.loadWeblogicEnvironments();
            }
            return this.weblogicEnvironments;
        }

        public String getDisplayName() {
            return Messages.WeblogicDeploymentPluginDescriptor_DisplayName();
        }

        public String getConfigurationFilePath() {
            return this.configurationFilePath;
        }

        public void setConfigurationFilePath(String configurationFilePath) {
            this.configurationFilePath = configurationFilePath;
        }

        public boolean isPluginDisabled() {
            return this.pluginDisabled;
        }

        public void setPluginDisabled(boolean pluginDisabled) {
            this.pluginDisabled = pluginDisabled;
        }

        public String getExcludedArtifactNamePattern() {
            return this.excludedArtifactNamePattern;
        }

        public String getExtraClasspath() {
            return this.extraClasspath;
        }

        public void setExtraClasspath(String extraClasspath) {
            this.extraClasspath = extraClasspath;
        }

        public String getJavaOpts() {
            return this.javaOpts;
        }

        public void setJavaOpts(String javaOpts) {
            this.javaOpts = javaOpts;
        }

        public String getJdkSelected() {
            return this.jdkSelected;
        }

        public void setJdkSelected(String jdkSelected) {
            this.jdkSelected = jdkSelected;
        }

        public WebLogicStageMode[] getWeblogicStageModes() {
            return WebLogicStageMode.values();
        }

        public WebLogicOperationProcotol[] getWeblogicOperationProtocols() {
            return WebLogicOperationProcotol.values();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.pluginDisabled = json.getBoolean("pluginDisabled");
            this.excludedArtifactNamePattern = json.getString("excludedArtifactNamePattern");
            this.extraClasspath = StringUtils.isNotBlank((String)json.getString("extraClasspath")) ? json.getString("extraClasspath") : DeployerClassPathUtils.getDefaultPathToWebLogicJar();
            this.javaOpts = json.getString("javaOpts");
            this.jdkSelected = json.getString("jdkSelected");
            this.configurationFilePath = json.getString("configurationFilePath");
            this.loadWeblogicEnvironments();
            this.save();
            return true;
        }

        private void loadWeblogicEnvironments() {
            InputStream configurationFileInputStream = null;
            try {
                WeblogicDeploymentConfiguration weblogicDeploymentConfiguration = null;
                if (StringUtils.isBlank((String)this.configurationFilePath)) {
                    return;
                }
                if (this.configurationFilePath.startsWith("http")) {
                    URI uri = new URI(this.configurationFilePath);
                    URL url = uri.toURL();
                    configurationFileInputStream = url.openStream();
                } else if (new File(this.configurationFilePath).exists()) {
                    configurationFileInputStream = new FileInputStream(new File(this.configurationFilePath));
                } else {
                    throw new LoadingFileException("The file content doesn't exists");
                }
                weblogicDeploymentConfiguration = (WeblogicDeploymentConfiguration)Jenkins.XSTREAM2.fromXML(configurationFileInputStream);
                if (weblogicDeploymentConfiguration != null && !ArrayUtils.isEmpty((Object[])weblogicDeploymentConfiguration.getWeblogicEnvironments())) {
                    this.weblogicEnvironments = weblogicDeploymentConfiguration.getWeblogicEnvironments();
                }
                IOUtils.closeQuietly((InputStream)configurationFileInputStream);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                throw new RuntimeException("Unable to load file", e);
            }
            finally {
                IOUtils.closeQuietly(configurationFileInputStream);
            }
        }

        public FormValidation doCheckConfigurationFilePath(@QueryParameter String value) throws IOException, ServletException {
            if (value.startsWith("http")) {
                if (!URLUtils.exists(value)) {
                    return FormValidation.error((String)("The url " + value + " can't be reached."));
                }
                return FormValidation.ok();
            }
            if (!new File(value).exists()) {
                return FormValidation.error((String)("The file " + value + " does not exists."));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckExtraClasspath(@QueryParameter String value) throws IOException, ServletException {
            String[] libs;
            if (value.length() == 0) {
                if (DeployerClassPathUtils.checkDefaultPathToWebLogicJar()) {
                    return FormValidation.warning((String)("By default, the weblogic.jar library found into " + System.getenv("WL_HOME") + "/server/lib/" + " will be used."));
                }
                return FormValidation.error((String)"The weblogic library has to be filled in.");
            }
            for (String lib : libs = value.split(File.pathSeparator)) {
                if (new File(lib).exists()) continue;
                return FormValidation.error((String)("The file " + lib + " does not exists."));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckJavaOpts(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.warning((String)"The default options -Xms256M -Xmx256M will be used.");
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteJdkName(@QueryParameter String value) {
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            for (JDK jdk : JdkToolService.getJdkToolAvailables()) {
                if (!jdk.getName().contains(value.toLowerCase())) continue;
                c.add(jdk.getName());
            }
            return c;
        }

        @JavaScriptMethod
        public String completeJdkHome(String jdkName) {
            JDK jdk = JdkToolService.getJDKByName(jdkName);
            if (jdk != null) {
                return jdk.getHome();
            }
            return "";
        }

        public FormValidation doCheckJdkName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"The name is mandatory");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckJdkHome(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"The path home is mandatory");
            }
            if (!new File(value).exists()) {
                return FormValidation.error((String)("The file " + value + " does not exists."));
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public List<? extends Descriptor<AbstractDeploymentPolicy>> getDeploymentPolicyDescriptors() {
            return Jenkins.getInstance().getDescriptorList(AbstractDeploymentPolicy.class);
        }
    }
}

