/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic.deployer;

import hudson.EnvVars;
import hudson.model.Run;
import hudson.util.ArgumentListBuilder;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicAuthenticationMode;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicStageMode;
import org.jenkinsci.plugins.deploy.weblogic.deployer.WebLogicCommand;
import org.jenkinsci.plugins.deploy.weblogic.deployer.WebLogicDeployerParameters;
import org.jenkinsci.plugins.deploy.weblogic.util.ParameterValueResolver;

public class WebLogicDeployer {
    public static final String[] getWebLogicCommandLine(WebLogicDeployerParameters parameter, EnvVars envars) {
        ArgumentListBuilder args = new ArgumentListBuilder();
        WebLogicDeployer.processJavaLauncher(parameter, args);
        args.add("-debug");
        if (!WebLogicCommand.UNDEPLOY.equals((Object)parameter.getCommand()) && !parameter.isLibrary()) {
            if (!WebLogicStageMode.bydefault.equals((Object)parameter.getStageMode())) {
                args.add("-" + parameter.getStageMode().name());
            } else {
                args.add("-stage");
            }
        }
        args.add("-remote");
        args.add("-verbose");
        if (!WebLogicCommand.UNDEPLOY.equals((Object)parameter.getCommand()) && !parameter.isLibrary()) {
            args.add("-upload");
        }
        if (parameter.isSilentMode()) {
            args.add("-noexit");
        }
        args.add("-name");
        String targetedDeploymentName = StringUtils.isNotBlank((String)parameter.getDeploymentName()) ? parameter.getDeploymentName() : parameter.getArtifactName();
        args.add(targetedDeploymentName);
        if (StringUtils.isNotBlank((String)parameter.getSource())) {
            args.add("-source");
            args.add("\"" + parameter.getSource() + "\"");
        }
        args.add("-targets");
        args.add(ParameterValueResolver.resolveEnvVar(parameter.getDeploymentTargets(), envars));
        args.add("-adminurl");
        args.add("t3://" + ParameterValueResolver.resolveEnvVar(parameter.getEnvironment().getHost(), envars) + ":" + ParameterValueResolver.resolveEnvVar(parameter.getEnvironment().getPort(), envars));
        switch (parameter.getEnvironment().getAuthMode() != null ? parameter.getEnvironment().getAuthMode() : WebLogicAuthenticationMode.BY_LOGIN) {
            case BY_KEY: {
                args.add("-userconfigfile");
                args.add(parameter.getEnvironment().getUserconfigfile());
                args.add("-userkeyfile");
                args.add(parameter.getEnvironment().getUserkeyfile());
                break;
            }
            default: {
                args.add("-user");
                args.add(ParameterValueResolver.resolveEnvVar(parameter.getEnvironment().getLogin(), envars));
                args.add("-password");
                args.add(ParameterValueResolver.resolveEnvVar(parameter.getEnvironment().getPassword(), envars));
            }
        }
        args.add("-" + parameter.getCommand().getValue());
        if (parameter.isLibrary()) {
            args.add("-library");
        }
        if (StringUtils.isNotBlank((String)parameter.getDeploymentPlan())) {
            args.add("-plan");
            args.add(parameter.getDeploymentPlan());
        }
        return args.toCommandArray();
    }

    public static final String[] getWebLogicCommandLine(WebLogicDeployerParameters parameters, String commandLine, EnvVars envars) {
        ArgumentListBuilder args = new ArgumentListBuilder();
        WebLogicDeployer.processJavaLauncher(parameters, args);
        for (String param : StringUtils.split((String)commandLine, (char)' ')) {
            args.add(ParameterValueResolver.resolveEnvVar(param, envars));
        }
        return args.toCommandArray();
    }

    private static void processJavaLauncher(WebLogicDeployerParameters parameter, ArgumentListBuilder args) {
        if (parameter.getUsedJdk() == null) {
            parameter.getListener().error("[WeblogicDeploymentPlugin] - No JDK selected to deploy artifact.");
            throw new Run.RunnerAbortedException();
        }
        args.add(parameter.getUsedJdk().getBinDir().getAbsolutePath().concat("/java"));
        if (StringUtils.isNotBlank((String)parameter.getJavaOpts())) {
            String[] javaOptions = StringUtils.split((String)parameter.getJavaOpts(), (char)' ');
            args.add(javaOptions);
        }
        args.add("-cp");
        if (StringUtils.isBlank((String)parameter.getClasspath())) {
            parameter.getListener().error("[WeblogicDeploymentPlugin] - Classpath is not set. Please configure correctly the plugin.");
            throw new Run.RunnerAbortedException();
        }
        String remotingJar = parameter.getClasspath();
        args.add(remotingJar);
        args.add("weblogic.Deployer");
    }
}

