/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.TopLevelItem;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.FileUtils;
import org.jenkinsci.plugins.deploy.weblogic.Messages;
import org.jenkinsci.plugins.deploy.weblogic.PrintingWebLogicDeploymentLastSuccessResultAction;
import org.jenkinsci.plugins.deploy.weblogic.WatchingWeblogicDeploymentAction;
import org.jenkinsci.plugins.deploy.weblogic.configuration.WeblogicDeploymentConfiguration;
import org.jenkinsci.plugins.deploy.weblogic.data.DeploymentTask;
import org.jenkinsci.plugins.deploy.weblogic.data.DeploymentTaskResult;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicDeploymentStatus;
import org.jenkinsci.plugins.deploy.weblogic.data.WeblogicEnvironment;
import org.jenkinsci.plugins.deploy.weblogic.exception.DeploymentTaskException;
import org.jenkinsci.plugins.deploy.weblogic.exception.RequiredJDKNotFoundException;
import org.jenkinsci.plugins.deploy.weblogic.task.DeploymentTaskService;
import org.jenkinsci.plugins.deploy.weblogic.task.TaskStatusUnSuccesfullPredicate;
import org.jenkinsci.plugins.deploy.weblogic.util.DeployerClassPathUtils;
import org.jenkinsci.plugins.deploy.weblogic.util.JdkUtils;
import org.jenkinsci.plugins.deploy.weblogic.util.URLUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class WeblogicDeploymentPlugin
extends Recorder {
    public static final transient String NON_DEPLOYMENT_STRATEGY_VALUE_SPECIFIED = "unknown";
    public static final transient String DEFAULT_JAVA_OPTIONS_DEPLOYER = "-Xms256M -Xmx256M";
    @Inject(optional=false)
    private DeploymentTaskService deploymentTaskService;
    private transient JDK usedJdk = null;
    private boolean mustExitOnFailure = true;
    private boolean forceStopOnFirstFailure = false;
    private List<String> selectedDeploymentStrategyIds;
    private boolean isDeployingOnlyWhenUpdates;
    private String deployedProjectsDependencies;
    private List<DeploymentTask> tasks = new ArrayList<DeploymentTask>();

    public WeblogicDeploymentPlugin() {
    }

    @DataBoundConstructor
    public WeblogicDeploymentPlugin(List<DeploymentTask> tasks, boolean mustExitOnFailure, List<String> selectedDeploymentStrategyIds, String deployedProjectsDependencies, boolean isDeployingOnlyWhenUpdates, boolean forceStopOnFirstFailure, String weblogicEnvironmentTargetedName, String deploymentName, String deploymentTargets, boolean isLibrary, String builtResourceRegexToDeploy, String baseResourcesGeneratedDirectory) {
        this.tasks = CollectionUtils.isNotEmpty(tasks) ? tasks : Arrays.asList(new DeploymentTask(null, null, weblogicEnvironmentTargetedName, deploymentName, deploymentTargets, isLibrary, builtResourceRegexToDeploy, baseResourcesGeneratedDirectory));
        this.mustExitOnFailure = mustExitOnFailure;
        this.selectedDeploymentStrategyIds = selectedDeploymentStrategyIds;
        this.deployedProjectsDependencies = deployedProjectsDependencies;
        this.isDeployingOnlyWhenUpdates = isDeployingOnlyWhenUpdates;
        this.forceStopOnFirstFailure = forceStopOnFirstFailure;
    }

    public boolean getMustExitOnFailure() {
        return this.mustExitOnFailure;
    }

    public List<String> getSelectedDeploymentStrategyIds() {
        return this.selectedDeploymentStrategyIds;
    }

    public String getDeployedProjectsDependencies() {
        return this.deployedProjectsDependencies;
    }

    public boolean getIsDeployingOnlyWhenUpdates() {
        return this.isDeployingOnlyWhenUpdates;
    }

    public void setDeployingOnlyWhenUpdates(boolean isDeployingOnlyWhenUpdates) {
        this.isDeployingOnlyWhenUpdates = isDeployingOnlyWhenUpdates;
    }

    public List<DeploymentTask> getTasks() {
        return this.tasks;
    }

    public boolean getForceStopOnFirstFailure() {
        return this.forceStopOnFirstFailure;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PrintingWebLogicDeploymentLastSuccessResultAction(project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArrayList<DeploymentTaskResult> results = new ArrayList<DeploymentTaskResult>();
        if (!this.checkPreRequisites(build, launcher, listener)) {
            results.add(new DeploymentTaskResult(WebLogicDeploymentStatus.DISABLED, null, null));
            return this.exitPerformAction(build, listener, results);
        }
        if (this.deploymentTaskService == null) {
            this.deploymentTaskService = (DeploymentTaskService)Hudson.getInstance().getInjector().getInstance(DeploymentTaskService.class);
        }
        for (DeploymentTask task : this.getTasks()) {
            try {
                results.add(this.deploymentTaskService.perform(task, this.usedJdk, build, listener, launcher));
            }
            catch (DeploymentTaskException dte) {
                results.add(dte.getResult());
                if (!this.getForceStopOnFirstFailure()) continue;
                break;
            }
        }
        return this.exitPerformAction(build, listener, results);
    }

    private boolean checkPreRequisites(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (this.getDescriptor().isPluginDisabled()) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - The plugin execution is disabled.");
            return false;
        }
        boolean isSpecifiedDeploymentStrategyValue = true;
        if (CollectionUtils.isEmpty(this.selectedDeploymentStrategyIds) || this.selectedDeploymentStrategyIds.size() == 1 && this.selectedDeploymentStrategyIds.contains(NON_DEPLOYMENT_STRATEGY_VALUE_SPECIFIED)) {
            isSpecifiedDeploymentStrategyValue = false;
        }
        if (isSpecifiedDeploymentStrategyValue && !this.hasAtLeastOneBuildCauseChecked(build, this.selectedDeploymentStrategyIds)) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - Not properly build causes expected (configured=" + StringUtils.join(this.selectedDeploymentStrategyIds, (char)';') + ") (currents=" + StringUtils.join((Collection)build.getCauses(), (char)';') + ") : The plugin execution is disabled.");
            return false;
        }
        if (this.isDeployingOnlyWhenUpdates && build.getChangeSet().isEmptySet()) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - No changes : The plugin execution is disabled.");
            return false;
        }
        boolean satisfiedDependenciesDeployments = true;
        if (StringUtils.isNotBlank((String)this.deployedProjectsDependencies)) {
            String[] listeDependances = StringUtils.split((String)StringUtils.trim((String)this.deployedProjectsDependencies), (char)',');
            for (int i = 0; i < listeDependances.length; ++i) {
                TopLevelItem item = Hudson.getInstance().getItem(listeDependances[i]);
                if (!(item instanceof Job)) continue;
                WatchingWeblogicDeploymentAction deploymentAction = (WatchingWeblogicDeploymentAction)((Job)item).getLastBuild().getAction(WatchingWeblogicDeploymentAction.class);
                listener.getLogger().println("[WeblogicDeploymentPlugin] - satisfying dependencies project involved : " + item.getName());
                if (deploymentAction == null || !CollectionUtils.exists(deploymentAction.getResults(), (Predicate)new TaskStatusUnSuccesfullPredicate())) continue;
                satisfiedDependenciesDeployments = false;
            }
            if (!satisfiedDependenciesDeployments) {
                listener.getLogger().println("[WeblogicDeploymentPlugin] - Not satisfied project dependencies deployment : The plugin execution is disabled.");
                return false;
            }
        }
        if (build.getResult().isWorseThan(Result.SUCCESS)) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - build didn't finished successfully. The plugin execution is disabled.");
            return false;
        }
        try {
            this.usedJdk = JdkUtils.getSelectedJDK(this.getDescriptor().getJdkSelected(), listener.getLogger());
        }
        catch (RequiredJDKNotFoundException rjnfe) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - No JDK found. The plugin execution is disabled.");
            return false;
        }
        String valueJdk = this.usedJdk != null ? "the JDK " + this.usedJdk.getHome() + " will be used." : "no JDK retrieved.";
        listener.getLogger().println("[WeblogicDeploymentPlugin] - " + valueJdk);
        return true;
    }

    public WeblogicDeploymentPluginDescriptor getDescriptor() {
        return (WeblogicDeploymentPluginDescriptor)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private boolean hasAtLeastOneBuildCauseChecked(AbstractBuild<?, ?> build, List<String> deploymentStrategies) {
        boolean isProperlyBuildCause = false;
        ArrayList<String> searchedCauseIds = new ArrayList<String>();
        for (String elt : deploymentStrategies) {
            searchedCauseIds.add(StringUtils.remove((String)elt, (char)'\\'));
        }
        List causes = build.getCauses();
        for (Cause cause : causes) {
            if (!searchedCauseIds.contains(cause.getClass().getName())) continue;
            isProperlyBuildCause = true;
        }
        return isProperlyBuildCause;
    }

    private boolean exitPerformAction(AbstractBuild<?, ?> build, BuildListener listener, List<DeploymentTaskResult> results) {
        if (CollectionUtils.exists(results, (Predicate)new TaskStatusUnSuccesfullPredicate())) {
            if (this.mustExitOnFailure) {
                build.setResult(Result.FAILURE);
            } else {
                build.setResult(Result.SUCCESS);
            }
        } else {
            build.setResult(Result.SUCCESS);
        }
        build.addAction((Action)new WatchingWeblogicDeploymentAction(results, build));
        listener.getLogger().println("[INFO] ------------------------------------------------------------------------");
        listener.getLogger().println("[INFO] DEPLOYMENT " + build.getResult().toString());
        listener.getLogger().println("[INFO] ------------------------------------------------------------------------");
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class WeblogicDeploymentPluginDescriptor
    extends BuildStepDescriptor<Publisher> {
        public static final transient String PLUGIN_XSD_SCHEMA_CONFIG_FILE_PATH = "/plugin/weblogic-deployer-plugin/defaultConfig/plugin-configuration.xsd";
        private String configurationFilePath;
        private boolean pluginDisabled;
        private transient WeblogicEnvironment[] weblogicEnvironments;
        private String excludedArtifactNamePattern;
        private String jdkSelected;
        private String extraClasspath;
        private String javaOpts;

        public WeblogicDeploymentPluginDescriptor() {
            super(WeblogicDeploymentPlugin.class);
            Hudson.XSTREAM.processAnnotations(new Class[]{WeblogicDeploymentConfiguration.class, WeblogicEnvironment.class});
            this.load();
            this.init();
        }

        private void init() {
            if (StringUtils.isBlank((String)this.javaOpts)) {
                this.javaOpts = WeblogicDeploymentPlugin.DEFAULT_JAVA_OPTIONS_DEPLOYER;
            }
        }

        public WeblogicEnvironment[] getWeblogicEnvironments() {
            if (this.weblogicEnvironments == null) {
                this.loadWeblogicEnvironments();
            }
            return this.weblogicEnvironments;
        }

        public String getDisplayName() {
            return Messages.WeblogicDeploymentPluginDescriptor_DisplayName();
        }

        public String getConfigurationFilePath() {
            return this.configurationFilePath;
        }

        public void setConfigurationFilePath(String configurationFilePath) {
            this.configurationFilePath = configurationFilePath;
        }

        public boolean isPluginDisabled() {
            return this.pluginDisabled;
        }

        public void setPluginDisabled(boolean pluginDisabled) {
            this.pluginDisabled = pluginDisabled;
        }

        public String getExcludedArtifactNamePattern() {
            return this.excludedArtifactNamePattern;
        }

        public String getExtraClasspath() {
            return this.extraClasspath;
        }

        public void setExtraClasspath(String extraClasspath) {
            this.extraClasspath = extraClasspath;
        }

        public String getJavaOpts() {
            return this.javaOpts;
        }

        public void setJavaOpts(String javaOpts) {
            this.javaOpts = javaOpts;
        }

        public String getJdkSelected() {
            return this.jdkSelected;
        }

        public void setJdkSelected(String jdkSelected) {
            this.jdkSelected = jdkSelected;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.pluginDisabled = json.getBoolean("pluginDisabled");
            this.excludedArtifactNamePattern = json.getString("excludedArtifactNamePattern");
            this.extraClasspath = StringUtils.isNotBlank((String)json.getString("extraClasspath")) ? json.getString("extraClasspath") : DeployerClassPathUtils.getDefaultPathToWebLogicJar();
            this.javaOpts = json.getString("javaOpts");
            this.jdkSelected = json.getString("jdkSelected");
            this.configurationFilePath = json.getString("configurationFilePath");
            this.loadWeblogicEnvironments();
            this.save();
            return true;
        }

        private void loadWeblogicEnvironments() {
            try {
                WeblogicDeploymentConfiguration weblogicDeploymentConfiguration = null;
                if (StringUtils.isBlank((String)this.configurationFilePath)) {
                    return;
                }
                if (this.configurationFilePath.startsWith("http")) {
                    URI uri = new URI(this.configurationFilePath);
                    URL url = uri.toURL();
                    weblogicDeploymentConfiguration = (WeblogicDeploymentConfiguration)Hudson.XSTREAM.fromXML(url.openStream());
                } else if (FileUtils.fileExists((String)this.configurationFilePath)) {
                    weblogicDeploymentConfiguration = (WeblogicDeploymentConfiguration)Hudson.XSTREAM.fromXML((InputStream)new FileInputStream(FileUtils.getFile((String)this.configurationFilePath)));
                }
                if (weblogicDeploymentConfiguration != null && !ArrayUtils.isEmpty((Object[])weblogicDeploymentConfiguration.getWeblogicEnvironments())) {
                    this.weblogicEnvironments = weblogicDeploymentConfiguration.getWeblogicEnvironments();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public FormValidation doCheckConfigurationFilePath(@QueryParameter String value) throws IOException, ServletException {
            if (value.startsWith("http")) {
                if (!URLUtils.exists(value)) {
                    return FormValidation.error((String)("The url " + value + " can't be reached."));
                }
                return FormValidation.ok();
            }
            if (!FileUtils.fileExists((String)value)) {
                return FormValidation.error((String)("The file " + value + " does not exists."));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckExtraClasspath(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                if (DeployerClassPathUtils.checkDefaultPathToWebLogicJar()) {
                    return FormValidation.warning((String)("By default, the weblogic.jar library found into " + System.getenv("WL_HOME") + "/server/lib/" + " will be used."));
                }
                return FormValidation.error((String)"The weblogic library has to be filled in.");
            }
            if (!FileUtils.fileExists((String)value)) {
                return FormValidation.error((String)("The file " + value + " does not exists."));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckJavaOpts(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.warning((String)"The default options -Xms256M -Xmx256M will be used.");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

