/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic;

import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.MavenAbstractArtifactRecord;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jenkinsci.plugins.deploy.weblogic.ArtifactSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenJobArtifactSelectorImpl
implements ArtifactSelector {
    private static final transient Pattern ARTIFACT_DEPLOYABLE_PATTERN = Pattern.compile(".*\\.(ear|war|jar)", 2);

    @Override
    public FilePath selectArtifactRecorded(AbstractBuild<?, ?> build, BuildListener listener, String filteredResource, String baseDirectory) throws IOException, XmlPullParserException, InterruptedException {
        FilePath selectedArtifact = null;
        List<MavenAbstractArtifactRecord<MavenBuild>> mars = this.getActions(build, listener);
        if (mars == null || mars.isEmpty()) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - No artifacts are recorded. Is this a Maven project?");
        }
        listener.getLogger().println("[WeblogicDeploymentPlugin] - Retrieving artifacts recorded [filtered resources on " + filteredResource + "]...");
        ArrayList<Run.Artifact> artifactsRecorded = new ArrayList<Run.Artifact>();
        for (MavenAbstractArtifactRecord<MavenBuild> mar : mars) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - " + ((MavenBuild)mar.getBuild()).getArtifacts().size() + " artifacts recorded in " + ((MavenBuild)mar.getBuild()).getArtifactsDir());
            for (Run.Artifact artifact : ((MavenBuild)mar.getBuild()).getArtifacts()) {
                if (StringUtils.isNotEmpty((String)filteredResource)) {
                    if (Pattern.matches(filteredResource, artifact.getFileName())) {
                        listener.getLogger().println("[WeblogicDeploymentPlugin] - the following artifact recorded " + artifact.getFileName() + " is eligible.");
                        artifactsRecorded.add(artifact);
                        continue;
                    }
                    listener.getLogger().println("[WeblogicDeploymentPlugin] - the following artifact " + artifact.getFileName() + " doesn't match " + filteredResource);
                    continue;
                }
                Matcher matcher = ARTIFACT_DEPLOYABLE_PATTERN.matcher(artifact.getFileName());
                while (matcher.find()) {
                    listener.getLogger().println("[WeblogicDeploymentPlugin] - the following artifact recorded " + artifact.getFileName() + " is eligible.");
                    artifactsRecorded.add(artifact);
                }
            }
        }
        if (artifactsRecorded.size() < 1) {
            throw new RuntimeException("[WeblogicDeploymentPlugin] - No artifact to deploy found.");
        }
        if (artifactsRecorded.size() > 1) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - More than 1 artifact found : The first one " + artifactsRecorded.get(0) + " will be deployed!!!");
        }
        if (artifactsRecorded.get(0) != null && ((Run.Artifact)artifactsRecorded.get(0)).getFile() != null) {
            selectedArtifact = new FilePath(((Run.Artifact)artifactsRecorded.get(0)).getFile());
        }
        if (selectedArtifact == null) {
            throw new RuntimeException("No artifact to deploy found.");
        }
        return selectedArtifact;
    }

    protected List<MavenAbstractArtifactRecord<MavenBuild>> getActions(AbstractBuild<?, ?> build, BuildListener listener) {
        ArrayList<MavenAbstractArtifactRecord<MavenBuild>> actions = new ArrayList<MavenAbstractArtifactRecord<MavenBuild>>();
        if (!(build instanceof MavenModuleSetBuild)) {
            return actions;
        }
        for (Map.Entry e : ((MavenModuleSetBuild)build).getModuleLastBuilds().entrySet()) {
            MavenAbstractArtifactRecord a = (MavenAbstractArtifactRecord)((MavenBuild)e.getValue()).getAction(MavenAbstractArtifactRecord.class);
            if (a == null) {
                listener.getLogger().println("[WeblogicDeploymentPlugin] - No artifacts are recorded for module" + ((MavenModule)e.getKey()).getName() + ". Is this a Maven project?");
                continue;
            }
            actions.add((MavenAbstractArtifactRecord<MavenBuild>)a);
        }
        return actions;
    }
}

