/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Rename
extends VSphereBuildStep {
    private final String oldName;
    private final String newName;

    @DataBoundConstructor
    public Rename(String oldName, String newName) throws VSphereException {
        this.oldName = oldName;
        this.newName = newName;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedOldName = env.expand(this.oldName);
        String expandedNewName = env.expand(this.newName);
        VSphereLogger.vsLogger(jLogger, "Renaming VM \"" + expandedOldName + ".\" to \"" + expandedNewName + "\" Please wait ...");
        this.vsphere.renameVm(expandedOldName, expandedNewName);
        VSphereLogger.vsLogger(jLogger, "Renamed!");
        return true;
    }

    @Extension
    public static final class RenameDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public RenameDescriptor() {
            this.load();
        }

        public FormValidation doCheckOldName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.vm_title_Rename();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String oldName, @QueryParameter String newName) {
            try {
                if (serverName.length() == 0 || oldName.length() == 0 || newName.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = RenameDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                VirtualMachine vmObj = vsphere.getVmByName(oldName);
                if (vmObj == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

