/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.VirtualController;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecFileOperation;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualDeviceFileBackingInfo;
import com.vmware.vim25.VirtualDisk;
import com.vmware.vim25.VirtualDiskFlatVer2BackingInfo;
import com.vmware.vim25.VirtualLsiLogicController;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualPCIController;
import com.vmware.vim25.VirtualSCSIController;
import com.vmware.vim25.VirtualSCSISharing;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.builders.ReconfigureStep;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ReconfigureDisk
extends ReconfigureStep {
    private final String diskSize;
    private final String datastore;
    private static final Pattern filenamePattern = Pattern.compile("^\\[[^]]*\\] (.*)$");

    @DataBoundConstructor
    public ReconfigureDisk(String diskSize, String datastore) throws VSphereException {
        this.diskSize = diskSize;
        this.datastore = datastore;
    }

    public String getDiskSize() {
        return this.diskSize;
    }

    public String getDataStore() {
        return this.datastore;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        PrintStream jLogger = listener.getLogger();
        try {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            env.overrideAll(build.getBuildVariables());
            int diskSize = Integer.parseInt(env.expand(this.diskSize));
            VirtualDeviceConfigSpec vdiskSpec = this.createAddDiskConfigSpec(this.vm, diskSize, jLogger);
            VirtualDeviceConfigSpec[] vdiskSpecArray = new VirtualDeviceConfigSpec[]{vdiskSpec};
            this.spec.setDeviceChange(vdiskSpecArray);
            VSphereLogger.vsLogger(jLogger, "Configuration done");
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        return true;
    }

    private VirtualDeviceConfigSpec createAddDiskConfigSpec(VirtualMachine vm, int diskSize, PrintStream jLogger) throws Exception {
        return this.createAddDiskConfigSpec(vm, diskSize, jLogger, 0);
    }

    private VirtualDeviceConfigSpec createAddDiskConfigSpec(VirtualMachine vm, int diskSize, PrintStream jLogger, Integer retry) throws Exception {
        VirtualDeviceConfigSpec diskSpec = new VirtualDeviceConfigSpec();
        VirtualDisk disk = new VirtualDisk();
        VirtualDiskFlatVer2BackingInfo diskfileBacking = new VirtualDiskFlatVer2BackingInfo();
        VirtualSCSIController scsiController = null;
        int key = 0;
        int diskSizeInKB = diskSize * 1024 * 1024;
        String diskMode = "persistent";
        HashMap<String, Boolean> diskNames = new HashMap<String, Boolean>();
        for (VirtualDevice vmDevice : vm.getConfig().getHardware().getDevice()) {
            if (vmDevice instanceof VirtualSCSIController) {
                int[] list = ((VirtualSCSIController)vmDevice).getDevice();
                if (scsiController != null || list != null && list.length >= 15) continue;
                scsiController = (VirtualSCSIController)vmDevice;
                continue;
            }
            if (!(vmDevice instanceof VirtualDisk) || !(vmDevice.getBacking() instanceof VirtualDeviceFileBackingInfo)) continue;
            VirtualDeviceFileBackingInfo info = (VirtualDeviceFileBackingInfo)vmDevice.getBacking();
            Matcher m = filenamePattern.matcher(info.getFileName());
            if (m.matches()) {
                diskNames.put(m.group(1), true);
                continue;
            }
            VSphereLogger.vsLogger(jLogger, String.format("Warning: unreconnized disk filename format: %s", info.getFileName()));
        }
        String diskName = null;
        int i = 1;
        while (true) {
            if (!diskNames.containsKey(String.format("%s/%s_%d.vmdk", vm.getName(), vm.getName(), i))) break;
            ++i;
        }
        diskName = String.format("%s_%d", vm.getName(), i);
        VSphereLogger.vsLogger(jLogger, String.format("Preparing to add disk %s of %dGB", diskName, diskSize));
        if (scsiController == null) {
            if (retry > 1) {
                throw new VSphereException("Unable to add a SCSI Controller");
            }
            VSphereLogger.vsLogger(jLogger, String.format("Adding a SCSI Controller", new Object[0]));
            this.addSCSIController(vm);
            return this.createAddDiskConfigSpec(vm, diskSize, jLogger, retry + 1);
        }
        int unitNumber = this.selectUnitNumber(vm, (VirtualController)scsiController);
        key = scsiController.getKey();
        VSphereLogger.vsLogger(jLogger, String.format("Controller key: %d Unit Number %d", key, unitNumber));
        String dsName = this.selectDatastore(diskSizeInKB, jLogger);
        if (dsName == null) {
            return null;
        }
        String fileName = "[" + dsName + "] " + vm.getName() + "/" + diskName + ".vmdk";
        diskfileBacking.setFileName(fileName);
        diskfileBacking.setDiskMode(diskMode);
        disk.setControllerKey(Integer.valueOf(key));
        disk.setUnitNumber(Integer.valueOf(unitNumber));
        disk.setBacking((VirtualDeviceBackingInfo)diskfileBacking);
        disk.setCapacityInKB((long)diskSizeInKB);
        disk.setKey(-1);
        diskSpec.setOperation(VirtualDeviceConfigSpecOperation.add);
        diskSpec.setFileOperation(VirtualDeviceConfigSpecFileOperation.create);
        diskSpec.setDevice((VirtualDevice)disk);
        return diskSpec;
    }

    private VirtualLsiLogicController addSCSIController(VirtualMachine vm) throws Exception {
        VirtualMachineConfigInfo vmConfig = vm.getConfig();
        VirtualPCIController pci = null;
        HashSet<Integer> scsiBuses = new HashSet<Integer>();
        for (VirtualDevice vmDevice : vmConfig.getHardware().getDevice()) {
            if (vmDevice instanceof VirtualPCIController) {
                pci = (VirtualPCIController)vmDevice;
                continue;
            }
            if (!(vmDevice instanceof VirtualSCSIController)) continue;
            VirtualSCSIController ctrl = (VirtualSCSIController)vmDevice;
            scsiBuses.add(ctrl.getBusNumber());
        }
        if (pci == null) {
            throw new VSphereException("No PCI controller found");
        }
        VirtualMachineConfigSpec vmSpec = new VirtualMachineConfigSpec();
        VirtualDeviceConfigSpec deviceSpec = new VirtualDeviceConfigSpec();
        deviceSpec.setOperation(VirtualDeviceConfigSpecOperation.add);
        VirtualLsiLogicController scsiCtrl = new VirtualLsiLogicController();
        scsiCtrl.setControllerKey(Integer.valueOf(pci.getKey()));
        scsiCtrl.setSharedBus(VirtualSCSISharing.noSharing);
        int i = 0;
        while (true) {
            if (!scsiBuses.contains(i)) break;
            ++i;
        }
        scsiCtrl.setBusNumber(i);
        deviceSpec.setDevice((VirtualDevice)scsiCtrl);
        vmSpec.setDeviceChange(new VirtualDeviceConfigSpec[]{deviceSpec});
        Task task = vm.reconfigVM_Task(vmSpec);
        task.waitForTask();
        return scsiCtrl;
    }

    private int selectUnitNumber(VirtualMachine vm, VirtualController controller) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        int unitNumber = 0;
        map.put(7, true);
        for (VirtualDevice vmDevice : vm.getConfig().getHardware().getDevice()) {
            if (vmDevice.getUnitNumber() == null || vmDevice.getControllerKey().intValue() != controller.getKey() && vmDevice.getKey() != controller.getKey()) continue;
            map.put(vmDevice.getUnitNumber(), true);
        }
        while (map.containsKey(unitNumber)) {
            ++unitNumber;
        }
        return unitNumber;
    }

    private String selectDatastore(int sizeInKB, PrintStream jLogger) throws Exception {
        Datastore datastore = null;
        long freeSpace = 0L;
        for (ManagedEntity entity : this.vsphere.getDatastores()) {
            if (!(entity instanceof Datastore)) continue;
            Datastore ds = (Datastore)entity;
            long fs = ds.getSummary().getFreeSpace();
            if (this.datastore != null && this.datastore.length() > 0 && !ds.getName().equals(this.datastore) || fs <= (long)sizeInKB || fs <= freeSpace) continue;
            datastore = ds;
            freeSpace = fs;
        }
        if (datastore == null) {
            throw new VSphereException("No datastore with enough space found");
        }
        VSphereLogger.vsLogger(jLogger, String.format("Selected datastore `%s` with free size: %dGB", datastore.getName(), freeSpace / 1024L / 1024L / 1024L));
        return datastore.getName();
    }

    @Extension
    public static final class ReconfigureDiskDescriptor
    extends ReconfigureStep.ReconfigureStepDescriptor {
        public ReconfigureDiskDescriptor() {
            this.load();
        }

        public FormValidation doCheckDiskSize(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("Disk size"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDatastore(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.vm_title_ReconfigureDisk();
        }

        public FormValidation doTestData(@QueryParameter String diskSize, @QueryParameter String datastore) {
            try {
                if (Integer.valueOf(diskSize) < 0) {
                    return FormValidation.error((String)Messages.validation_positiveInteger(diskSize));
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

