/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere;

import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Items;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.PrintStream;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;

public class VSphereBuildStepContainer
extends Builder {
    public static final String SELECTABLE_SERVER_NAME = "${VSPHERE_CLOUD_NAME}";
    private final VSphereBuildStep buildStep;
    private final String serverName;
    private final Integer serverHash;

    @DataBoundConstructor
    public VSphereBuildStepContainer(VSphereBuildStep buildStep, String serverName) throws VSphereException {
        this.buildStep = buildStep;
        this.serverName = serverName;
        this.serverHash = !SELECTABLE_SERVER_NAME.equals(serverName) ? Integer.valueOf(VSphereBuildStep.VSphereBuildStepDescriptor.getVSphereCloudByName(serverName).getHash()) : null;
    }

    public String getServerName() {
        return this.serverName;
    }

    public VSphereBuildStep getBuildStep() {
        return this.buildStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        VSphere vsphere = null;
        try {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            env.overrideAll(build.getBuildVariables());
            String expandedServerName = env.expand(this.serverName);
            this.startLogs(listener.getLogger(), expandedServerName);
            vsphere = this.serverHash != null ? VSphereBuildStep.VSphereBuildStepDescriptor.getVSphereCloudByHash(this.serverHash).vSphereInstance() : VSphereBuildStep.VSphereBuildStepDescriptor.getVSphereCloudByName(expandedServerName).vSphereInstance();
            this.buildStep.setVsphere(vsphere);
            boolean bl = this.buildStep.perform(build, launcher, listener);
            return bl;
        }
        catch (Exception e) {
            VSphereLogger.vsLogger(listener.getLogger(), e);
        }
        finally {
            if (vsphere != null) {
                vsphere.disconnect();
            }
        }
        return false;
    }

    private void startLogs(PrintStream logger, String serverName) {
        VSphereLogger.vsLogger(logger, "");
        VSphereLogger.vsLogger(logger, Messages.console_buildStepStart(this.buildStep.getDescriptor().getDisplayName()));
        VSphereLogger.vsLogger(logger, Messages.console_usingServerConfig(serverName));
    }

    @Extension
    public static final class VSphereBuildStepContainerDescriptor
    extends BuildStepDescriptor<Builder> {
        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Items.XSTREAM2.addCompatibilityAlias("org.jenkinsci.plugins.vsphere.builders.VSphereBuildStepContainer", VSphereBuildStepContainer.class);
        }

        public String getDisplayName() {
            return Messages.plugin_title_BuildStep();
        }

        public DescriptorExtensionList<VSphereBuildStep, VSphereBuildStep.VSphereBuildStepDescriptor> getBuildSteps() {
            return VSphereBuildStep.all();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillServerNameItems() {
            ListBoxModel select = new ListBoxModel();
            try {
                boolean hasVsphereClouds = false;
                for (Cloud cloud : Hudson.getInstance().clouds) {
                    if (!(cloud instanceof vSphereCloud)) continue;
                    hasVsphereClouds = true;
                    select.add(((vSphereCloud)cloud).getVsDescription());
                }
                if (hasVsphereClouds) {
                    select.add(VSphereBuildStepContainer.SELECTABLE_SERVER_NAME);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return select;
        }
    }
}

